<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
        <!-- Dashboard Header -->
    <div class="dashboard-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h1 class="h2 mb-2">Dashboard Overview</h1>
                <p class="mb-0 opacity-75">Platform statistics and system health monitoring</p>
            </div>
            <div class="col-md-4 text-md-end">
                <div class="d-flex align-items-center justify-content-md-end gap-3">
                    <button class="btn btn-light btn-sm" onclick="exportDashboardData()">
                        <i class="bi bi-download me-2"></i>Export Data
                    </button>
                    <button class="btn btn-light btn-sm" onclick="refreshDashboard()">
                        <i class="bi bi-arrow-clockwise me-2"></i>Refresh
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <a href="<?php echo e(url('/admin/users')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-people"></i>
            </div>
            <span>Manage Users</span>
        </a>
        <a href="<?php echo e(url('/admin/posts')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-file-post"></i>
            </div>
            <span>View Posts</span>
        </a>
        <a href="<?php echo e(url('/admin/groups')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-people-fill"></i>
            </div>
            <span>Manage Groups</span>
        </a>
        <a href="<?php echo e(url('/admin/games')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-controller"></i>
            </div>
            <span>Games</span>
        </a>
        <a href="<?php echo e(url('/admin/general-settings')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-gear"></i>
            </div>
            <span>Settings</span>
        </a>
        <a href="<?php echo e(url('/admin/reports')); ?>" class="quick-action-btn">
            <div class="quick-action-icon">
                <i class="bi bi-flag"></i>
            </div>
            <span>Reports</span>
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card users">
                <div class="stat-icon">
                    <i class="bi bi-people"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['users']['total'])); ?></div>
                <div class="stat-label">Total Users</div>
                <div class="stat-change <?php echo e($stats['users']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['users']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['users']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card posts">
                <div class="stat-icon">
                    <i class="bi bi-file-post"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['posts']['total'])); ?></div>
                <div class="stat-label">Total Posts</div>
                <div class="stat-change <?php echo e($stats['posts']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['posts']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['posts']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card comments">
                <div class="stat-icon">
                    <i class="bi bi-chat-dots"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['comments']['total'])); ?></div>
                <div class="stat-label">Total Comments</div>
                <div class="stat-change <?php echo e($stats['comments']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['comments']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['comments']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card messages">
                <div class="stat-icon">
                    <i class="bi bi-envelope"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['messages']['total'])); ?></div>
                <div class="stat-label">Total Messages</div>
                <div class="stat-change <?php echo e($stats['messages']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['messages']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['messages']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Second Row of Stats -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card pages">
                <div class="stat-icon">
                    <i class="bi bi-file-earmark-text"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['pages']['total'])); ?></div>
                <div class="stat-label">Total Pages</div>
                <div class="stat-change <?php echo e($stats['pages']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['pages']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['pages']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card groups">
                <div class="stat-icon">
                    <i class="bi bi-people-fill"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['groups']['total'])); ?></div>
                <div class="stat-label">Total Groups</div>
                <div class="stat-change <?php echo e($stats['groups']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['groups']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['groups']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card games">
                <div class="stat-icon">
                    <i class="bi bi-controller"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['games']['total'])); ?></div>
                <div class="stat-label">Total Games</div>
                <div class="stat-change <?php echo e($stats['games']['growth_rate'] >= 0 ? 'positive' : 'negative'); ?>">
                    <i class="bi bi-arrow-<?php echo e($stats['games']['growth_rate'] >= 0 ? 'up' : 'down'); ?>"></i>
                    <span><?php echo e(abs($stats['games']['growth_rate'])); ?>%</span>
                    <span class="text-muted">this month</span>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="stat-card online">
                <div class="stat-icon">
                    <i class="bi bi-person-check"></i>
                </div>
                <div class="stat-number"><?php echo e(number_format($stats['users']['online'])); ?></div>
                <div class="stat-label">Online Users</div>
                <div class="stat-change positive">
                    <div class="d-flex align-items-center">
                        <div class="me-2 rounded-circle bg-success" style="width: 8px; height: 8px;"></div>
                        <span>Active now</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- Charts and Analytics -->
    <div class="row mb-4">
        <div class="col-12 col-lg-8 mb-4">
            <div class="chart-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="card-title mb-0">User Registration Trend</h5>
                    <div class="btn-group btn-group-sm">
                        <button type="button" class="btn btn-outline-secondary active" onclick="updateChartPeriod('monthly')">Monthly</button>
                        <button type="button" class="btn btn-outline-secondary" onclick="updateChartPeriod('weekly')">Weekly</button>
                        <button type="button" class="btn btn-outline-secondary" onclick="updateChartPeriod('daily')">Daily</button>
                    </div>
                </div>
                <div class="chart-container">
                    <canvas id="userGrowthChart"></canvas>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-4 mb-4">
            <div class="chart-card">
                <h5 class="card-title mb-3">Platform Metrics</h5>
                <div class="d-flex flex-column gap-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted">Posts per User</span>
                        <span class="fw-bold"><?php echo e($engagementMetrics['posts_per_user']); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted">Comments per Post</span>
                        <span class="fw-bold"><?php echo e($engagementMetrics['comments_per_post']); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted">Likes per Post</span>
                        <span class="fw-bold"><?php echo e($engagementMetrics['likes_per_post']); ?></span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted">Active Users</span>
                        <span class="fw-bold"><?php echo e($engagementMetrics['active_users_percentage']); ?>%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- Recent Activities and Top Content -->
    <div class="row mb-4">
        <div class="col-12 col-lg-6 mb-4">
            <div class="chart-card">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="card-title mb-0">Recent Activities</h5>
                    <button class="btn btn-sm btn-outline-primary" onclick="loadMoreActivities()">Load More</button>
                </div>
                <div class="activities-list">
                    <?php $__empty_1 = true; $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="activity-item">
                        <?php if(isset($activity['avatar'])): ?>
                        <img src="<?php echo e($activity['avatar']); ?>" alt="Avatar" class="activity-avatar">
                        <?php else: ?>
                        <div class="activity-icon">
                            <i class="bi <?php echo e($activity['icon']); ?>"></i>
                        </div>
                        <?php endif; ?>
                        <div class="activity-content">
                            <div class="activity-title"><?php echo e($activity['title']); ?></div>
                            <div class="activity-description"><?php echo e($activity['description']); ?></div>
                            <div class="activity-time"><?php echo e($activity['time']); ?></div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4">
                        <i class="bi bi-inbox text-muted" style="font-size: 2rem;"></i>
                        <p class="text-muted mt-2">No recent activities</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
                <div class="col-12 col-lg-6 mb-4">
            <div class="content-table">
                <div class="d-flex justify-content-between align-items-center p-3 border-bottom">
                    <h5 class="card-title mb-0">Popular Content</h5>
                    <button class="btn btn-sm btn-outline-primary" onclick="refreshTopContent()">Refresh</button>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Content</th>
                                <th>Type</th>
                                <th>Engagement</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $topContent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="<?php echo e($content['avatar']); ?>" alt="Content" class="rounded me-2" style="width: 32px; height: 32px; object-fit: cover;">
                                        <div>
                                            <div class="fw-medium"><?php echo e($content['title']); ?></div>
                                            <small class="text-muted"><?php echo e($content['subtitle']); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td><span class="badge bg-light text-dark"><?php echo e(ucfirst($content['type'])); ?></span></td>
                                <td><?php echo e(number_format($content['views'])); ?></td>
                                <td><span class="badge bg-success"><?php echo e($content['growth']); ?></span></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4">
                                    <i class="bi bi-inbox text-muted" style="font-size: 1.5rem;"></i>
                                    <p class="text-muted mt-2 mb-0">No content data available</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- System Health -->
    <div class="row">
        <div class="col-12 col-lg-6 mb-4">
            <div class="system-health-card">
                <h5 class="card-title mb-3">System Health</h5>
                <div class="d-flex flex-column gap-3">
                    <div class="health-item">
                        <span class="health-label">Disk Usage</span>
                        <div class="d-flex align-items-center gap-2">
                            <div class="progress-ring">
                                <svg>
                                    <circle class="bg" cx="30" cy="30" r="26"></circle>
                                    <circle class="progress" cx="30" cy="30" r="26" 
                                            stroke-dasharray="<?php echo e(2 * pi() * 26 * ($systemHealth['disk_usage'] / 100)); ?> <?php echo e(2 * pi() * 26); ?>"></circle>
                                </svg>
                            </div>
                            <span class="health-value"><?php echo e($systemHealth['disk_usage']); ?>%</span>
                        </div>
                    </div>
                    <div class="health-item">
                        <span class="health-label">Memory Usage</span>
                        <div class="d-flex align-items-center gap-2">
                            <div class="progress-ring">
                                <svg>
                                    <circle class="bg" cx="30" cy="30" r="26"></circle>
                                    <circle class="progress" cx="30" cy="30" r="26" 
                                            stroke-dasharray="<?php echo e(2 * pi() * 26 * ($systemHealth['memory_usage'] / 100)); ?> <?php echo e(2 * pi() * 26); ?>"></circle>
                                </svg>
                            </div>
                            <span class="health-value"><?php echo e($systemHealth['memory_usage']); ?>%</span>
                        </div>
                    </div>
                    <div class="health-item">
                        <span class="health-label">Database</span>
                        <span class="health-status <?php echo e($systemHealth['database_connections'] === 'Connected' ? 'good' : 'danger'); ?>">
                            <?php echo e($systemHealth['database_connections']); ?>

                        </span>
                    </div>
                    <div class="health-item">
                        <span class="health-label">Cache</span>
                        <span class="health-status good"><?php echo e($systemHealth['cache_status']); ?></span>
                    </div>
                    <div class="health-item">
                        <span class="health-label">Queue</span>
                        <span class="health-status good"><?php echo e($systemHealth['queue_status']); ?></span>
                    </div>
                    <div class="health-item">
                        <span class="health-label">Last Backup</span>
                        <span class="health-value"><?php echo e($systemHealth['last_backup']); ?></span>
                    </div>
                    <div class="health-item">
                        <span class="health-label">System Uptime</span>
                        <span class="health-value"><?php echo e($systemHealth['system_uptime']); ?></span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 mb-4">
            <div class="chart-card">
                <h5 class="card-title mb-3">Platform Overview</h5>
                <div class="row text-center">
                    <div class="col-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <div class="h4 mb-1 text-primary"><?php echo e(number_format($stats['users']['active'])); ?></div>
                            <small class="text-muted">Active Users</small>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <div class="h4 mb-1 text-success"><?php echo e(number_format($stats['posts']['this_month'])); ?></div>
                            <small class="text-muted">Posts This Month</small>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <div class="h4 mb-1 text-info"><?php echo e(number_format($stats['comments']['this_month'])); ?></div>
                            <small class="text-muted">Comments This Month</small>
                        </div>
                    </div>
                    <div class="col-6 mb-3">
                        <div class="p-3 bg-light rounded">
                            <div class="h4 mb-1 text-warning"><?php echo e(number_format($stats['groups']['this_month'])); ?></div>
                            <small class="text-muted">New Groups</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// User Growth Chart
const userGrowthCtx = document.getElementById('userGrowthChart').getContext('2d');
const userGrowthChart = new Chart(userGrowthCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(collect($userGrowthData)->pluck('month'), 15, 512) ?>,
        datasets: [{
            label: 'New Users',
            data: <?php echo json_encode(collect($userGrowthData)->pluck('users'), 15, 512) ?>,
            borderColor: '#3b7ddd',
            backgroundColor: 'rgba(59, 125, 221, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4,
            pointBackgroundColor: '#3b7ddd',
            pointBorderColor: '#fff',
            pointBorderWidth: 2,
            pointRadius: 6,
            pointHoverRadius: 8
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                grid: {
                    color: 'rgba(0, 0, 0, 0.05)'
                }
            },
            x: {
                grid: {
                    display: false
                }
            }
        },
        interaction: {
            intersect: false,
            mode: 'index'
        }
    }
});

// Export Dashboard Data Function
function exportDashboardData() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Exporting...';
    btn.disabled = true;
    
    // Create CSV data
    const csvData = [
        ['Dashboard Report', 'Generated on: ' + new Date().toLocaleDateString()],
        [''],
        ['Statistics'],
        ['Total Users', '<?php echo e(number_format($stats["users"]["total"])); ?>'],
        ['Total Posts', '<?php echo e(number_format($stats["posts"]["total"])); ?>'],
        ['Total Comments', '<?php echo e(number_format($stats["comments"]["total"])); ?>'],
        ['Total Messages', '<?php echo e(number_format($stats["messages"]["total"])); ?>'],
        ['Total Pages', '<?php echo e(number_format($stats["pages"]["total"])); ?>'],
        ['Total Groups', '<?php echo e(number_format($stats["groups"]["total"])); ?>'],
        ['Total Games', '<?php echo e(number_format($stats["games"]["total"])); ?>'],
        [''],
        ['System Health'],
        ['Disk Usage', '<?php echo e($systemHealth["disk_usage"]); ?>%'],
        ['Memory Usage', '<?php echo e($systemHealth["memory_usage"]); ?>%'],
        ['Database Status', '<?php echo e($systemHealth["database_connections"]); ?>'],
        ['Cache Status', '<?php echo e($systemHealth["cache_status"]); ?>'],
        ['Queue Status', '<?php echo e($systemHealth["queue_status"]); ?>']
    ];
    
    // Convert to CSV string
    const csvContent = csvData.map(row => row.join(',')).join('\n');
    
    // Create and download file
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    const url = URL.createObjectURL(blob);
    link.setAttribute('href', url);
    link.setAttribute('download', 'dashboard_report_' + new Date().toISOString().split('T')[0] + '.csv');
    link.style.visibility = 'hidden';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    
    // Reset button
    setTimeout(() => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        
        // Show success message
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                icon: 'success',
                title: 'Export Complete!',
                text: 'Dashboard data has been exported successfully.',
                confirmButtonColor: '#3b7ddd'
            });
        } else {
            alert('Dashboard data exported successfully!');
        }
    }, 1000);
}

// Refresh Dashboard Function
function refreshDashboard() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-arrow-clockwise me-2"></i>Refreshing...';
    btn.disabled = true;
    
    // Reload the page to refresh data
    setTimeout(() => {
        window.location.reload();
    }, 1000);
}

// Update Chart Period Function
function updateChartPeriod(period) {
    // Remove active class from all buttons
    document.querySelectorAll('.btn-group .btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    // Add active class to clicked button
    event.target.classList.add('active');
    
    // Here you can implement AJAX call to get data for different periods
    console.log('Updating chart for period:', period);
    
    // For now, just show a message
    if (typeof Swal !== 'undefined') {
        Swal.fire({
            icon: 'info',
            title: 'Chart Update',
            text: 'Chart period updated to ' + period + '. Implement AJAX call to fetch new data.',
            confirmButtonColor: '#3b7ddd'
        });
    }
}

// Load More Activities Function
function loadMoreActivities() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Loading...';
    btn.disabled = true;
    
    // Simulate loading more activities
    setTimeout(() => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                icon: 'info',
                title: 'Load More',
                text: 'Implement AJAX call to load more activities.',
                confirmButtonColor: '#3b7ddd'
            });
        }
    }, 1000);
}

// Refresh Top Content Function
function refreshTopContent() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="bi bi-arrow-clockwise me-2"></i>Refreshing...';
    btn.disabled = true;
    
    // Simulate refreshing top content
    setTimeout(() => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                icon: 'success',
                title: 'Content Refreshed',
                text: 'Popular content has been updated.',
                confirmButtonColor: '#3b7ddd'
            });
        }
    }, 1000);
}

// Auto-refresh dashboard data every 5 minutes
setInterval(() => {
    console.log('Auto-refreshing dashboard data...');
    // Implement AJAX call here to refresh data without page reload
}, 300000);

// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/dashboard/index.blade.php ENDPATH**/ ?>