<?php $__env->startSection('title', 'Notification Settings - Socialink'); ?>

<?php $__env->startPush('styles'); ?>
<style>
  
    .section-divider {
        height: 1px;
        background-color: #e9ecef;
        margin: 2rem 0;
    }

    .settings-section {
        margin-bottom: 2rem;
    }

    .settings-section-header {
        font-weight: 600;
        margin-bottom: 1.25rem;
        color: #343a40;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .settings-section-header svg {
        width: 20px;
        height: 20px;
    }

    .custom-select {
        border-radius: 8px;
        padding: 12px;
        border: 1px solid #ddd;
        transition: all 0.3s ease;
    }
    
    .custom-select:focus {
        border-color: #4a6cf7;
        box-shadow: 0 0 0 0.2rem rgba(74, 108, 247, 0.25);
    }

    .badge-enabled {
        background-color: #e6f7ee;
        color: #0d9a5d;
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
        border-radius: 4px;
    }

</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('settings_content'); ?>
<div class="card mb-4 border-0 shadow-sm">
    <div class="card-header with-icon p-4 bg-white">
        <div class="d-flex align-items-center">
            <div class="main-icon">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 371.263 371.263" width="32" height="32"><path d="M353.12 277.369c-2.036-21.198-20.958-37.845-42.995-37.845a4.703 4.703 0 0 1-4.731-4.731v-70.54c0-52.396-33.533-98.085-79.702-115.151.539-2.695.838-5.449.838-8.204C226.531 18.324 208.208 0 185.632 0s-40.899 18.324-40.899 40.899c0 2.695.299 5.389.778 7.964-15.868 5.629-30.539 14.551-43.054 26.647-23.593 22.755-36.587 53.354-36.587 86.169v73.115c0 2.575-2.096 4.731-4.731 4.731-22.096 0-40.959 16.647-42.995 37.845-1.138 11.797 2.755 23.533 10.719 32.276 7.904 8.683 19.222 13.713 31.018 13.713h72.217c2.994 26.887 25.869 47.905 53.534 47.905s50.54-21.018 53.534-47.905h72.217c11.797 0 23.114-5.03 31.018-13.713 7.904-8.744 11.857-20.48 10.719-32.277zM185.632 23.952c9.341 0 16.946 7.605 16.946 16.946 0 .778-.12 1.497-.24 2.275-4.072-.599-8.204-1.018-12.336-1.138-7.126-.24-14.132.24-21.078 1.198-.12-.778-.24-1.497-.24-2.275.002-9.401 7.607-17.006 16.948-17.006zm0 323.358c-14.431 0-26.527-10.3-29.342-23.952h58.683c-2.813 13.653-14.909 23.952-29.341 23.952zm139.044-53.773c-3.473 3.773-8.144 5.868-13.294 5.868h-251.5c-5.15 0-9.82-2.096-13.294-5.868-3.473-3.772-5.09-8.743-4.551-13.892.838-9.042 9.282-16.168 19.162-16.168 15.809 0 28.683-12.874 28.683-28.683v-73.115c0-26.228 10.419-50.719 29.282-68.923 17.964-17.425 41.438-26.887 66.468-26.887 1.198 0 2.335 0 3.533.06 50.839 1.796 92.277 45.929 92.277 98.325v70.54c0 15.809 12.874 28.683 28.683 28.683 9.88 0 18.324 7.126 19.162 16.168.479 5.149-1.138 10.06-4.611 13.892z" fill="currentColor"/></svg>
            </div>
            <h5 class="mb-0 ms-3 fw-bold">Notification Settings</h5>
        </div>
    </div>
    <div class="card-body p-4">
        <?php if(session('success')): ?>
        <div class="alert alert-success mb-4 d-flex align-items-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path><polyline points="22 4 12 14.01 9 11.01"></polyline></svg>
            <div><?php echo e(session('success')); ?></div>
        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="alert alert-danger mb-4 d-flex align-items-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            <div><?php echo e(session('error')); ?></div>
        </div>
        <?php endif; ?>

        <p class="text-muted mb-4">Choose when and how you want to receive notifications about activity on Socialink.</p>

        <form action="<?php echo e(route('settings.notifications.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Email Notifications Section -->
            <div class="settings-section">
                <h6 class="settings-section-header">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                    Email Notifications
                </h6>
                <div class="ps-0 ps-md-3">
                    <!-- New Messages -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">New Messages</div>
                                <div class="form-text d-none d-sm-block">Receive email notifications when you get new messages</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_new_messages">
                                    <input type="checkbox" id="email_new_messages" name="email_new_messages" <?php echo e(auth()->user()->email_new_messages ?? false ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Friend Requests -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="8.5" cy="7" r="4"></circle><line x1="20" y1="8" x2="20" y2="14"></line><line x1="23" y1="11" x2="17" y2="11"></line></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Friend Requests</div>
                                <div class="form-text d-none d-sm-block">Receive email notifications when someone sends you a friend request</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_friend_requests">
                                    <input type="checkbox" id="email_friend_requests" name="email_friend_requests" <?php echo e(auth()->user()->email_friend_requests ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Post Comments -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Post Comments</div>
                                <div class="form-text d-none d-sm-block">Receive email notifications when someone comments on your posts</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_post_comments">
                                    <input type="checkbox" id="email_post_comments" name="email_post_comments" <?php echo e(auth()->user()->email_post_comments ?? false ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Post Likes -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Post Likes</div>
                                <div class="form-text d-none d-sm-block">Receive email notifications when someone likes your posts</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_post_likes">
                                    <input type="checkbox" id="email_post_likes" name="email_post_likes" <?php echo e(auth()->user()->email_post_likes ?? false ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Mentions -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="4"></circle><path d="M16 8v5a3 3 0 0 0 6 0v-1a10 10 0 1 0-3.92 7.94"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Mentions</div>
                                <div class="form-text d-none d-sm-block">Receive email notifications when someone mentions you in a post or comment</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_mentions">
                                    <input type="checkbox" id="email_mentions" name="email_mentions" <?php echo e(auth()->user()->email_mentions ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Platform Updates -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Platform Updates and News</div>
                                <div class="form-text d-none d-sm-block">Receive emails about new features, updates, and news related to Socialink</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="email_updates">
                                    <input type="checkbox" id="email_updates" name="email_updates" <?php echo e(auth()->user()->email_updates ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="section-divider"></div>
            
            <!-- Push Notifications Section -->
            <div class="settings-section">
                <h6 class="settings-section-header">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path><path d="M13.73 21a2 2 0 0 1-3.46 0"></path></svg>
                    Push Notifications
                </h6>
                <div class="ps-0 ps-md-3">
                    <!-- New Messages -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">New Messages</div>
                                <div class="form-text d-none d-sm-block">Receive push notifications when you get new messages</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="push_new_messages">
                                    <input type="checkbox" id="push_new_messages" name="push_new_messages" <?php echo e(auth()->user()->push_new_messages ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Friend Requests -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path><circle cx="8.5" cy="7" r="4"></circle><line x1="20" y1="8" x2="20" y2="14"></line><line x1="23" y1="11" x2="17" y2="11"></line></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Friend Requests</div>
                                <div class="form-text d-none d-sm-block">Receive push notifications when someone sends you a friend request</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="push_friend_requests">
                                    <input type="checkbox" id="push_friend_requests" name="push_friend_requests" <?php echo e(auth()->user()->push_friend_requests ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Post Comments -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Post Comments</div>
                                <div class="form-text d-none d-sm-block">Receive push notifications when someone comments on your posts</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="push_post_comments">
                                    <input type="checkbox" id="push_post_comments" name="push_post_comments" <?php echo e(auth()->user()->push_post_comments ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Post Likes -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Post Likes</div>
                                <div class="form-text d-none d-sm-block">Receive push notifications when someone likes your posts</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="push_post_likes">
                                    <input type="checkbox" id="push_post_likes" name="push_post_likes" <?php echo e(auth()->user()->push_post_likes ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Mentions -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="4"></circle><path d="M16 8v5a3 3 0 0 0 6 0v-1a10 10 0 1 0-3.92 7.94"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Mentions</div>
                                <div class="form-text d-none d-sm-block">Receive push notifications when someone mentions you in a post or comment</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="push_mentions">
                                    <input type="checkbox" id="push_mentions" name="push_mentions" <?php echo e(auth()->user()->push_mentions ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="section-divider"></div>
            
            <!-- Other Notifications Section -->
            <div class="settings-section">
                <h6 class="settings-section-header">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg>
                    Other Notification Settings
                </h6>
                <div class="ps-0 ps-md-3">
                    <!-- Notification Sound -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="11 5 6 9 2 9 2 15 6 15 11 19 11 5"></polygon><path d="M15.54 8.46a5 5 0 0 1 0 7.07"></path><path d="M19.07 4.93a10 10 0 0 1 0 14.14"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Notification Sound</div>
                                <div class="form-text d-none d-sm-block">Select the sound to play when you receive a notification</div>
                            </div>
                            <div class="col-md-4">
                                <select class="form-select custom-select" id="notification_sound" name="notification_sound">
                                    <option value="default" <?php echo e(auth()->user()->notification_sound ?? 'default' == 'default' ? 'selected' : ''); ?>>Default</option>
                                    <option value="beep" <?php echo e(auth()->user()->notification_sound ?? 'default' == 'beep' ? 'selected' : ''); ?>>Beep</option>
                                    <option value="chime" <?php echo e(auth()->user()->notification_sound ?? 'default' == 'chime' ? 'selected' : ''); ?>>Chime</option>
                                    <option value="ping" <?php echo e(auth()->user()->notification_sound ?? 'default' == 'ping' ? 'selected' : ''); ?>>Ping</option>
                                    <option value="none" <?php echo e(auth()->user()->notification_sound ?? 'default' == 'none' ? 'selected' : ''); ?>>None</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Browser Notifications -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><line x1="3" y1="9" x2="21" y2="9"></line><path d="M8 21v-3a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v3"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Browser Notifications</div>
                                <div class="form-text d-none d-sm-block">Receive notifications in your browser when you're on Socialink</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="browser_notifications">
                                    <input type="checkbox" id="browser_notifications" name="browser_notifications" <?php echo e(auth()->user()->browser_notifications ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Sound Notifications -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M3 18v-6a9 9 0 0 1 18 0v6"></path><path d="M21 19a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-3a2 2 0 0 1 2-2h3zM3 19a2 2 0 0 0 2 2h1a2 2 0 0 0 2-2v-3a2 2 0 0 0-2-2H3z"></path></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Sound Notifications</div>
                                <div class="form-text d-none d-sm-block">Play a sound when you receive a notification</div>
                            </div>
                            <div class="col-auto text-end">
                                <label class="switch" for="sound_notifications">
                                    <input type="checkbox" id="sound_notifications" name="sound_notifications" <?php echo e(auth()->user()->sound_notifications ?? true ? 'checked' : ''); ?>>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Email Notification Frequency -->
                    <div class="form-table-row mb-3 p-3 border rounded">
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <div class="avatar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-label h6 mb-1">Email Notification Frequency</div>
                                <div class="form-text d-none d-sm-block">Choose how often you want to receive email notifications</div>
                            </div>
                            <div class="col-md-4">
                                <select class="form-select custom-select" id="email_notification_frequency" name="email_notification_frequency">
                                    <option value="immediately" <?php echo e(auth()->user()->email_notification_frequency ?? 'immediately' == 'immediately' ? 'selected' : ''); ?>>Immediately</option>
                                    <option value="daily" <?php echo e(auth()->user()->email_notification_frequency ?? 'immediately' == 'daily' ? 'selected' : ''); ?>>Daily digest</option>
                                    <option value="weekly" <?php echo e(auth()->user()->email_notification_frequency ?? 'immediately' == 'weekly' ? 'selected' : ''); ?>>Weekly digest</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-4 text-end">
                <button type="submit" class="btn btn-primary save-button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path><polyline points="17 21 17 13 7 13 7 21"></polyline><polyline points="7 3 7 8 15 8"></polyline></svg>
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Add JavaScript for enhanced experience -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Add animation when hovering over settings items
        const settingRows = document.querySelectorAll('.form-table-row');
        settingRows.forEach(row => {
            row.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
                this.style.boxShadow = '0 4px 12px rgba(0, 0, 0, 0.05)';
            });
            
            row.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
                this.style.boxShadow = 'none';
            });
        });
        
        // Add smooth scrolling to settings sections
        document.querySelectorAll('.settings-section-header').forEach(button => {
            button.addEventListener('click', function() {
                const targetSection = this.nextElementSibling;
                const isVisible = targetSection.style.maxHeight;
                
                if (isVisible) {
                    targetSection.style.maxHeight = null;
                } else {
                    targetSection.style.maxHeight = targetSection.scrollHeight + "px";
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('front_end.pages.settings.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/pages/settings/notifications.blade.php ENDPATH**/ ?>