<?php $__env->startSection('title', 'Help Center Articles'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Help Center Articles</h1>
            <p class="text-muted mb-0">Create step-by-step guides, FAQs, and troubleshooting docs for your community.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.help-center.topics.create')); ?>" class="btn btn-outline-primary btn-sm">
                <i class="fas fa-layer-group me-1"></i> New Topic
            </a>
            <a href="<?php echo e(route('admin.help-center.articles.create')); ?>" class="btn btn-primary btn-sm shadow-sm">
                <i class="fas fa-plus me-1"></i> New Article
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-column flex-md-row justify-content-between align-items-md-center">
            <h6 class="m-0 font-weight-bold text-primary">Knowledge Articles</h6>
            <form method="GET" class="d-flex align-items-center mt-3 mt-md-0">
                <label for="topicFilter" class="me-2 mb-0">Filter by topic:</label>
                <select name="topic_id" id="topicFilter" class="form-select form-select-sm" onchange="this.form.submit()">
                    <option value="">All topics</option>
                    <?php $__currentLoopData = $topics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($topic->id); ?>" <?php echo e((string) $selectedTopicId === (string) $topic->id ? 'selected' : ''); ?>>
                            <?php echo e($topic->title); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Article</th>
                            <th>Topic</th>
                            <th class="text-center">Featured</th>
                            <th class="text-center">Published</th>
                            <th class="text-center">Read (min)</th>
                            <th class="text-center">Order</th>
                            <th>Updated</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="fw-semibold"><?php echo e($article->title); ?></div>
                                    <small class="text-muted">/<?php echo e($article->slug); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-primary bg-opacity-10 text-primary">
                                        <?php echo e($article->topic?->title ?? '—'); ?>

                                    </span>
                                </td>
                                <td class="text-center">
                                    <?php if($article->is_featured): ?>
                                        <i class="fas fa-star text-warning"></i>
                                    <?php else: ?>
                                        <span class="text-muted">—</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if($article->is_published): ?>
                                        <span class="badge bg-success">Published</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php echo e($article->estimated_reading_time ?? '—'); ?>

                                </td>
                                <td class="text-center"><?php echo e($article->display_order); ?></td>
                                <td>
                                    <small class="text-muted"><?php echo e($article->updated_at?->diffForHumans() ?? '—'); ?></small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.help-center.articles.edit', $article)); ?>" class="btn btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.help-center.articles.destroy', $article)); ?>" method="POST" onsubmit="return confirm('Delete this article?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4 text-muted">
                                    <i class="fas fa-file-alt fa-2x mb-2 d-block"></i>
                                    <span>No help center articles found. Start by creating one.</span>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($articles->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($articles->appends(['topic_id' => $selectedTopicId])->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/help_center/articles/index.blade.php ENDPATH**/ ?>