<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="generator" content="Socialink">
    <meta name="version" content="1.0">

    <!-- SEO Meta -->
    <title>Socialink - Connect, Share, Explore</title>
    <meta name="description" content="Join Socialink - Your Digital Social Hub">
    <meta name="keywords" content="social network, connect friends, share memories, social platform">

    <!-- OG Meta -->
    <meta property="og:title" content="Welcome to Socialink">
    <meta property="og:description" content="Connect with friends, share your story, and discover amazing content">
    <meta property="og:image" content="https://example.com/og-image.jpg">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/auth.css')); ?>">
    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>


    <footer class="w-100 position-relative mt-5 footer-container">
        <div class="container">
            <div class="row align-items-center">
                <!-- Left Section: Copyright & Language Selection -->
                <div class="col-md-6 text-center text-md-start p-2">
                    <span>©<?php echo e(date('Y')); ?> <a href="<?php echo e(url('')); ?>"
                            class="footer-link"><?php echo e(setting('site_name')); ?></a> - All rights reserved.</span>
                </div>

                <!-- Right Section: Navigation Links -->
                <div class="col-md-6 text-center text-md-end">
                    <nav class="nav justify-content-center justify-content-md-end">
                        <a class="nav-link footer-link" href="<?php echo e(url('login')); ?>">Log in</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('register')); ?>">Sign Up</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('page/about-us')); ?>">About</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('page/terms-and-conditions')); ?>">Terms</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('page/privacy-policy')); ?>">Privacy</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('page/data-deletion')); ?>">Data Deletion</a>
                        <a class="nav-link footer-link" href="<?php echo e(url('page/contact-us')); ?>">Contact</a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script>
        document.querySelectorAll('.password-toggle').forEach(function(toggle) {
            const targetId = toggle.dataset.target || 'password';
            const passwordInput = document.getElementById(targetId);

            if (!passwordInput) {
                return;
            }

            toggle.addEventListener('click', function() {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                toggle.classList.toggle('fa-eye');
                toggle.classList.toggle('fa-eye-slash');
            });
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/layouts/auth.blade.php ENDPATH**/ ?>