<?php $__env->startSection('title', 'Help Center Topics'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Help Center Topics</h1>
            <p class="text-muted mb-0">Organize your support content into clear, themed topics.</p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.help-center.articles.index')); ?>" class="btn btn-outline-primary btn-sm">
                <i class="fas fa-file-alt me-1"></i> Manage Articles
            </a>
            <a href="<?php echo e(route('admin.help-center.topics.create')); ?>" class="btn btn-primary btn-sm shadow-sm">
                <i class="fas fa-plus me-1"></i> New Topic
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Topic Library</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Topic</th>
                            <th class="text-center">Articles</th>
                            <th class="text-center">Display Order</th>
                            <th>Status</th>
                            <th>Updated</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $topics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <?php if($topic->icon): ?>
                                            <span class="badge bg-primary bg-opacity-10 text-primary me-3 fs-5">
                                                <i class="<?php echo e($topic->icon); ?>"></i>
                                            </span>
                                        <?php endif; ?>
                                        <div>
                                            <div class="fw-semibold"><?php echo e($topic->title); ?></div>
                                            <small class="text-muted">/<?php echo e($topic->slug); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-secondary"><?php echo e($topic->articles()->count()); ?></span>
                                </td>
                                <td class="text-center"><?php echo e($topic->display_order); ?></td>
                                <td>
                                    <?php if($topic->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Hidden</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e($topic->updated_at?->diffForHumans() ?? '—'); ?></small>
                                </td>
                                <td class="text-end">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.help-center.topics.edit', $topic)); ?>" class="btn btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.help-center.topics.destroy', $topic)); ?>" method="POST" onsubmit="return confirm('Delete this topic?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">
                                    <i class="fas fa-folder-open fa-2x mb-2 d-block"></i>
                                    <span>No help center topics yet. Start by creating one.</span>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($topics->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($topics->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/admin/pages/help_center/topics/index.blade.php ENDPATH**/ ?>