<!-- Responsive Sidebar Toggle -->
<div class="d-flex align-items-center d-lg-none mb-4">
    <button class="btn btn-outline-primary rounded-pill px-4 py-2 border-0 shadow-sm" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSideNavbar"
        aria-controls="offcanvasSideNavbar">
        <i class="bi bi-list me-2"></i>
        <span class="fw-semibold">Menu</span>
    </button>
</div>

<!-- Sidebar Navigation -->
<nav class="navbar navbar-expand-lg mx-0">
    <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasSideNavbar">
        <!-- Offcanvas Header -->
        <div class="offcanvas-header border-bottom bg-white">
            <h5 class="offcanvas-title fw-bold text-dark mb-0">Menu</h5>
            <button type="button" class="btn-close btn-close-lg" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>

        <!-- Offcanvas Body -->
        <div class="offcanvas-body d-block px-2 px-lg-0">
            <!-- Profile Card START -->
            <?php ($user = Auth::user()); ?>
            <?php if($user): ?>
                <?php ($profileUrl = url('profile/' . $user->username)); ?>
                <div class="card profile-summary border-0 shadow-sm mb-4 overflow-hidden bg-white" style="border-radius: 12px;">
                    <div class="position-relative">
                        <div class="bg-gradient" style="height: 80px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);"></div>
                        <div class="position-absolute top-0 end-0 m-3">
                            <div class="dropdown">
                                <a class="btn btn-light btn-sm rounded-circle shadow-sm border-0" href="#" id="profileDropdown" data-bs-toggle="dropdown"
                                    aria-expanded="false" style="width: 28px; height: 28px; display: flex; align-items: center; justify-content: center;">
                                    <i class="bi bi-three-dots fs-6 text-muted"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0" style="border-radius: 8px;" aria-labelledby="profileDropdown">
                                    <li><a class="dropdown-item py-2" href="<?php echo e(route('settings.profile')); ?>"><i class="bi bi-pencil-square me-2 text-primary"></i>Edit profile</a></li>
                                    <li><a class="dropdown-item py-2" href="<?php echo e(route('settings.account')); ?>"><i class="bi bi-gear me-2 text-primary"></i>Settings</a></li>
                                    <li><hr class="dropdown-divider my-2"></li>
                                    <li><a class="dropdown-item py-2 text-danger" href="<?php echo e(route('logout')); ?>"><i class="bi bi-box-arrow-right me-2"></i>Logout</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="position-absolute top-100 start-50 translate-middle">
                            <a href="<?php echo e($profileUrl); ?>" class="d-inline-flex position-relative">
                                <img class="rounded-circle border border-3 border-white shadow-sm object-fit-cover" width="72" height="72"
                                    src="<?php echo e(getMedia($user->avatar, 'avatar')); ?>"
                                    alt="<?php echo e($user->name); ?> avatar" style="width: 72px; height: 72px;">
                                <span class="position-absolute bottom-0 end-0 translate-middle p-1 bg-success border border-2 border-white rounded-circle" style="width: 16px; height: 16px;"></span>
                            </a>
                        </div>
                    </div>
                    <div class="card-body pt-3 text-center px-3">
                        <h6 class="mb-1 text-truncate fw-bold">
                            <a class="text-decoration-none text-dark" href="<?php echo e($profileUrl); ?>"><?php echo e($user->name); ?></a>
                        </h6>
                        <p class="small text-muted mb-3 fw-medium"><?php echo e("@".$user->username); ?></p>
                        <div class="d-flex justify-content-center gap-3 small text-muted mb-3">
                            <div class="text-center">
                                <div class="fw-bold text-dark fs-6"><?php echo e($user->friends_count ?? 0); ?></div>
                                <span class="small">Friends</span>
                            </div>
                            <div class="vr opacity-25"></div>
                            <div class="text-center">
                                <div class="fw-bold text-dark fs-6"><?php echo e($user->followers_count ?? 0); ?></div>
                                <span class="small">Followers</span>
                            </div>
                            <div class="vr opacity-25"></div>
                            <div class="text-center">
                                <div class="fw-bold text-dark fs-6"><?php echo e($user->posts_count ?? 0); ?></div>
                                <span class="small">Posts</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-transparent border-0 pt-0 px-3 pb-3">
                        <div class="d-grid gap-2">
                            <a class="btn btn-primary btn-sm rounded-pill fw-semibold border-0" href="<?php echo e($profileUrl); ?>">View Profile</a>
                            <a class="btn btn-outline-primary btn-sm rounded-pill fw-semibold" href="<?php echo e(route('settings.profile')); ?>">Edit Profile</a>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="card border-0 shadow-sm mb-4 bg-white" style="border-radius: 12px;">
                    <div class="card-body p-4 text-center">
                        <div class="mb-3">
                            <img class="rounded-circle shadow-sm" src="<?php echo e(asset('assets/images/default-avatar.jpg')); ?>" alt="Avatar" width="56" height="56">
                        </div>
                        <h6 class="card-title mb-1 fw-bold">Welcome Guest</h6>
                        <p class="small text-muted mb-3">Join our community today</p>
                        <div class="d-grid gap-2">
                            <a class="btn btn-primary btn-sm rounded-pill fw-semibold border-0" href="<?php echo e(route('login')); ?>">Login</a>
                            <a class="btn btn-outline-primary btn-sm rounded-pill fw-semibold" href="<?php echo e(route('register')); ?>">Register</a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Profile Card END -->



            <!-- Menu START -->
            <div class="card sidebar-menu border-0 shadow-sm mb-4 bg-white" style="border-radius: 12px;">
                <div class="card-body p-0">
                    <ul class="nav flex-column">
                        <!-- General Section -->
                        <li class="nav-item px-3 py-2">
                            <div class="nav-title text-uppercase fw-bold text-muted small mb-1 px-2" style="letter-spacing: 0.5px;">General</div>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('newsfeed')); ?>" style="transition: all 0.15s ease;">
                                <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                    <i class="bi bi-house-door text-primary"></i>
                                </div>
                                <span class="fw-semibold">News Feed</span>
                            </a>
                        </li>
                        <?php if(Auth::user()->role == 'admin'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center" href="<?php echo e(url('admin')); ?>">
                                    <i class="bi bi-shield-lock text-primary me-2"></i><span>Admin Panel</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('pages') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('friends')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-people-fill text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Friends</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('pokes') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('pokes')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-hand-index text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Pokes</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('movies') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('movies')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-film text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Movies</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('games') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('games')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-controller text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Games</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="https://socialink.com/photos" style="transition: all 0.15s ease;">
                                <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                    <i class="bi bi-image text-primary"></i>
                                </div>
                                <span class="fw-semibold">Photos</span>
                            </a>
                        </li>


                        <!-- Social & Community Section -->
                        <li class="nav-item px-3 py-2">
                            <div class="nav-title text-uppercase fw-bold text-muted small mb-1 px-2" style="letter-spacing: 0.5px;">Community</div>
                        </li>
                        <?php if(setting('pages') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('pages')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-file-earmark-text text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Pages</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('groups') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('groups')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-people text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Groups</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('events') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('events')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-calendar-event text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Events</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('blogs') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(route('blogs.index')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="fas fa-blog text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Blog</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('courses') == '1'): ?>
                            <!-- Courses Section -->
                            <li class="nav-item px-3 py-2">
                                <div class="nav-title text-uppercase fw-bold text-muted small mb-1 px-2" style="letter-spacing: 0.5px;">Learning</div>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('courses')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-book text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">All Courses</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('product') == '1'): ?>
                            <li class="nav-item px-3 py-2">
                                <div class="nav-title text-uppercase fw-bold text-muted small mb-1 px-2" style="letter-spacing: 0.5px;">Marketplace</div>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('marketplace')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-cart text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">MarketPlace</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('job_system') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('jobs')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-briefcase text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Jobs</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <!-- More Section -->
                        <li class="nav-item px-3 py-2">
                            <div class="nav-title text-uppercase fw-bold text-muted small mb-1 px-2" style="letter-spacing: 0.5px;">More</div>
                        </li>
                        <?php if(setting('wallet') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('wallet')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-wallet text-primary"></i>
                                    </div>
                                    <span class="fw-semibold">Wallet</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if(setting('blood') == '1'): ?>
                            <li class="nav-item">
                                <a class="nav-link d-flex align-items-center py-2 px-3 text-decoration-none" href="<?php echo e(url('bloodbank')); ?>" style="transition: all 0.15s ease;">
                                    <div class="nav-icon me-3 d-flex align-items-center justify-content-center" style="width: 30px; height: 30px;">
                                        <i class="bi bi-droplet-fill text-danger"></i>
                                    </div>
                                    <span class="fw-semibold">Blood Bank</span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link d-flex align-items-center" href="<?php echo e(url('logout')); ?>">
                                <i class="bi bi-box-arrow-right text-danger me-2"></i><span>Logout</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- Menu END -->


            <!-- Footer Links START -->


            <?php echo $__env->make('front_end.components.footer_left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
</nav>
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/components/left_sidebar.blade.php ENDPATH**/ ?>