
<input type="hidden" id="postType" value="<?php echo e($postType); ?>">
<input type="hidden" id="selectedPageId" value="">
<input type="hidden" id="selectedGroupId" value="">
<input type="hidden" id="pageId" value="">
<input type="hidden" id="groupId" value="">
<input type="hidden" id="selectedPageId" value="">
<input type="hidden" id="selectedGroupId" value="">

<!-- Post Highlighter Overlay -->
<div class="post-highlighter"></div>

<!-- Create Post Card START -->
<div class="card post-creation-card">
    <!-- Main Content Area -->
    <div class="card-body p-4">
        <!-- User Input Section -->
        <div class="d-flex gap-3">
            <!-- User Avatar -->
        <div class="position-relative">
            <img src="<?php echo e(getMedia($boxAvatar)); ?>"
                class="rounded-circle object-fit-cover"
                width="48"
                height="48"
                alt="User Profile"
                loading="lazy"
                style="width: 48px; height: 48px;">
        </div>
            <!-- Post Input -->
            <div class="flex-grow-1">
                <div class="post-input-container">
                    <textarea class="post-textarea"
                        id="postInput"
                        placeholder="What's on your mind?"
                        aria-expanded="false"></textarea>
                    <button class="emoji-button" type="button" id="emojiButton">
                        <i class="bi bi-emoji-smile-fill"></i>
                    </button>
                    <input type="text" name="feeling-category" id="feeling-category" class="d-none">
                    <input type="text" name="feeling-description" id="feeling-description" class="d-none">
                    <input type="text" name="post-location" id="post-location" class="d-none">
                </div>
            </div>
        </div>

        <div class="posting-detail" style="display: none;">
            <!-- Feeling Selection -->
            <div class="feeling-section mb-3" id="feelingSection" style="display: none;">
                <div class="feeling-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">How are you feeling?</h6>
                    <button type="button" class="btn-close" id="closeFeeling"></button>
                </div>
                <div class="feeling-categories">
                    <div class="feeling-category" data-category="feeling">
                        <div class="feeling-icon">
                            <i class="bi bi-heart-fill text-danger"></i>
                        </div>
                        <span>Feeling</span>
                    </div>
                    <div class="feeling-category" data-category="traveling">
                        <div class="feeling-icon">
                            <i class="bi bi-airplane-engines text-primary"></i>
                        </div>
                        <span>Traveling</span>
                    </div>
                    <div class="feeling-category" data-category="watching">
                        <div class="feeling-icon">
                            <i class="bi bi-eye-fill text-success"></i>
                        </div>
                        <span>Watching</span>
                    </div>
                    <div class="feeling-category" data-category="listening">
                        <div class="feeling-icon">
                            <i class="bi bi-music-note-beamed text-warning"></i>
                        </div>
                        <span>Listening</span>
                    </div>
                </div>
                
                <!-- Feeling Sub-options -->
                <div class="feeling-sub-options" id="feelingSubOptions" style="display: none;">
                    <div class="feeling-sub-header p-3 bg-light border-top">
                        <h6 class="mb-0" id="feelingSubTitle">Select Feeling</h6>
                    </div>
                    <div class="feeling-options-grid" id="feelingOptionsGrid">
                        <!-- Dynamic content -->
                    </div>
                </div>
            </div>

            <!-- Poll Creation -->
            <div class="poll-section mb-3" id="pollSection" style="display: none;">
                <div class="poll-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Create Poll</h6>
                    <button type="button" class="btn-close" id="closePoll"></button>
                </div>
                <div class="poll-content p-3">
                    <div class="mb-3">
                        <label class="form-label">Poll Question</label>
                        <input type="text" class="form-control" id="pollQuestion" placeholder="Ask something...">
                    </div>
                    <div class="poll-options-container">
                        <label class="form-label">Options</label>
                        <div id="pollOptionsList">
                            <div class="poll-option-item mb-2">
                                <div class="input-group">
                                    <span class="input-group-text">1</span>
                                    <input type="text" class="form-control poll-option-input" placeholder="Option 1" required>
                                    <button class="btn btn-outline-danger remove-poll-option" type="button">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="poll-option-item mb-2">
                                <div class="input-group">
                                    <span class="input-group-text">2</span>
                                    <input type="text" class="form-control poll-option-input" placeholder="Option 2" required>
                                    <button class="btn btn-outline-danger remove-poll-option" type="button">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-outline-primary btn-sm" id="addPollOption">
                            <i class="bi bi-plus"></i> Add Option
                        </button>
                    </div>
                    <div class="poll-settings mt-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="allowMultipleVotes">
                            <label class="form-check-label" for="allowMultipleVotes">
                                Allow multiple votes
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="hideResults">
                            <label class="form-check-label" for="hideResults">
                                Hide results until poll ends
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Colored Post Section -->
            <div class="color-post-section mb-3" id="colorPostSection" style="display: none;">
                <div class="color-post-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Create Colored Post</h6>
                    <button type="button" class="btn-close" id="closeColorPost"></button>
                </div>
                
                <div class="color-post-content p-3">
                    <!-- Background Color Selection -->
                    <div class="color-option-group mb-3">
                        <label class="form-label fw-bold">Background Color:</label>
                        <div class="color-palette" id="backgroundColors">
                            <div class="color-option" data-color="#ffffff" data-text-color="#000000" style="background-color: #ffffff; border: 2px solid #e1e5e9;">
                                <span class="color-name">White</span>
                            </div>
                            <div class="color-option" data-color="#ff6b6b" data-text-color="#ffffff" style="background-color: #ff6b6b;">
                                <span class="color-name">Red</span>
                            </div>
                            <div class="color-option" data-color="#4ecdc4" data-text-color="#ffffff" style="background-color: #4ecdc4;">
                                <span class="color-name">Teal</span>
                            </div>
                            <div class="color-option" data-color="#45b7d1" data-text-color="#ffffff" style="background-color: #45b7d1;">
                                <span class="color-name">Blue</span>
                            </div>
                            <div class="color-option" data-color="#96ceb4" data-text-color="#ffffff" style="background-color: #96ceb4;">
                                <span class="color-name">Green</span>
                            </div>
                            <div class="color-option" data-color="#feca57" data-text-color="#000000" style="background-color: #feca57;">
                                <span class="color-name">Yellow</span>
                            </div>
                            <div class="color-option" data-color="#ff9ff3" data-text-color="#ffffff" style="background-color: #ff9ff3;">
                                <span class="color-name">Pink</span>
                            </div>
                            <div class="color-option" data-color="#54a0ff" data-text-color="#ffffff" style="background-color: #54a0ff;">
                                <span class="color-name">Light Blue</span>
                            </div>
                            <div class="color-option" data-color="#5f27cd" data-text-color="#ffffff" style="background-color: #5f27cd;">
                                <span class="color-name">Purple</span>
                            </div>
                            <div class="color-option" data-color="#00d2d3" data-text-color="#ffffff" style="background-color: #00d2d3;">
                                <span class="color-name">Cyan</span>
                            </div>
                            <div class="color-option" data-color="#ff9f43" data-text-color="#ffffff" style="background-color: #ff9f43;">
                                <span class="color-name">Orange</span>
                            </div>
                            <div class="color-option" data-color="#2c3e50" data-text-color="#ffffff" style="background-color: #2c3e50;">
                                <span class="color-name">Dark</span>
                            </div>
                        </div>
                    </div>

                    <!-- Text Color Selection -->
                    <div class="color-option-group mb-3">
                        <label class="form-label fw-bold">Text Color:</label>
                        <div class="color-palette" id="textColors">
                            <div class="color-option" data-color="#000000" style="background-color: #000000;">
                                <span class="color-name">Black</span>
                            </div>
                            <div class="color-option" data-color="#ffffff" style="background-color: #ffffff; border: 2px solid #e1e5e9;">
                                <span class="color-name">White</span>
                            </div>
                            <div class="color-option" data-color="#ff6b6b" style="background-color: #ff6b6b;">
                                <span class="color-name">Red</span>
                            </div>
                            <div class="color-option" data-color="#4ecdc4" style="background-color: #4ecdc4;">
                                <span class="color-name">Teal</span>
                            </div>
                            <div class="color-option" data-color="#45b7d1" style="background-color: #45b7d1;">
                                <span class="color-name">Blue</span>
                            </div>
                            <div class="color-option" data-color="#96ceb4" style="background-color: #96ceb4;">
                                <span class="color-name">Green</span>
                            </div>
                            <div class="color-option" data-color="#feca57" style="background-color: #feca57;">
                                <span class="color-name">Yellow</span>
                            </div>
                            <div class="color-option" data-color="#ff9ff3" style="background-color: #ff9ff3;">
                                <span class="color-name">Pink</span>
                            </div>
                        </div>
                    </div>

                    <!-- Font Size Selection -->
                    <div class="color-option-group mb-3">
                        <label class="form-label fw-bold">Font Size:</label>
                        <div class="font-size-options">
                            <button class="font-size-btn active" data-size="normal">Normal</button>
                            <button class="font-size-btn" data-size="large">Large</button>
                            <button class="font-size-btn" data-size="extra-large">Extra Large</button>
                        </div>
                    </div>

                    <!-- Preview Area -->
                    <div class="color-post-preview" id="colorPostPreview">
                        <label class="form-label fw-bold">Preview:</label>
                        <div class="preview-content" id="previewContent">
                            <p>Preview your colored post here...</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tag People Section -->
            <div class="tag-people-section mb-3" id="tagPeopleSection" style="display: none;">
                <div class="tag-people-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Tag People</h6>
                    <button type="button" class="btn-close" id="closeTagPeople"></button>
                </div>
                <div class="tag-people-content p-3">
                    <!-- Search People -->
                    <div class="search-people mb-3">
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="bi bi-search"></i>
                            </span>
                            <input type="text" class="form-control" id="searchPeople" 
                                   placeholder="Search people to tag..." autocomplete="off">
                        </div>
                    </div>
                    
                    <!-- Selected People -->
                    <div class="selected-people mb-3" id="selectedPeople" style="display: none;">
                        <h6 class="text-muted mb-2">Tagged People</h6>
                        <div class="tagged-people-list" id="taggedPeopleList">
                            <!-- Tagged people will be listed here -->
                        </div>
                    </div>
                    
                    <!-- People Suggestions -->
                    <div class="people-suggestions mb-3" id="peopleSuggestions">
                        <h6 class="text-muted mb-2">Suggestions</h6>
                        <div class="suggestions-list" id="suggestionsList">
                            <!-- People suggestions will be loaded here -->
                        </div>
                    </div>
                    
                    <!-- Search Results -->
                    <div class="search-results mb-3" id="searchResults" style="display: none;">
                        <h6 class="text-muted mb-2">Search Results</h6>
                        <div class="results-list" id="resultsList">
                            <!-- Search results will be listed here -->
                        </div>
                    </div>
                    
                    <!-- Tag Actions -->
                    <div class="tag-actions mt-3">
                        <button type="button" class="btn btn-success" id="saveTags">
                            <i class="bi bi-check-circle"></i> Save Tags
                        </button>
                        <button type="button" class="btn btn-outline-secondary" id="clearAllTags">
                            <i class="bi bi-x-circle"></i> Clear All
                        </button>
                    </div>
                </div>
            </div>

            <!-- File Upload Section -->
            <div class="file-upload-section mb-3" id="fileUploadSection" style="display: none;">
                <div class="file-upload-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Upload Files</h6>
                    <button type="button" class="btn-close" id="closeFileUpload"></button>
                </div>
                <div class="file-upload-content p-3">
                    <!-- File Upload Area -->
                    <div class="file-upload-area mb-3">
                        <div class="upload-zone" id="uploadZone">
                            <div class="upload-icon mb-3">
                                <i class="bi bi-cloud-upload"></i>
                            </div>
                            <h6 class="upload-title">Drag & Drop files here</h6>
                            <p class="upload-subtitle text-muted">or click to browse files</p>
                            <input type="file" id="fileInput" multiple accept="*/*" style="display: none;">
                            <button type="button" class="btn btn-primary mt-2" id="browseFiles">
                                <i class="bi bi-folder2-open"></i> Browse Files
                            </button>
                        </div>
                    </div>
                    
                    <!-- File Type Filters -->
                    <div class="file-type-filters mb-3">
                        <h6 class="text-muted mb-2">Quick Filters</h6>
                        <div class="filter-buttons d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-sm btn-outline-primary filter-btn active" data-filter="all">
                                All Files
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-success filter-btn" data-filter="document">
                                <i class="bi bi-file-earmark-text"></i> Documents
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-info filter-btn" data-filter="image">
                                <i class="bi bi-file-earmark-image"></i> Images
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-warning filter-btn" data-filter="video">
                                <i class="bi bi-file-earmark-play"></i> Videos
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary filter-btn" data-filter="audio">
                                <i class="bi bi-file-earmark-music"></i> Audio
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-danger filter-btn" data-filter="archive">
                                <i class="bi bi-file-earmark-zip"></i> Archives
                            </button>
                        </div>
                    </div>
                    
                    <!-- Uploaded Files List -->
                    <div class="uploaded-files-list" id="uploadedFilesList" style="display: none;">
                        <h6 class="text-muted mb-2">Selected Files</h6>
                        <div class="files-container" id="filesContainer">
                            <!-- Files will be listed here -->
                        </div>
                        <div class="upload-actions mt-3">
                            <button type="button" class="btn btn-success" id="addFilesToPost">
                                <i class="bi bi-check-circle"></i> Add to Post
                            </button>
                            <button type="button" class="btn btn-outline-secondary" id="clearAllFiles">
                                <i class="bi bi-trash"></i> Clear All
                            </button>
                        </div>
                    </div>
                    
                    <!-- File Upload Tips -->
                    <div class="file-upload-tips mt-3">
                        <small class="text-muted">
                            <i class="bi bi-info-circle"></i>
                            Supported formats: Documents (PDF, DOC, DOCX), Images (JPG, PNG, GIF), Videos (MP4, AVI, MOV), Audio (MP3, WAV), Archives (ZIP, RAR). Max file size: 50MB per file.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Voice Note Recording Section -->
            <div class="voice-note-section mb-3" id="voiceNoteSection" style="display: none;">
                <div class="voice-note-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Record Voice Note</h6>
                    <button type="button" class="btn-close" id="closeVoiceNote"></button>
                </div>
                <div class="voice-note-content p-3">
                    <!-- Recording Controls -->
                    <div class="recording-controls text-center mb-3">
                        <div class="recording-status mb-2">
                            <span class="recording-indicator" id="recordingIndicator">
                                <i class="bi bi-circle-fill text-danger"></i>
                            </span>
                            <span class="recording-text" id="recordingText">Ready to record</span>
                        </div>
                        
                        <div class="recording-timer mb-3">
                            <span class="timer-display" id="timerDisplay">00:00</span>
                        </div>
                        
                        <div class="recording-buttons d-flex justify-content-center gap-3">
                            <button type="button" class="btn btn-danger btn-lg rounded-circle" id="startRecording">
                                <i class="bi bi-mic-fill"></i>
                            </button>
                            <button type="button" class="btn btn-secondary btn-lg rounded-circle" id="stopRecording" style="display: none;">
                                <i class="bi bi-stop-fill"></i>
                            </button>
                            <button type="button" class="btn btn-warning btn-lg rounded-circle" id="pauseRecording" style="display: none;">
                                <i class="bi bi-pause-fill"></i>
                            </button>
                            <button type="button" class="btn btn-success btn-lg rounded-circle" id="resumeRecording" style="display: none;">
                                <i class="bi bi-play-fill"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Recording Visualization -->
                    <div class="recording-visualization mb-3" id="recordingVisualization" style="display: none;">
                        <div class="audio-waves">
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                            <div class="wave-bar"></div>
                        </div>
                    </div>
                    
                    <!-- Recorded Audio Preview -->
                    <div class="recorded-audio-preview" id="recordedAudioPreview" style="display: none;">
                        <div class="audio-player-container">
                            <audio id="recordedAudio" controls></audio>
                            <div class="audio-controls mt-2">
                                <button type="button" class="btn btn-sm btn-outline-danger" id="deleteRecording">
                                    <i class="bi bi-trash"></i> Delete
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-primary" id="saveRecording">
                                    <i class="bi bi-check"></i> Save
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recording Tips -->
                    <div class="recording-tips mt-3">
                        <small class="text-muted">
                            <i class="bi bi-info-circle"></i>
                            Tips: Speak clearly, minimize background noise, and keep recordings under 5 minutes for best quality.
                        </small>
                    </div>
                </div>
            </div>

            <!-- GIF Search Section -->
            <div class="gif-section mb-3" id="gifSection" style="display: none;">
                <div class="gif-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Search GIFs</h6>
                    <button type="button" class="btn-close" id="closeGif"></button>
                </div>
                <div class="gif-content p-3">
                    <!-- GIF Search Input -->
                    <div class="gif-search mb-3">
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="bi bi-search"></i>
                            </span>
                            <input type="text" class="form-control" id="gifSearch" 
                                   placeholder="Search for GIFs..." autocomplete="off">
                            <button class="btn btn-primary" type="button" id="searchGif">
                                <i class="bi bi-search"></i>
                                Search
                            </button>
                        </div>
                    </div>
                    
                    <!-- Trending GIFs -->
                    <div class="trending-gifs mb-3" id="trendingGifs">
                        <h6 class="text-muted mb-2">Trending GIFs</h6>
                        <div class="gif-grid" id="trendingGifGrid">
                            <!-- Trending GIFs will be loaded here -->
                        </div>
                    </div>
                    
                    <!-- Search Results -->
                    <div class="gif-results" id="gifResults" style="display: none;">
                        <div class="gif-results-header d-flex align-items-center justify-content-between mb-2">
                            <h6 class="text-muted mb-0">Search Results</h6>
                            <button type="button" class="btn btn-sm btn-link" id="clearGifSearch">
                                Clear
                            </button>
                        </div>
                        <div class="gif-grid" id="gifResultsGrid">
                            <!-- Search results will be loaded here -->
                        </div>
                        <div class="gif-load-more text-center mt-3" id="gifLoadMore" style="display: none;">
                            <button class="btn btn-outline-primary" type="button" id="loadMoreGifs">
                                Load More GIFs
                            </button>
                        </div>
                    </div>
                    
                    <!-- Selected GIF Preview -->
                    <div class="selected-gif-preview" id="selectedGifPreview" style="display: none;">
                        <div class="selected-gif-header d-flex align-items-center justify-content-between mb-2">
                            <small class="text-muted">Selected GIF</small>
                            <button type="button" class="btn btn-sm btn-link text-danger" id="removeSelectedGif">
                                Remove
                            </button>
                        </div>
                        <div class="selected-gif-content" id="selectedGifContent">
                            <!-- Selected GIF will be shown here -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Location Check-in Section -->
            <div class="location-section mb-3" id="locationSection" style="display: none;">
                <div class="location-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Check in to a place</h6>
                    <button type="button" class="btn-close" id="closeLocation"></button>
                </div>
                <div class="location-content p-3">
                    <div class="location-search mb-3">
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="bi bi-search"></i>
                            </span>
                            <input type="text" class="form-control" id="locationSearch" 
                                   placeholder="Search for a place..." autocomplete="off">
                            <button class="btn btn-outline-secondary" type="button" id="useCurrentLocation">
                                <i class="bi bi-geo-alt-fill"></i>
                                <span class="d-none d-sm-inline">Current</span>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Location Search Results -->
                    <div class="location-results" id="locationResults" style="display: none;">
                        <div class="location-results-header d-flex align-items-center justify-content-between mb-2">
                            <small class="text-muted">Search Results</small>
                            <button type="button" class="btn btn-sm btn-link" id="clearLocationSearch">
                                Clear
                            </button>
                        </div>
                        <div class="location-results-list" id="locationResultsList">
                            <!-- Dynamic search results will be loaded here -->
                        </div>
                    </div>
                    
                    <!-- Selected Location Preview -->
                    <div class="selected-location-preview" id="selectedLocationPreview" style="display: none;">
                        <div class="selected-location-header d-flex align-items-center justify-content-between mb-2">
                            <small class="text-muted">Selected Location</small>
                            <button type="button" class="btn btn-sm btn-link text-danger" id="removeSelectedLocation">
                                Remove
                            </button>
                        </div>
                        <div class="selected-location-content" id="selectedLocationContent">
                            <!-- Selected location details will be shown here -->
                        </div>
                    </div>
                    
                    <!-- Custom Location Input -->
                    <div class="custom-location-input mt-3" id="customLocationInput" style="display: none;">
                        <div class="form-group">
                            <label class="form-label">Or write a custom location:</label>
                            <input type="text" class="form-control" id="customLocationText" 
                                   placeholder="e.g., My Home, Office, Coffee Shop...">
                            <div class="form-text">You can write any custom location name</div>
                        </div>
                        <div class="mt-2">
                            <button type="button" class="btn btn-primary btn-sm" id="saveCustomLocation">
                                Save Custom Location
                            </button>
                            <button type="button" class="btn btn-secondary btn-sm" id="cancelCustomLocation">
                                Cancel
                            </button>
                        </div>
                    </div>
                    
                    <!-- No Results Message -->
                    <div class="no-location-results text-center py-3" id="noLocationResults" style="display: none;">
                        <i class="bi bi-search text-muted mb-2" style="font-size: 2rem;"></i>
                        <p class="text-muted mb-2">No places found</p>
                        <button type="button" class="btn btn-outline-primary btn-sm" id="addCustomLocation">
                            Add Custom Location
                        </button>
                    </div>
                </div>
            </div>

            <!-- Preview Area -->
            <div class="preview-area mt-3 d-none" id="preview-area">
                <!-- Dynamic content for image/video preview -->
            </div>

            <!-- Action Buttons -->
            <div class="post-actions-grid">
                <button class="action-button photo-action"
                    type="button"
                    id="addPhotos"
                    data-bs-toggle="tooltip"
                    title="Add Photos">
                    <i class="bi bi-image-fill"></i>
                    <span class="d-none d-sm-inline">Photo</span>
                </button>

                <button class="action-button video-action"
                    type="button"
                    id="addVideo"
                    data-bs-toggle="tooltip"
                    title="Add Video">
                    <i class="bi bi-camera-reels-fill"></i>
                    <span class="d-none d-sm-inline">Video</span>
                </button>

                <button class="action-button event-action"
                    type="button"
                    id="createEvent"
                    data-bs-toggle="tooltip"
                    title="Create Event">
                    <i class="bi bi-calendar2-event-fill"></i>
                    <span class="d-none d-sm-inline">Event</span>
                </button>

                <button class="action-button feeling-action"
                    type="button"
                    id="addFeeling"
                    data-bs-toggle="tooltip"
                    title="Add Feeling/Activity">
                    <i class="bi bi-emoji-smile-fill"></i>
                    <span class="d-none d-sm-inline">Feeling</span>
                </button>

                <button class="action-button location-action"
                    type="button"
                    id="checkIn"
                    data-bs-toggle="tooltip"
                    title="Check in Location">
                    <i class="bi bi-geo-alt-fill"></i>
                    <span class="d-none d-sm-inline">Check in</span>
                </button>

                <button class="action-button poll-action"
                    type="button"
                    id="createPoll"
                    data-bs-toggle="tooltip"
                    title="Create Poll">
                    <i class="bi bi-bar-chart-fill"></i>
                    <span class="d-none d-sm-inline">Poll</span>
                </button>

                <button class="action-button color-post-action"
                    type="button"
                    id="createColorPost"
                    data-bs-toggle="tooltip"
                    title="Create Colored Post">
                    <i class="bi bi-palette-fill"></i>
                    <span class="d-none d-sm-inline">Color</span>
                </button>

                <button class="action-button gif-action"
                    type="button"
                    id="addGif"
                    data-bs-toggle="tooltip"
                    title="Add GIF">
                    <i class="bi bi-file-earmark-image"></i>
                    <span class="d-none d-sm-inline">GIF</span>
                </button>

                <button class="action-button audio-action"
                    type="button"
                    id="addAudio"
                    data-bs-toggle="tooltip"
                    title="Add Audio">
                    <i class="bi bi-music-note-beamed"></i>
                    <span class="d-none d-sm-inline">Audio</span>
                </button>

                <button class="action-button voice-note-action"
                    type="button"
                    id="addVoiceNote"
                    data-bs-toggle="tooltip"
                    title="Record Voice Note">
                    <i class="bi bi-mic-fill"></i>
                    <span class="d-none d-sm-inline">Voice</span>
                </button>

                <button class="action-button file-upload-action"
                    type="button"
                    id="addFile"
                    data-bs-toggle="tooltip"
                    title="Upload File">
                    <i class="bi bi-file-earmark-arrow-up"></i>
                    <span class="d-none d-sm-inline">File</span>
                </button>

                <button class="action-button tag-people-action"
                    type="button"
                    id="tagPeople"
                    data-bs-toggle="tooltip"
                    title="Tag People">
                    <i class="bi bi-person-plus"></i>
                    <span class="d-none d-sm-inline">Tag</span>
                </button>

                <button class="action-button post-to-page-action"
                    type="button"
                    id="postToPage"
                    data-bs-toggle="tooltip"
                    title="Post to Page">
                    <i class="bi bi-flag-fill"></i>
                    <span class="d-none d-sm-inline">Page</span>
                </button>

                <button class="action-button post-to-group-action"
                    type="button"
                    id="postToGroup"
                    data-bs-toggle="tooltip"
                    title="Post to Group">
                    <i class="bi bi-people-fill"></i>
                    <span class="d-none d-sm-inline">Group</span>
                </button>

                <button class="action-button ai-post-action"
                    type="button"
                    id="generateAIPost"
                    data-bs-toggle="tooltip"
                    title="Generate AI Post">
                    <i class="bi bi-robot"></i>
                    <span class="d-none d-sm-inline">AI Post</span>
                </button>

                <button class="action-button ai-image-action"
                    type="button"
                    id="generateAIImage"
                    data-bs-toggle="tooltip"
                    title="Generate AI Image">
                    <i class="bi bi-image"></i>
                    <span class="d-none d-sm-inline">AI Image</span>
                </button>
            </div>

            <!-- AI Post Generation Section -->
            <div class="ai-post-section mb-3" id="aiPostSection" style="display: none;">
                <div class="ai-post-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Generate AI Post</h6>
                    <button type="button" class="btn-close" id="closeAIPost"></button>
                </div>
                <div class="ai-post-content p-3">
                    <!-- AI Post Prompt -->
                    <div class="ai-prompt mb-3">
                        <label for="aiPostPrompt" class="form-label">What kind of post would you like to generate?</label>
                        <textarea class="form-control" id="aiPostPrompt" rows="3" 
                                  placeholder="Describe the type of post you want (e.g., 'A motivational post about success', 'A funny post about technology', 'A post about travel adventures')"></textarea>
                    </div>
                    
                    <!-- AI Post Options -->
                    <div class="ai-post-options mb-3">
                        <h6 class="text-muted mb-2">Post Style</h6>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-sm btn-outline-primary ai-style-btn active" data-style="casual">
                                Casual
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-style-btn" data-style="professional">
                                Professional
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-style-btn" data-style="funny">
                                Funny
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-style-btn" data-style="motivational">
                                Motivational
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-style-btn" data-style="informative">
                                Informative
                            </button>
                        </div>
                    </div>
                    
                    <!-- Generate Button -->
                    <div class="ai-generate-actions mb-3">
                        <button type="button" class="btn btn-primary" id="generatePostBtn">
                            <i class="bi bi-magic"></i> Generate Post
                        </button>
                        <button type="button" class="btn btn-outline-secondary" id="clearAIPost">
                            <i class="bi bi-x-circle"></i> Clear
                        </button>
                    </div>
                    
                    <!-- Generated Post Preview -->
                    <div class="generated-post-preview" id="generatedPostPreview" style="display: none;">
                        <h6 class="text-muted mb-2">Generated Post</h6>
                        <div class="generated-content bg-light p-3 rounded" id="generatedContent">
                            <!-- Generated content will appear here -->
                        </div>
                        <div class="generated-actions mt-3">
                            <button type="button" class="btn btn-success" id="useGeneratedPost">
                                <i class="bi bi-check-circle"></i> Use This Post
                            </button>
                            <button type="button" class="btn btn-outline-primary" id="regeneratePost">
                                <i class="bi bi-arrow-clockwise"></i> Regenerate
                            </button>
                        </div>
                    </div>
                    
                    <!-- AI Tips -->
                    <div class="ai-tips mt-3">
                        <small class="text-muted">
                            <i class="bi bi-info-circle"></i>
                            Tip: Be specific in your description for better results. You can also mention the tone, length, or specific topics you want to include.
                        </small>
                    </div>
                </div>
            </div>
            
            <!-- AI Image Generation Section -->
            <div class="ai-image-section mb-3" id="aiImageSection" style="display: none;">
                <div class="ai-image-header d-flex align-items-center justify-content-between p-3 bg-light rounded-top">
                    <h6 class="mb-0 text-muted">Generate AI Image</h6>
                    <button type="button" class="btn-close" id="closeAIImage"></button>
                </div>
                <div class="ai-image-content p-3">
                    <!-- AI Image Prompt -->
                    <div class="ai-image-prompt mb-3">
                        <label for="aiImagePrompt" class="form-label">Describe the image you want to generate</label>
                        <textarea class="form-control" id="aiImagePrompt" rows="3" 
                                  placeholder="Describe the image in detail (e.g., 'A beautiful sunset over mountains', 'A cute cat playing with a ball', 'A modern office workspace')"></textarea>
                    </div>
                    
                    <!-- Image Style Options -->
                    <div class="ai-image-options mb-3">
                        <h6 class="text-muted mb-2">Image Style</h6>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-sm btn-outline-primary ai-image-style-btn active" data-style="realistic">
                                Realistic
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-image-style-btn" data-style="artistic">
                                Artistic
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-image-style-btn" data-style="cartoon">
                                Cartoon
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-image-style-btn" data-style="abstract">
                                Abstract
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary ai-image-style-btn" data-style="vintage">
                                Vintage
                            </button>
                        </div>
                    </div>
                    
                    <!-- Image Size Options -->
                    <div class="ai-image-size mb-3">
                        <h6 class="text-muted mb-2">Image Size</h6>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary ai-size-btn active" data-size="512x512">
                                512x512
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary ai-size-btn" data-size="1024x1024">
                                1024x1024
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary ai-size-btn" data-size="1024x768">
                                1024x768
                            </button>
                        </div>
                    </div>
                    
                    <!-- Generate Button -->
                    <div class="ai-image-generate-actions mb-3">
                        <button type="button" class="btn btn-primary" id="generateImageBtn">
                            <i class="bi bi-magic"></i> Generate Image
                        </button>
                        <button type="button" class="btn btn-outline-secondary" id="clearAIImage">
                            <i class="bi bi-x-circle"></i> Clear
                        </button>
                    </div>
                    
                    <!-- Generated Image Preview -->
                    <div class="generated-image-preview" id="generatedImagePreview" style="display: none;">
                        <h6 class="text-muted mb-2">Generated Image</h6>
                        <div class="generated-image-container text-center">
                            <img id="generatedImage" class="img-fluid rounded" alt="Generated Image">
                        </div>
                        <div class="generated-image-actions mt-3">
                            <button type="button" class="btn btn-success" id="useGeneratedImage">
                                <i class="bi bi-check-circle"></i> Use This Image
                            </button>
                            <button type="button" class="btn btn-outline-primary" id="regenerateImage">
                                <i class="bi bi-arrow-clockwise"></i> Regenerate
                            </button>
                            <button type="button" class="btn btn-outline-info" id="downloadGeneratedImage">
                                <i class="bi bi-download"></i> Download
                            </button>
                        </div>
                    </div>
                    
                    <!-- AI Image Tips -->
                    <div class="ai-image-tips mt-3">
                        <small class="text-muted">
                            <i class="bi bi-info-circle"></i>
                            Tip: Be detailed in your description. Include colors, style, mood, and specific elements you want in the image.
                        </small>
                    </div>
                </div>
            </div>

            <!-- Post Options Section -->
            <div class="post-options-section mt-3">
                <div class="post-options-header">
                    <h6 class="text-muted mb-3">Post Options</h6>
                </div>
                
                <!-- Schedule Post -->
                <div class="post-option-item mb-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="option-icon me-3">
                                <i class="bi bi-calendar-event text-primary"></i>
                            </div>
                            <div>
                                <div class="option-title">Schedule Post</div>
                                <div class="option-description text-muted small">Schedule your post for later</div>
                            </div>
                        </div>
                        <div class="option-toggle">
                            <label class="switch" for="is_schedule">
                                <input type="checkbox" name="is_schedule" id="is_schedule" class="js_publisher-schedule-toggle">
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                    <div class="schedule-datetime-wrapper mt-2" id="schedule-datetime-wrapper" style="display: none;">
                        <input type="datetime-local" class="form-control js_publisher-schedule-date" name="schedule_datetime">
                        <div class="form-text small">
                            Select a date and time for your post
                        </div>
                    </div>
                </div>
                
                <!-- Anonymous Post -->
                <div class="post-option-item mb-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="option-icon me-3">
                                <i class="bi bi-incognito text-warning"></i>
                            </div>
                            <div>
                                <div class="option-title">Anonymous Post</div>
                                <div class="option-description text-muted small">Share your post anonymously</div>
                            </div>
                        </div>
                        <div class="option-toggle">
                            <label class="switch" for="is_anonymous">
                                <input type="checkbox" name="is_anonymous" id="is_anonymous" class="js_publisher-anonymous-toggle">
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Enable Tips -->
                <div class="post-option-item mb-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <div class="option-icon me-3">
                                <i class="bi bi-cash-coin text-success"></i>
                            </div>
                            <div>
                                <div class="option-title">Enable Tips</div>
                                <div class="option-description text-muted small">Allow people to send you tips</div>
                            </div>
                        </div>
                        <div class="option-toggle">
                            <label class="switch" for="tips_enabled">
                                <input type="checkbox" name="tips_enabled" id="tips_enabled" class="js_publisher-tips-toggle">
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Footer Actions -->
            <div class="post-footer">
                <!-- Privacy Settings -->
                <div class="dropdown">
                    <button class="privacy-selector dropdown-toggle"
                        type="button"
                        id="privacyDropdown"
                        data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <i class="bi bi-globe"></i>
                        <span>Public</span>
                    </button>
                    <ul class="dropdown-menu shadow-sm border-0">
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2" data-privacy="1" href="#">
                                <i class="bi bi-globe"></i> Public
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2" data-privacy="2" href="#">
                                <i class="bi bi-people-fill"></i> Friends
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2" data-privacy="3" href="#">
                                <i class="bi bi-lock-fill"></i> Only Me
                            </a>
                        </li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <a class="dropdown-item d-flex align-items-center gap-2" data-privacy="4" href="#">
                                <i class="bi bi-gear-fill"></i> Custom
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Post Actions -->
                <div class="post-submit-actions">
                    <button type="button"
                        id="resetPostForm"
                        class="reset-btn"
                        title="Reset Form">
                        <i class="bi bi-arrow-clockwise"></i>
                    </button>
                    <button type="button"
                        id="liveVideo"
                        class="live-video-btn">
                        <i class="bi bi-camera-video-fill"></i>
                        <span class="d-none d-sm-inline">Live Video</span>
                    </button>
                    <button type="button"
                        id="postButton"
                        class="post-btn">
                        Post
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Emoji Picker Modal -->
<div class="modal fade" id="emojiPickerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Choose Emoji</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="emoji-search mb-3">
                    <input type="text" class="form-control" id="emojiSearch" placeholder="Search emojis...">
                </div>
                <div class="emoji-categories mb-3">
                    <button class="btn btn-sm btn-outline-primary emoji-category active" data-category="smileys">😀</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="animals">🐶</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="food">🍕</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="activities">⚽</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="travel">✈️</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="objects">💡</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="symbols">❤️</button>
                    <button class="btn btn-sm btn-outline-primary emoji-category" data-category="flags">🏁</button>
                </div>
                <div class="emoji-grid" id="emojiGrid">
                    <!-- Emojis will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Create Post Card END -->
<?php /**PATH /Applications/MAMP/htdocs/socialink_backend/resources/views/front_end/layouts/newsfeed_box.blade.php ENDPATH**/ ?>