<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\ApiAuthController;
use App\Http\Controllers\Api\PostController;

Route::middleware('auth:sanctum')->group(function () {

    Route::prefix('posts')->group(function () {
        Route::get('/', [PostController::class, 'index']); // Get all posts
        Route::post('/', [PostController::class, 'store']); // Create a new post
        Route::get('/{id}', [PostController::class, 'show']); // Get a single post
        Route::put('/{id}', [PostController::class, 'update']); // Update a post
        Route::delete('/{id}', [PostController::class, 'destroy']); // Delete a post
    });

});
