<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\MovieController;
use App\Http\Controllers\Admin\ToolsController;
use App\Http\Controllers\Backend\JobController;
use App\Http\Controllers\Backend\PokeController;
use App\Http\Controllers\Backend\RoleController;
use App\Http\Controllers\Backend\GroupController;
use App\Http\Controllers\Backend\ReportController;
use App\Http\Controllers\Backend\BackendController;
use App\Http\Controllers\Backend\CustomPageController;
use App\Http\Controllers\Backend\Games\GameController;
use App\Http\Controllers\Backend\PermissionController;
use App\Http\Controllers\Backend\WithdrawalController;
use App\Http\Controllers\Backend\JobCategoryController;
use App\Http\Controllers\Backend\WithdrawController;
use App\Http\Controllers\Backend\DepositController;
use App\Http\Controllers\Backend\BlogCategoryController;
use App\Http\Controllers\Backend\VerificationController;
use App\Http\Controllers\Backend\RewardSettingController;
use App\Http\Controllers\Backend\PageManagementController;
use App\Http\Controllers\Backend\EventManagementController;
use App\Http\Controllers\Backend\MarketplaceManagementController;
use App\Http\Controllers\Backend\HelpCenterArticleController;
use App\Http\Controllers\Backend\HelpCenterTopicController;
use App\Http\Controllers\Backend\CourseController;
use App\Http\Controllers\Backend\CourseCategoryController;
use App\Http\Controllers\Backend\PostController;
use App\Http\Controllers\Backend\SpaceController;
use App\Http\Controllers\Admin\JobController as AdminJobController;
use App\Http\Controllers\Backend\BlogController as BackendBlogController;
use App\Http\Controllers\Backend\MovieController as BackendMovieController;
use App\Http\Controllers\Admin\JobCategoryController as AdminJobCategoryController;
use App\Http\Controllers\Backend\Games\GameCategoryController as BackendGameCategoryController;

/*
|--------------------------------------------------------------------------
| Auth Routes
|--------------------------------------------------------------------------
*/

require __DIR__ . '/auth.php';

/*
|--------------------------------------------------------------------------
| Backend Routes
|--------------------------------------------------------------------------
*/

Route::group(['namespace' => 'App\Http\Controllers\Backend', 'prefix' => 'admin', 'as' => 'admin.'], function () {

    // Requires authentication and admin role
    Route::middleware(['auth', 'admin'])->group(function () {

        /**
         * Backend Dashboard
         */
        Route::get('/', [BackendController::class, 'index'])->name('home');
        Route::get('/dashboard', [BackendController::class, 'index'])->name('dashboard');
        Route::get('/general-settings', [BackendController::class, 'generalSettings'])->name('general_settings');
        Route::get('/mail-configurations', [BackendController::class, 'mailConfiguration'])->name('mail_configurations');
        Route::get('/enable-disable-features', [BackendController::class, 'enableDisableFeatures'])->name('enable_disable_features');
        Route::get('/payment-settings', [BackendController::class, 'paymentSettings'])->name('payment_settings');
        Route::get('/social-logins', [BackendController::class, 'socialLogins'])->name('social_logins');
        Route::get('/upload-config', [BackendController::class, 'uploadConfigurations'])->name('upload_config');
        
        // Storage and Media Configuration Routes
        Route::get('/storage-config', [App\Http\Controllers\Admin\StorageController::class, 'index'])->name('storage.config');
        Route::post('/storage/update', [App\Http\Controllers\Admin\StorageController::class, 'update'])->name('storage.update');
        Route::post('/storage/test', [App\Http\Controllers\Admin\StorageController::class, 'test'])->name('storage.test');
        Route::post('/storage/reset', [App\Http\Controllers\Admin\StorageController::class, 'reset'])->name('storage.reset');
        Route::post('/media/update', [App\Http\Controllers\Admin\MediaController::class, 'update'])->name('media.update');
        Route::get('/website-info', [BackendController::class, 'websiteInfo'])->name('website_info');
        Route::get('/pro-system', [BackendController::class, 'proSystem'])->name('pro_system');
        Route::get('/audio-video-settings', [BackendController::class, 'audio_video_settings'])->name('audio_video_settings');
        Route::get('/nodejs-settings', [BackendController::class, 'nodejs_settings'])->name('nodejs_settings');
        Route::get('/cronjob-settings', [BackendController::class, 'cronJobSettings'])->name('cronjob_settings');
        Route::get('/ai-settings', [BackendController::class, 'aiSettings'])->name('ai_settings');
        Route::get('/post-settings', [BackendController::class, 'postSettings'])->name('post_settings');
        Route::get('/manage-colored-posts', [BackendController::class, 'manageColorPost'])->name('color_post');
        Route::get('/manage-reactions', [BackendController::class, 'manageReactions'])->name('manage_reactions');
        Route::get('/live-streaming', [BackendController::class, 'liveStreaming'])->name('live_streaming');
        
        
        /**
         * Movie Routes
         */
        Route::prefix('movies')->name('movies.')->group(function () {
            Route::get('/', [BackendMovieController::class, 'index'])->name('index');
            Route::get('/create', [BackendMovieController::class, 'create'])->name('create');
            Route::post('/store', [BackendMovieController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [BackendMovieController::class, 'edit'])->name('edit');
            Route::post('/update/{id}', [BackendMovieController::class, 'update'])->name('update');
            Route::delete('/delete/{id}', [BackendMovieController::class, 'destroy'])->name('destroy');
        });

        /**
         * Game Routes
         */
        Route::prefix('games')->name('games.')->group(function () {
            Route::get('/', [GameController::class, 'index'])->name('index');
            Route::get('/create', [GameController::class, 'create'])->name('create');
            Route::post('/store', [GameController::class, 'store'])->name('store');
            Route::get('/edit/{game}', [GameController::class, 'edit'])->name('edit');
            Route::post('/update/{game}', [GameController::class, 'update'])->name('update');
            Route::delete('/delete/{game}', [GameController::class, 'destroy'])->name('destroy');

            // Game Categories
            Route::prefix('categories')->name('categories.')->group(function () {
                Route::get('/', [BackendGameCategoryController::class, 'index'])->name('index');
                Route::get('/create', [BackendGameCategoryController::class, 'create'])->name('create');
                Route::post('/store', [BackendGameCategoryController::class, 'store'])->name('store');
                Route::get('/edit/{category}', [BackendGameCategoryController::class, 'edit'])->name('edit');
                Route::post('/update/{category}', [BackendGameCategoryController::class, 'update'])->name('update');
                Route::delete('/delete/{category}', [BackendGameCategoryController::class, 'destroy'])->name('destroy');
            });
        });

       
        Route::prefix('pokes')->name('pokes.')->group(function () {
            Route::get('/', [PokeController::class, 'index'])->name('index');
            Route::delete('/{poke}', [PokeController::class, 'delete'])->name('destroy');
        });
        
        /**
         * Verification Routes
         */
        Route::prefix('verification')->name('verification.')->group(function () {
            Route::get('/', [VerificationController::class, 'index'])->name('index');
            Route::get('/{id}', [VerificationController::class, 'show'])->name('show');
            Route::post('/{id}/approve', [VerificationController::class, 'approve'])->name('approve');
            Route::post('/{id}/reject', [VerificationController::class, 'reject'])->name('reject');
            Route::get('/{id}/download/{type}', [VerificationController::class, 'downloadDocument'])->name('download');
        });

        /**
         * Custom Pages Routes
         */
        Route::prefix('custom-pages')->name('custom-pages.')->group(function () {
            Route::get('/', [CustomPageController::class, 'index'])->name('index');
            Route::get('/create', [CustomPageController::class, 'create'])->name('create');
            Route::post('/', [CustomPageController::class, 'store'])->name('store');
            Route::get('/{customPage}', [CustomPageController::class, 'show'])->name('show');
            Route::get('/{customPage}/edit', [CustomPageController::class, 'edit'])->name('edit');
            Route::put('/{customPage}', [CustomPageController::class, 'update'])->name('update');
            Route::delete('/{customPage}', [CustomPageController::class, 'destroy'])->name('destroy');
            
            // Trashed pages
            Route::get('/trash/all', [CustomPageController::class, 'trashed'])->name('trashed');
            Route::post('/trash/{id}/restore', [CustomPageController::class, 'restore'])->name('restore');
            Route::delete('/trash/{id}', [CustomPageController::class, 'forceDelete'])->name('force-delete');
        });

        /**
         * Help Center Routes
         */
        Route::prefix('help-center')->name('help-center.')->group(function () {
            Route::resource('topics', HelpCenterTopicController::class)->except(['show']);
            Route::resource('articles', HelpCenterArticleController::class)->except(['show']);
        });

        /**
         * Groups Management Routes
         */
        Route::prefix('groups')->name('groups.')->group(function () {
            // Main group routes
            Route::get('/', [GroupController::class, 'index'])->name('index');
            Route::get('/group/{id}', [GroupController::class, 'show'])->name('show');
            Route::put('/{id}', [GroupController::class, 'update'])->name('update');
            Route::post('/{id}/status', [GroupController::class, 'updateStatus'])->name('update-status');
            Route::delete('destory/{id}', [GroupController::class, 'destroy'])->name('destroy');
            
            // Featured groups
            Route::get('/featured/list', [GroupController::class, 'featured'])->name('featured');
            Route::post('/{id}/toggle-featured', [GroupController::class, 'toggleFeatured'])->name('toggle-featured');
            
            // Reported groups
            Route::get('/reported/list', [GroupController::class, 'reported'])->name('reported');
            
            // Group categories
            Route::get('/categories/list', [GroupController::class, 'categories'])->name('categories');
            Route::post('/categories', [GroupController::class, 'storeCategory'])->name('store-category');
            Route::put('/categories/{id}', [GroupController::class, 'updateCategory'])->name('update-category');
            Route::delete('/categories/{id}', [GroupController::class, 'deleteCategory'])->name('delete-category');
            Route::put('/report/update/{id}', [GroupController::class, 'updateReport'])->name('update-report');
            Route::put('/report/delete/{id}', [GroupController::class, 'deleteReport'])->name('delete-report');
            // Group statistics
            Route::get('/statistics/view', [GroupController::class, 'statistics'])->name('statistics');
        });

        /**
         * Spaces Management Routes
         */
        Route::prefix('spaces')->name('spaces.')->group(function () {
            Route::get('/', [SpaceController::class, 'index'])->name('index');
            Route::get('/{id}', [SpaceController::class, 'show'])->name('show');
        });

        /**
         * Blog Routes
         */
        Route::prefix('blogs')->name('blogs.')->group(function () {
            Route::get('/', [BackendBlogController::class, 'index'])->name('index');
            Route::get('/create', [BackendBlogController::class, 'create'])->name('create');
            Route::post('/', [BackendBlogController::class, 'store'])->name('store');
            Route::get('/{blog}', [BackendBlogController::class, 'show'])->name('show');
            Route::get('/{blog}/edit', [BackendBlogController::class, 'edit'])->name('edit');
            Route::put('/{blog}', [BackendBlogController::class, 'update'])->name('update');
            Route::delete('/{blog}', [BackendBlogController::class, 'destroy'])->name('destroy');
        });

        /**
         * Post Routes
         */
        Route::prefix('posts')->name('posts.')->group(function () {
            Route::get('/', [PostController::class, 'index'])->name('index');
            Route::get('/{id}', [PostController::class, 'show'])->name('show');
            Route::delete('/{id}', [PostController::class, 'destroy'])->name('destroy');
        });

        /**
         * General Settings & File Upload
         */
        Route::post('update-general-settings', [BackendController::class, 'updateSettings'])->name('settings.update');
        Route::post('/upload', [BackendController::class, 'upload'])->name('uploadFile');
        Route::get('/file/{folder}/{filename}', [BackendController::class, 'getFile']);

        /**
         * Settings Routes
         */
        Route::group(['middleware' => ['can:edit_settings']], function () {
            Route::get('settings', 'SettingController@index')->name('settings.index');
            Route::post('settings', 'SettingController@store')->name('settings.store');
        });

        /**
         * Notification Routes
         */
        Route::prefix('notifications')->name('notifications.')->group(function () {
            Route::get('/', 'NotificationsController@index')->name('index');
            Route::get('/markAllAsRead', 'NotificationsController@markAllAsRead')->name('markAllAsRead');
            Route::delete('/deleteAll', 'NotificationsController@deleteAll')->name('deleteAll');
            Route::get('/{id}', 'NotificationsController@show')->name('show');
        });

        /**
         * Backup Routes
         */
        Route::prefix('backups')->name('backups.')->group(function () {
            Route::get('/', 'BackupController@index')->name('index');
            Route::get('/create', 'BackupController@create')->name('create');
            Route::get('/download/{file_name}', 'BackupController@download')->name('download');
            Route::get('/delete/{file_name}', 'BackupController@delete')->name('delete');
        });

        /**
         * Role Management Routes
         */
        Route::prefix('roles')->name('roles.')->group(function () {
            Route::get('',[RoleController::class,'index'])->name('index');
            Route::get('create',[RoleController::class,'create'])->name('create');
            Route::post('store',[RoleController::class,'store'])->name('store');
            Route::get('edit/{id}',[RoleController::class,'edit'])->name('edit');
            Route::put('update/{id}',[RoleController::class,'update'])->name('update');
            // Route::post('delete/{id}',[RoleController::class,'delete'])->name('delete');
            Route::get('assign-permission/{id}',[RoleController::class,'assignpermission'])->name('assignpermission');
            Route::post('allowpermission/{id}', [RoleController::class, 'allowpermissions'])->name('allowpermissions');
        });
        /**
         * User Management Routes
         */
        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/index_list', 'UserController@index_list')->name('show');
            Route::get('/{id}/resend-email-confirmation', 'UserController@emailConfirmationResend')->name('emailConfirmationResend');
            Route::delete('/user-provider-destroy', 'UserController@userProviderDestroy')->name('userProviderDestroy');
            Route::get('/{id}/change-password', 'UserController@changePassword')->name('changePassword');
            Route::patch('/{id}/change-password', 'UserController@changePasswordUpdate')->name('changePasswordUpdate');
            Route::get('/trashed', 'UserController@trashed')->name('trashed');
            Route::patch('/{id}/trashed', 'UserController@restore')->name('restore');
            Route::get('/index_data', 'UserController@index_data')->name('index_data');
            Route::get('/index_list', 'UserController@index_list')->name('index_list');
            Route::patch('/{id}/block', 'UserController@block')->name('block')->middleware('can:block_users');
            Route::patch('/{id}/unblock', 'UserController@unblock')->name('unblock')->middleware('can:block_users');
        });
        Route::resource('users', 'UserController');

        /**
         * Blog Category Routes
         */
        Route::resource('blog-categories', BlogCategoryController::class);
        Route::post('blog-categories/{id}/toggle-status', [BlogCategoryController::class, 'toggleStatus'])->name('blog-categories.toggle-status');
        Route::post('blog-categories/bulk-toggle-status', [BlogCategoryController::class, 'bulkToggleStatus'])->name('blog-categories.bulk-toggle-status');
        Route::post('blog-categories/bulk-delete', [BlogCategoryController::class, 'bulkDelete'])->name('blog-categories.bulk-delete');
        Route::get('blog-categories/search', [BlogCategoryController::class, 'search'])->name('blog-categories.search');

        /**
         * Job Management Routes
         */
        Route::prefix('jobs')->name('jobs.')->group(function () {
            Route::get('/', [JobController::class, 'index'])->name('index');
            Route::get('/{id}', [JobController::class, 'show'])->name('show');
            Route::get('/{id}/edit', [JobController::class, 'edit'])->name('edit');
            Route::put('/{id}', [JobController::class, 'update'])->name('update');
            Route::delete('/{id}', [JobController::class, 'destroy'])->name('destroy');
            Route::get('/{id}/applications', [JobController::class, 'applications'])->name('applications');
            Route::put('/application/{applicationId}/status', [JobController::class, 'updateApplicationStatus'])->name('application.status');
            Route::put('/{id}/toggle-status', [JobController::class, 'toggleStatus'])->name('toggle-status');
            Route::get('/dashboard/stats', [JobController::class, 'stats'])->name('stats');
        });
        /**
         * Course Routes
         */
        Route::prefix('courses')->name('courses.')->group(function () {
            Route::get('/dashboard/stats', [CourseController::class, 'stats'])->name('stats');
            Route::get('/create', [CourseController::class, 'create'])->name('create');
            Route::post('/', [CourseController::class, 'store'])->name('store');
            Route::get('/', [CourseController::class, 'index'])->name('index');
            Route::get('/{id}/edit', [CourseController::class, 'edit'])->name('edit');
            Route::get('/{id}/enrollments', [CourseController::class, 'enrollments'])->name('enrollments');
            Route::put('/{id}/toggle-status', [CourseController::class, 'toggleStatus'])->name('toggle-status');
            Route::put('/{id}/toggle-featured', [CourseController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::put('/{id}', [CourseController::class, 'update'])->name('update');
            Route::delete('/{id}', [CourseController::class, 'destroy'])->name('destroy');
            Route::get('/{id}', [CourseController::class, 'show'])->name('show');
        });

        /**
         * Course Category Routes
         */
        Route::prefix('course-categories')->name('course-categories.')->group(function () {
            Route::get('/', [CourseCategoryController::class, 'index'])->name('index');
            Route::get('/create', [CourseCategoryController::class, 'create'])->name('create');
            Route::post('/', [CourseCategoryController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [CourseCategoryController::class, 'edit'])->name('edit');
            Route::put('/{id}', [CourseCategoryController::class, 'update'])->name('update');
            Route::delete('/{id}', [CourseCategoryController::class, 'destroy'])->name('destroy');
            Route::put('/{id}/toggle-status', [CourseCategoryController::class, 'toggleStatus'])->name('toggle-status');
        });

        /**
         * Job Category Routes
         */
        Route::prefix('job-categories')->name('job-categories.')->group(function () {
            Route::get('/', [JobCategoryController::class, 'index'])->name('index');
            Route::get('/{id}/edit', [JobCategoryController::class, 'edit'])->name('edit');
            Route::put('/{id}', [JobCategoryController::class, 'update'])->name('update');
            Route::put('/{id}/toggle-status', [JobCategoryController::class, 'toggleStatus'])->name('toggle-status');
        });

        /**
         * Tools Routes
         */
        Route::prefix('tools')->name('tools.')->group(function () {
            // Data Management
            Route::get('/', [ToolsController::class, 'index'])->name('index');
            Route::post('/delete', [ToolsController::class, 'deleteData'])->name('delete');
            
            // Database Backup
            Route::get('/backup', [ToolsController::class, 'backupDatabase'])->name('backup');
            Route::post('/generate-backup', [ToolsController::class, 'generateBackup'])->name('generate-backup');
            Route::get('/backups', [ToolsController::class, 'listBackups'])->name('backups');
            Route::get('/download-backup/{filename}', [ToolsController::class, 'downloadBackup'])->name('download-backup');
            Route::delete('/delete-backup/{filename}', [ToolsController::class, 'deleteBackup'])->name('delete-backup');
            
            // Blacklist Management
            Route::get('/blacklist', [ToolsController::class, 'blacklist'])->name('blacklist');
            Route::post('/blacklist/add', [ToolsController::class, 'addToBlacklist'])->name('blacklist.add');
            Route::delete('/blacklist/remove/{id}', [ToolsController::class, 'removeFromBlacklist'])->name('blacklist.remove');
            Route::post('/blacklist/remove-multiple', [ToolsController::class, 'removeMultipleFromBlacklist'])->name('blacklist.remove-multiple');
            Route::get('/blacklist/search', [ToolsController::class, 'searchBlacklist'])->name('blacklist.search');
            
            // Fake User Generator
            Route::get('/fake-user-generator', [ToolsController::class, 'fakeUserGenerator'])->name('fake-user-generator');
            Route::post('/generate-fake-users', [ToolsController::class, 'generateFakeUsers'])->name('generate-fake-users');
            Route::get('/delete-fake-users', [ToolsController::class, 'deleteAllFakeUsers'])->name('delete-fake-users');
        });

        Route::resource('reward-settings', RewardSettingController::class);

        // Package Management
        Route::prefix('packages')->name('packages.')->group(function () {
            Route::get('/', [App\Http\Controllers\Admin\PackageController::class, 'index'])->name('index');
            Route::get('/create', [App\Http\Controllers\Admin\PackageController::class, 'create'])->name('create');
            Route::post('/', [App\Http\Controllers\Admin\PackageController::class, 'store'])->name('store');
            Route::get('/{package}', [App\Http\Controllers\Admin\PackageController::class, 'show'])->name('show');
            Route::get('/{package}/edit', [App\Http\Controllers\Admin\PackageController::class, 'edit'])->name('edit');
            Route::put('/{package}', [App\Http\Controllers\Admin\PackageController::class, 'update'])->name('update');
            Route::delete('/{package}', [App\Http\Controllers\Admin\PackageController::class, 'destroy'])->name('destroy');
        });

        // Deposits Management
        Route::prefix('deposits')->name('deposits.')->group(function () {
            Route::get('/', [App\Http\Controllers\Admin\DepositController::class, 'index'])->name('index');
        });

        // Withdraw Requests Management
        Route::prefix('withdraw-requests')->name('withdraw-requests.')->group(function () {
            Route::get('/', [App\Http\Controllers\Admin\WithdrawRequestController::class, 'index'])->name('index');
            Route::get('/{id}', [App\Http\Controllers\Admin\WithdrawRequestController::class, 'show'])->name('show');
            Route::put('/{id}/update-status', [App\Http\Controllers\Admin\WithdrawRequestController::class, 'updateStatus'])->name('update-status');
        });
        Route::prefix('withdrawals')->name('withdrawals.')->group(function () {
            Route::get('/', [WithdrawalController::class, 'index'])->name('index');
            Route::get('/{withdrawal}', [WithdrawalController::class, 'show'])->name('show');
            Route::post('/{withdrawal}/approve', [WithdrawalController::class, 'approve'])->name('approve');
            Route::post('/{withdrawal}/complete', [WithdrawalController::class, 'complete'])->name('complete');
            Route::post('/{withdrawal}/reject', [WithdrawalController::class, 'reject'])->name('reject');
        });


        /**
         * Reports Management Routes
         */
        Route::prefix('reports')->name('reports.')->group(function () {
            Route::get('/', [ReportController::class, 'index'])->name('index');
            
            // User Reports
            Route::get('/user-reports', [ReportController::class, 'userReports'])->name('user-reports');
            Route::get('/user-reports/{id}', [ReportController::class, 'showUserReport'])->name('user-reports.show');
            Route::post('/user-reports/{id}/status', [ReportController::class, 'updateUserReportStatus'])->name('user-reports.update-status');
            Route::delete('/user-reports/{id}', [ReportController::class, 'deleteUserReport'])->name('user-reports.delete');
            Route::post('/user-reports/resolve-all/{userId}', [ReportController::class, 'resolveAllUserReports'])->name('user-reports.resolve-all');
            
            // Post Reports
            Route::get('/post-reports', [ReportController::class, 'postReports'])->name('post-reports');
            Route::get('/post-reports/{id}', [ReportController::class, 'showPostReport'])->name('post-reports.show');
            Route::post('/post-reports/{id}/status', [ReportController::class, 'updatePostReportStatus'])->name('post-reports.update-status');
            Route::delete('/post-reports/{id}', [ReportController::class, 'deletePostReport'])->name('post-reports.delete');
            Route::post('/post-reports/resolve-all/{postId}', [ReportController::class, 'resolveAllPostReports'])->name('post-reports.resolve-all');

            // Module Reports
            Route::get('/module-reports', [ReportController::class, 'moduleReports'])->name('module-reports');
            Route::get('/module-reports/{id}', [ReportController::class, 'showModuleReport'])->name('module-reports.show');
            Route::post('/module-reports/action', [ReportController::class, 'moduleAction'])->name('module-reports.action');
            Route::delete('/module-reports/{id}', [ReportController::class, 'deleteModuleReport'])->name('module-reports.delete');
        });

        // Page Management Routes
        Route::prefix('pages')->name('pages.')->group(function () {
            Route::get('/', [PageManagementController::class, 'index'])->name('index');
            Route::get('/show/{id}', [PageManagementController::class, 'show'])->name('show');
            Route::get('/edit/{id}', [PageManagementController::class, 'edit'])->name('edit');
            Route::put('/update/{id}', [PageManagementController::class, 'update'])->name('update');
            Route::post('/toggle-featured/{id}', [PageManagementController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::put('/status/{id}', [PageManagementController::class, 'updateStatus'])->name('update-status');
            Route::get('/featured', [PageManagementController::class, 'featured'])->name('featured');
            Route::get('/statistics', [PageManagementController::class, 'statistics'])->name('statistics');
            Route::delete('/{id}', [PageManagementController::class, 'destroy'])->name('destroy');
        });

        // Events Management
        Route::prefix('events')->name('events.')->group(function () {
            Route::get('/', [EventManagementController::class, 'index'])->name('index');
            Route::get('/show/{id}', [EventManagementController::class, 'show'])->name('show');
            Route::post('/toggle-featured/{id}', [EventManagementController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/update-status/{id}', [EventManagementController::class, 'updateStatus'])->name('update-status');
            Route::get('/featured', [EventManagementController::class, 'featured'])->name('featured');
            Route::get('/statistics', [EventManagementController::class, 'statistics'])->name('statistics');
            Route::delete('/{id}', [EventManagementController::class, 'destroy'])->name('destroy');
        });
        Route::prefix('permissions')->name('permissions.')->group(function () {
            Route::get('',[PermissionController::class,'index'])->name('index');
            Route::get('create',[PermissionController::class,'create'])->name('create');
            Route::post('store',[PermissionController::class,'store'])->name('store');
            Route::get('edit/{id}',[PermissionController::class,'edit'])->name('edit');
            Route::put('update/{id}',[PermissionController::class,'update'])->name('update');
            Route::post('delete/{id}',[PermissionController::class,'delete'])->name('delete');
        });

        
        /**
         * Marketplace Management Routes
         */
        Route::prefix('marketplace')->name('marketplace.')->group(function () {
            Route::get('/dashboard', [MarketplaceManagementController::class, 'dashboard'])->name('dashboard');
            
            // Products
            Route::get('/products', [MarketplaceManagementController::class, 'products'])->name('products');
            Route::get('/products/{id}', [MarketplaceManagementController::class, 'showProduct'])->name('products.show');
            Route::post('/products/update-status/{id}', [MarketplaceManagementController::class, 'updateProductStatus'])->name('products.update-status');
            Route::delete('/products/{id}', [MarketplaceManagementController::class, 'destroyProduct'])->name('products.destroy');
            
            // Stores
            Route::get('/stores', [MarketplaceManagementController::class, 'stores'])->name('stores');
            Route::get('/stores/{id}', [MarketplaceManagementController::class, 'showStore'])->name('stores.show');
            Route::post('/stores/update-status/{id}', [MarketplaceManagementController::class, 'updateStoreStatus'])->name('stores.update-status');
            
            // Orders
            Route::get('/orders', [MarketplaceManagementController::class, 'orders'])->name('orders');
            Route::get('/orders/{id}', [MarketplaceManagementController::class, 'showOrder'])->name('orders.show');
            Route::post('/orders/update-status/{id}', [MarketplaceManagementController::class, 'updateOrderStatus'])->name('orders.update-status');
            
            // Reviews
            Route::get('/reviews', [MarketplaceManagementController::class, 'reviews'])->name('reviews');
            Route::delete('/reviews/{id}', [MarketplaceManagementController::class, 'destroyReview'])->name('reviews.destroy');
            
            // Categories
            Route::get('/categories', [MarketplaceManagementController::class, 'categories'])->name('categories');
            Route::post('/categories', [MarketplaceManagementController::class, 'storeCategory'])->name('categories.store');
            Route::post('/categories/{id}', [MarketplaceManagementController::class, 'updateCategory'])->name('categories.update');
            Route::delete('/categories/{id}', [MarketplaceManagementController::class, 'destroyCategory'])->name('categories.destroy');
            
            // Settings
            Route::get('/settings', [MarketplaceManagementController::class, 'settings'])->name('settings');
            Route::post('/settings', [MarketplaceManagementController::class, 'updateSettings'])->name('update-settings');
        });
    });
    // Sitemap routes
    Route::get('/tools/sitemap', [ToolsController::class, 'sitemap'])->name('tools.sitemap');
    Route::post('/tools/generate-sitemap', [ToolsController::class, 'generateSitemap'])->name('tools.generate-sitemap');

    Route::get('/tools/send-email', [ToolsController::class, 'showEmailForm'])->name('tools.send-email-form');
    Route::post('/tools/send-email', [ToolsController::class, 'sendEmail'])->name('tools.send-email');
});
