@extends('layouts.app')

@section('title', 'Withdraw - ' . config('app.name'))

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-4xl mx-auto">
        <!-- Page Header -->
        <div class="mb-8">
            <div class="flex items-center mb-4">
                <a href="{{ route('wallet.index') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 mr-3">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Withdraw Funds</h1>
            </div>
            <p class="text-gray-600 dark:text-gray-400">Withdraw your earnings to your preferred payment method</p>
        </div>

        <!-- Current Balance -->
        <div class="bg-white dark:bg-gray-800 rounded-lg p-6 mb-8 shadow-sm border border-gray-200 dark:border-gray-700">
            <div class="flex items-center justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Available Balance</h2>
                    <div class="text-3xl font-bold text-green-600 dark:text-green-400">${{ number_format($balance, 2) }}</div>
                </div>
                <div class="bg-green-100 dark:bg-green-900 rounded-full p-3">
                    <svg class="w-8 h-8 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
        </div>

        @if($balance < 10)
            <!-- Insufficient Balance Warning -->
            <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-8">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-yellow-800 dark:text-yellow-200">Insufficient Balance</h3>
                        <div class="mt-2 text-sm text-yellow-700 dark:text-yellow-300">
                            <p>You need a minimum balance of $10.00 to request a withdrawal. Your current balance is ${{ number_format($balance, 2) }}.</p>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <!-- Withdrawal Form -->
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Withdrawal Request</h3>
                </div>
                
                <form action="{{ route('withdraw.request') }}" method="POST" class="p-6">
                    @csrf
                    
                    <!-- Amount Input -->
                    <div class="mb-6">
                        <label for="amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Withdrawal Amount</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 dark:text-gray-400 sm:text-sm">$</span>
                            </div>
                            <input type="number" id="amount" name="amount" min="10" max="{{ $balance }}" step="0.01" 
                                   class="block w-full pl-7 pr-12 py-3 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                   placeholder="0.00" required>
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                                <span class="text-gray-500 dark:text-gray-400 sm:text-sm">USD</span>
                            </div>
                        </div>
                        <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                            Min: $10.00, Max: ${{ number_format($balance, 2) }}
                        </p>
                    </div>

                    <!-- Payment Method Selection -->
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">Payment Method</label>
                        <div class="space-y-3">
                            @foreach($withdrawMethods as $method)
                            <label class="relative flex cursor-pointer rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 p-4 shadow-sm focus:outline-none">
                                <input type="radio" name="withdraw_method_id" value="{{ $method['id'] }}" class="sr-only" {{ $loop->first ? 'checked' : '' }}>
                                <span class="flex flex-1">
                                    <span class="flex flex-col">
                                        <span class="block text-sm font-medium text-gray-900 dark:text-white">{{ $method['name'] }}</span>
                                        <span class="mt-1 flex items-center text-sm text-gray-500 dark:text-gray-400">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                            </svg>
                                            Min: ${{ $method['min_amount'] }}
                                        </span>
                                    </span>
                                </span>
                                <svg class="h-5 w-5 text-blue-600" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <!-- Payment Details -->
                    <div id="payment-details" class="mb-6">
                        <!-- PayPal Details -->
                        <div id="paypal-details" class="payment-method-details">
                            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-3">PayPal Account Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="paypal_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">PayPal Email</label>
                                    <input type="email" id="paypal_email" name="payment_details[paypal_email]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="your@email.com" required>
                                </div>
                                <div>
                                    <label for="paypal_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Account Name</label>
                                    <input type="text" id="paypal_name" name="payment_details[paypal_name]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="Your Full Name" required>
                                </div>
                            </div>
                        </div>

                        <!-- Bank Transfer Details -->
                        <div id="bank-details" class="payment-method-details hidden">
                            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-3">Bank Account Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="bank_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Bank Name</label>
                                    <input type="text" id="bank_name" name="payment_details[bank_name]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="Bank Name">
                                </div>
                                <div>
                                    <label for="account_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Account Name</label>
                                    <input type="text" id="account_name" name="payment_details[account_name]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="Account Holder Name">
                                </div>
                                <div>
                                    <label for="account_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Account Number</label>
                                    <input type="text" id="account_number" name="payment_details[account_number]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="Account Number">
                                </div>
                                <div>
                                    <label for="routing_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Routing Number</label>
                                    <input type="text" id="routing_number" name="payment_details[routing_number]" 
                                           class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                           placeholder="Routing Number">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Notes -->
                    <div class="mb-6">
                        <label for="notes" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Additional Notes (Optional)</label>
                        <textarea id="notes" name="notes" rows="3" 
                                  class="block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" 
                                  placeholder="Any additional information..."></textarea>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex items-center justify-between">
                        <a href="{{ route('wallet.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="bg-blue-600 hover:bg-blue-700 text-white font-medium py-3 px-6 rounded-lg transition-colors">
                            Request Withdrawal
                        </button>
                    </div>
                </form>
            </div>

            <!-- Processing Time Notice -->
            <div class="mt-8 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-blue-800 dark:text-blue-200">Processing Time</h3>
                        <div class="mt-2 text-sm text-blue-700 dark:text-blue-300">
                            <p>Withdrawal requests are typically processed within 2-5 business days. You will receive a confirmation email once processed.</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Recent Withdrawals -->
        <div class="mt-8">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Recent Withdrawals</h3>
                <a href="{{ route('withdraw_list') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 text-sm font-medium">View All</a>
            </div>
            
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700">
                <div class="p-6 text-center text-gray-500 dark:text-gray-400">
                    <svg class="w-12 h-12 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <p>No withdrawal history yet</p>
                    <p class="text-sm mt-1">Your withdrawal requests will appear here</p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const withdrawMethods = document.querySelectorAll('input[name="withdraw_method_id"]');
    const paypalDetails = document.getElementById('paypal-details');
    const bankDetails = document.getElementById('bank-details');

    withdrawMethods.forEach(method => {
        method.addEventListener('change', function() {
            if (this.value === '1') { // PayPal
                paypalDetails.classList.remove('hidden');
                bankDetails.classList.add('hidden');
            } else if (this.value === '2') { // Bank Transfer
                paypalDetails.classList.add('hidden');
                bankDetails.classList.remove('hidden');
            }
        });
    });

    // Amount validation
    const amountInput = document.getElementById('amount');
    amountInput.addEventListener('input', function() {
        const amount = parseFloat(this.value);
        const maxAmount = {{ $balance }};
        
        if (amount > maxAmount) {
            this.setCustomValidity('Amount cannot exceed your available balance');
        } else if (amount < 10) {
            this.setCustomValidity('Minimum withdrawal amount is $10.00');
        } else {
            this.setCustomValidity('');
        }
    });
});
</script>
@endpush
@endsection
