@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp

@section('title', __('pick_your_plan'))

@section('left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">

    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('newsfeed') }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">{{ __('pick_your_plan') }}</h4>
                                <p class="mb-0 text-white">{{ __('pro_features_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Packages Section -->
    <div class="container py-5">
        <div class="row">
            @foreach($packages as $package)
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title text-uppercase text-center">{{ $package['name'] }}</h5>
                        <h6 class="card-price text-center">
                            ${{ $package['package_price'] }}
                            @if($package['package_price'] > 0)
                                <span class="period">/{{ $package['duration'] }}</span>
                            @endif
                        </h6>
                        <hr>
                        <ul class="fa-ul mb-4">
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['verified_badge'] ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ __('verified_badge') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['edit_post'] ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ __('edit_post') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['business_page'] ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ __('business') }} {{ __('page') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['product_limit'] > 0 ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ $package['product_limit'] > 0 ? $package['product_limit'] : '' }} {{ __('monthly_product_create_limit') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['space_limit'] > 0 ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ $package['space_limit'] > 0 ? $package['space_limit'] : '' }} {{ __('monthly_space_create_limit_on_app') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['job_limit'] > 0 ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ $package['job_limit'] > 0 ? $package['job_limit'] : '' }} {{ __('monthly_job_offer_limit') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['course_limit'] > 0 ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ $package['course_limit'] > 0 ? $package['course_limit'] : '' }} {{ __('monthly_course_offer_limit') }}
                            </li>
                            <li>
                                <span class="fa-li">
                                    <i class="fas {{ $package['event_limit'] > 0 ? 'fa-check text-success' : 'fa-times text-danger' }}"></i>
                                </span>
                                {{ $package['event_limit'] > 0 ? $package['event_limit'] : '' }} {{ __('monthly_event_offer_limit') }}
                            </li>
                        </ul>

                        <div class="d-grid mt-auto">
                            @if($user['level'] == $package['id'])
                                <a href="#" class="btn btn-success-soft text-uppercase">
                                    <i class="bi bi-check-circle"></i> {{ __('selected') }}
                                </a>
                            @else
                                <button class="btn btn-primary-soft text-uppercase purchase-package" data-package-id="{{ $package['id'] }}">
                                    {{ __('select') }}
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>


<script>
    $(document).on('click', '.purchase-package', function() {
        const button = $(this);
        Swal.fire({
            title: "{{ __('confirmation_title') }}",
            text: "{{ __('confirmation_text') }}",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "{{ __('yes') }}",
            cancelButtonText: "{{ __('cancel') }}"
        }).then((result) => {
            if (result.isConfirmed) {
                const packageId = button.data('package-id');
                button.html("{{ __('sending_request') }}");

                $.ajax({
                    type: "POST",
                    url: "{{ url('web_api/upgrade-to-pro') }}",
                    data: {
                        package_id: packageId,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        Swal.fire({
                            title: "{{ __('success') }}",
                            icon: "success",
                            html: response.message,
                            timer: 4000,
                            timerProgressBar: true
                        }).then(() => {
                            window.location.href = "{{ url('packages') }}";
                        });
                    },
                    error: function() {
                        button.html("{{ __('send_request') }}");
                    }
                });
            }
        });
    });
</script>


@endsection
