@extends('front_end.layouts.home')

@section('title', 'Transaction History')

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('wallet.index') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Transaction History</h4>
                                    <p class="mb-0 text-white">View all your wallet transactions</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">All Transactions</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered" id="transactionsTable">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Description</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Reference</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
                
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        <button class="btn btn-secondary" id="prevPage" disabled>Previous</button>
                        <button class="btn btn-secondary" id="nextPage">Next</button>
                    </div>
                    <div>
                        <span id="pageInfo">Page 1</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let currentPage = 0;
const limit = 10;

function loadTransactions(offset = 0) {
    fetch(`{{ route('wallet.transaction.history') }}?offset=${offset}&limit=${limit}`)
    .then(response => response.json())
    .then(data => {
        const tbody = document.querySelector('#transactionsTable tbody');
        tbody.innerHTML = '';
        
        if (data.status === 200 && data.data.length > 0) {
            data.data.forEach(transaction => {
                const amount = transaction.flag === 'C' || transaction.type === 'credit' ? 
                    `+$${parseFloat(transaction.amount).toFixed(2)}` : 
                    `-$${parseFloat(transaction.amount).toFixed(2)}`;
                const amountClass = transaction.flag === 'C' || transaction.type === 'credit' ? 'text-success' : 'text-danger';
                
                const row = `<tr>
                    <td>${new Date(transaction.created_at).toLocaleDateString()}</td>
                    <td>${transaction.description}</td>
                    <td>${transaction.type || transaction.flag}</td>
                    <td class="${amountClass}">${amount}</td>
                    <td>${transaction.reference_id || 'N/A'}</td>
                </tr>`;
                tbody.innerHTML += row;
            });
            
            // Update pagination
            document.getElementById('prevPage').disabled = offset === 0;
            document.getElementById('nextPage').disabled = data.data.length < limit;
            document.getElementById('pageInfo').textContent = `Page ${Math.floor(offset/limit) + 1}`;
        } else {
            tbody.innerHTML = '<tr><td colspan="5" class="text-center">No transactions found</td></tr>';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.querySelector('#transactionsTable tbody').innerHTML = '<tr><td colspan="5" class="text-center text-danger">Error loading transactions</td></tr>';
    });
}

document.getElementById('prevPage').addEventListener('click', function() {
    if (currentPage > 0) {
        currentPage--;
        loadTransactions(currentPage * limit);
    }
});

document.getElementById('nextPage').addEventListener('click', function() {
    currentPage++;
    loadTransactions(currentPage * limit);
});

// Load initial data
loadTransactions();
</script>

@endsection