@extends('front_end.layouts.home')

@section('title', 'Deposit via Paystack')

@section('content')
<div class="card border-0 shadow-sm rounded-3">
    <div class="card-header bg-primary text-white">
        <div class="d-flex align-items-center">
            <a href="{{ route('wallet.index') }}" class="text-white me-3"><i class="fas fa-arrow-left"></i></a>
            <div>
                <h5 class="mb-0">Deposit via Paystack</h5>
                <small>Card, bank, USSD and more</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="mb-3">
            <label class="form-label">Amount (USD)</label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" min="1" step="0.01" class="form-control" id="amount" placeholder="0.00" />
            </div>
        </div>
        <div class="d-flex justify-content-end gap-2">
            <a href="{{ route('wallet.index') }}" class="btn btn-light">Cancel</a>
            <button class="btn btn-primary" id="payBtn">Continue to Paystack</button>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const amountEl = document.getElementById('amount');
    const payBtn = document.getElementById('payBtn');
    payBtn.addEventListener('click', async () => {
        const amount = parseFloat(amountEl.value || '0');
        if (amount < 1) { alert('Please enter at least $1.00'); return; }
        payBtn.disabled = true; payBtn.textContent = 'Redirecting...';
        const res = await fetch("{{ route('wallet.deposit.paystack.create') }}", {
            method: 'POST', headers: { 'Content-Type':'application/json', 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            body: JSON.stringify({ amount })
        });
        const json = await res.json();
        if (json.redirect) window.location.href = json.redirect; else {
            alert('Failed to initiate Paystack payment');
            payBtn.disabled = false; payBtn.textContent = 'Continue to Paystack';
        }
    });
});
</script>
@endpush
@endsection


