@extends('front_end.layouts.home')

@section('title', 'Deposit via PayPal')

@section('content')
<div class="card border-0 shadow-sm rounded-3">
    <div class="card-header bg-primary text-white">
        <div class="d-flex align-items-center">
            <a href="{{ route('wallet.index') }}" class="text-white me-3"><i class="fas fa-arrow-left"></i></a>
            <div>
                <h5 class="mb-0">Deposit via PayPal</h5>
                <small>Redirect to PayPal to complete your payment</small>
            </div>
        </div>
    </div>
    <div class="card-body">
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif
        <form method="POST" action="{{ route('wallet.deposit.paypal.create') }}">
            @csrf
            <div class="mb-3">
                <label class="form-label">Amount (USD)</label>
                <div class="input-group">
                    <span class="input-group-text">$</span>
                    <input type="number" min="1" step="0.01" class="form-control" name="amount" value="{{ old('amount') }}" placeholder="0.00" required />
                </div>
                <small class="text-muted">Minimum $1</small>
            </div>
            <div class="d-flex justify-content-end gap-2">
                <a href="{{ route('wallet.index') }}" class="btn btn-light">Cancel</a>
                <button type="submit" class="btn btn-primary">Continue to PayPal</button>
            </div>
        </form>
        <div class="mt-3 text-muted small">
            <div>Mode: <code>{{ setting('paypal_mode', env('PAYPAL_MODE', 'sandbox')) }}</code></div>
            <div>Client ID present: <code>{{ setting('paypal_id', env('PAYPAL_CLIENT_ID')) ? 'yes' : 'no' }}</code></div>
            <div>Client Secret present: <code>{{ setting('paypal_secret', env('PAYPAL_CLIENT_SECRET')) ? 'yes' : 'no' }}</code></div>
            <div>Environment Mode: <code>{{ env('PAYPAL_MODE', 'not set') }}</code></div>
            <div>Client ID from ENV: <code>{{ env('PAYPAL_CLIENT_ID') ? 'yes' : 'no' }}</code></div>
            <div>Client Secret from ENV: <code>{{ env('PAYPAL_CLIENT_SECRET') ? 'yes' : 'no' }}</code></div>
        </div>
    </div>
</div>

@push('scripts')
<!-- PayPal form handling is now done via standard HTML form submission -->
@endpush
@endsection


