@extends('front_end.pages.settings.layout')

@section('title', 'Recovery Codes - Socialink')

@section('settings_content')
<div class="card mb-4">
    <div class="card-header with-icon p-4">
        <div class="main-icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
        </div>
        <h5 class="mb-0 ms-2">Recovery Codes</h5>
    </div>
    <div class="card-body p-4">
        <div class="alert alert-warning mb-4">
            <i class="fas fa-exclamation-triangle me-2"></i>
            <strong>Important:</strong> Keep these recovery codes in a safe place. They can be used to recover access to your account if you lose your two-factor authentication device.
        </div>
        
        <p class="text-muted mb-4">Each code can only be used once. If you use a recovery code, you'll get a new set of codes when you set up two-factor authentication again.</p>
        
        <div class="row mb-4">
            <div class="col-md-8 mx-auto">
                <div class="bg-light p-4 rounded">
                    <div class="row">
                        @if(isset($recoveryCodes) && is_array($recoveryCodes))
                            @foreach($recoveryCodes as $code)
                                <div class="col-md-6 mb-2">
                                    <code class="user-select-all">{{ $code }}</code>
                                </div>
                            @endforeach
                        @else
                            <div class="col-12 text-center">
                                <p>No recovery codes available.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        
        <div class="d-flex justify-content-between">
            <a href="{{ route('settings.security', ['section' => 'two-factor']) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i> Back to Security Settings
            </a>
            
            <button class="btn btn-primary" onclick="window.print()">
                <i class="fas fa-print me-2"></i> Print Codes
            </button>
        </div>
    </div>
</div>
@endsection