<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="generator" content="Socialink">
    <title>Complete Your Profile - Socialink</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4895ef;
            --success-color: #4cc9f0;
        }

        body {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
        }
        

        
        .progress {
            height: 10px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
        }
        
        .progress-bar {
            background: linear-gradient(90deg, var(--primary-color), var(--accent-color));
            transition: width 0.5s ease-in-out;
        }
        
        .avatar-upload {
            position: relative;
            width: 180px;
            height: 180px;
            margin: 0 auto 1rem;
            transition: transform 0.3s ease;
        }
        
        .avatar-upload:hover {
            transform: scale(1.02);
        }
        
        .cover-upload {
            position: relative;
            height: 260px;
            background: linear-gradient(45deg, #e9ecef, #f8f9fa);
            border-radius: 20px;
            overflow: hidden;
            transition: transform 0.3s ease;
        }
        
        .cover-upload:hover {
            transform: translateY(-4px);
        }
        
        .upload-placeholder {
            position: relative;
            border: 3px dashed rgba(67, 97, 238, 0.3);
            border-radius: 50%;
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.9);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .upload-placeholder:hover {
            border-color: var(--primary-color);
            background: rgba(255, 255, 255, 1);
        }

        .upload-placeholder.drag-over {
            border-style: solid;
            border-color: var(--primary-color);
            background: rgba(72, 149, 239, 0.08);
        }
        
        .cover-placeholder {
            border-radius: 20px;
            background: linear-gradient(45deg, rgba(67, 97, 238, 0.05), rgba(72, 149, 239, 0.1));
        }
        
        .upload-icon {
            font-size: 2.5rem;
            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            transition: transform 0.3s ease;
        }

        .upload-placeholder-content {
            position: absolute;
            inset: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            pointer-events: none;
        }

        .avatar-preview {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            object-fit: cover;
            display: none;
        }

        .avatar-preview.show {
            display: block;
        }

        .cover-preview {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: none;
            border-radius: 20px;
        }

        .cover-preview.show {
            display: block;
        }
        
        .upload-placeholder:hover .upload-icon {
            transform: scale(1.05);
        }
        
        .upload-actions {
            position: absolute;
            bottom: 12px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 0.5rem;
            z-index: 2;
        }

        .upload-actions .btn {
            backdrop-filter: blur(8px);
        }

        .completion-card {
            border: none;
            border-radius: 25px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        
        .completion-card:hover {
            transform: translateY(-5px);
        }
        
        .form-control, .input-group-text {
            border-radius: 12px;
            border: 2px solid #e9ecef;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(67, 97, 238, 0.15);
        }
        
        .input-group .form-control {
            border-left: 0;
        }
        
        .input-group-text {
            background: white;
            border-right: 0;
            color: var(--primary-color);
        }
        
        .profile-section {
            opacity: 0;
            transform: translateY(20px);
            animation: fadeInUp 0.5s ease forwards;
        }
        
        .profile-section:nth-child(2) { animation-delay: 0.2s; }
        .profile-section:nth-child(3) { animation-delay: 0.4s; }
        .profile-section:nth-child(4) { animation-delay: 0.6s; }
        
        .profile-milestones {
            margin-bottom: 2rem;
        }

        .milestone-card {
            padding: 1rem 1.25rem;
            border-radius: 16px;
            border: 1px solid rgba(67, 97, 238, 0.12);
            background: rgba(255, 255, 255, 0.85);
            height: 100%;
            transition: all 0.3s ease;
        }

        .milestone-card.is-complete {
            border-color: rgba(67, 97, 238, 0.3);
            box-shadow: 0 12px 24px rgba(67, 97, 238, 0.08);
            background: linear-gradient(135deg, rgba(67, 97, 238, 0.1), rgba(72, 149, 239, 0.12));
        }

        .milestone-icon {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            margin-bottom: 0.75rem;
            background: rgba(67, 97, 238, 0.12);
            color: var(--primary-color);
        }

        .milestone-card.is-complete .milestone-icon {
            background: linear-gradient(135deg, rgba(67, 97, 238, 0.25), rgba(72, 149, 239, 0.25));
            color: #fff;
        }

        .milestone-title {
            font-weight: 600;
            margin-bottom: 0.25rem;
        }

        .milestone-status {
            display: inline-flex;
            align-items: center;
            gap: 0.35rem;
            font-size: 0.85rem;
        }

        .milestone-card.is-complete .milestone-status {
            color: #198754;
        }

        .btn-continue {
            padding: 1rem 3rem;
            font-weight: 600;
            border-radius: 50px;
            background: linear-gradient(45deg, var(--primary-color), var(--accent-color));
            border: none;
            transition: all 0.3s ease;
        }
        
        .btn-continue:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }
        
        .skip-link {
            color: #6c757d;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .skip-link:hover {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .section-title {
            font-weight: 700;
            color: #2d3748;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .section-title i {
            color: var(--primary-color);
        }
        
        @keyframes fadeInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>

<body>
    @php use Illuminate\Support\Str; @endphp
    @php
        $avatarRemoved = old('remove_avatar') === '1';
        $coverRemoved = old('remove_cover') === '1';
        $avatarUrl = getMedia($avatarRemoved ? null : $user->avatar, 'avatar');
        $coverUrl = getMedia($coverRemoved ? null : $user->cover, 'cover');
        $remainingSteps = max($sectionsRemaining, 0);
    @endphp

    <div class="container">
        <!-- Header and Progress -->
        <div class="text-center mb-5 animate__animated animate__fadeIn">
            <h1 class="display-5 fw-bold mb-3">Let's Complete Your Profile</h1>
            <p class="text-muted lead mb-4">Share a bit about yourself to help others connect with you</p>
            <div class="progress mb-3">
                <div class="progress-bar" id="profileProgressBar" role="progressbar" style="width: {{ $progress }}%" aria-valuenow="{{ $progress }}" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div class="d-flex justify-content-between px-2">
                <span class="text-muted">Profile Strength: <strong id="profileProgressLabel">{{ $progress }}%</strong></span>
                <span class="text-primary" id="profileProgressRemaining"><i class="fas fa-tasks me-1"></i>{{ $remainingSteps }} {{ Str::plural('step', $remainingSteps) }} remaining</span>
            </div>
        </div>

        <!-- Profile Completion Form -->
        <div class="card completion-card">
            <div class="card-body p-4 p-lg-5">
                <div class="profile-milestones row g-3">
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="milestone-card" data-check="avatar">
                            <div class="milestone-icon"><i class="fas fa-user-circle"></i></div>
                            <div class="milestone-title">Profile Photo</div>
                            <div class="milestone-status"><i class="fas fa-circle me-1"></i><span class="milestone-status-text">Pending</span></div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="milestone-card" data-check="cover">
                            <div class="milestone-icon"><i class="fas fa-image"></i></div>
                            <div class="milestone-title">Cover Image</div>
                            <div class="milestone-status"><i class="fas fa-circle me-1"></i><span class="milestone-status-text">Pending</span></div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="milestone-card" data-check="bio">
                            <div class="milestone-icon"><i class="fas fa-feather"></i></div>
                            <div class="milestone-title">Bio</div>
                            <div class="milestone-status"><i class="fas fa-circle me-1"></i><span class="milestone-status-text">Pending</span></div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="milestone-card" data-check="location">
                            <div class="milestone-icon"><i class="fas fa-map-marker-alt"></i></div>
                            <div class="milestone-title">Location</div>
                            <div class="milestone-status"><i class="fas fa-circle me-1"></i><span class="milestone-status-text">Pending</span></div>
                        </div>
                    </div>
                </div>

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if (session('info'))
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="fas fa-info-circle me-2"></i>{{ session('info') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <h6 class="mb-2"><i class="fas fa-exclamation-triangle me-2"></i>We found a few issues:</h6>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form class="profile-form" method="POST" action="{{ route('profile.complete') }}" enctype="multipart/form-data">
                    @csrf
                    <!-- Profile Picture Section -->
                    <div class="profile-section mb-5">
                        <h3 class="section-title"><i class="fas fa-user-circle"></i> Profile Picture</h3>
                        <div class="avatar-upload">
                            <div class="upload-placeholder" data-bs-toggle="tooltip" data-bs-placement="top" title="Click to upload profile picture" id="avatarDropzone">
                                <img src="{{ $avatarUrl }}" alt="Current avatar" class="avatar-preview {{ ($user->avatar && !$avatarRemoved) ? 'show' : '' }}" id="avatarPreview">
                                <div class="upload-placeholder-content {{ ($user->avatar && !$avatarRemoved) ? 'd-none' : '' }}" id="avatarPlaceholderContent">
                                    <i class="fas fa-user-plus upload-icon"></i>
                                </div>
                                <div class="upload-actions">
                                    <button type="button" class="btn btn-light btn-sm" id="avatarChangeBtn"><i class="fas fa-camera me-1"></i>Change</button>
                                    <button type="button" class="btn btn-outline-danger btn-sm {{ ($user->avatar && !$avatarRemoved) ? '' : 'd-none' }}" id="avatarRemoveBtn"><i class="fas fa-trash-alt me-1"></i>Remove</button>
                                </div>
                            </div>
                            <input type="file" name="avatar" class="d-none" id="avatarUpload" accept="image/*">
                            <input type="hidden" name="remove_avatar" value="{{ old('remove_avatar', 0) }}" id="removeAvatarInput">
                        </div>
                        <p class="text-muted text-center small mt-3">
                            <i class="fas fa-info-circle me-1"></i>
                            Recommended: Square image, at least 400x400px
                        </p>
                    </div>

                    <!-- Cover Photo Section -->
                    <div class="profile-section mb-5">
                        <h3 class="section-title"><i class="fas fa-image"></i> Cover Photo</h3>
                        <div class="cover-upload" data-bs-toggle="tooltip" data-bs-placement="top" title="Click to upload cover photo" id="coverDropzone">
                            <div class="upload-placeholder cover-placeholder h-100">
                                <img src="{{ $coverUrl }}" alt="Current cover" class="cover-preview {{ ($user->cover && !$coverRemoved) ? 'show' : '' }}" id="coverPreview">
                                <div class="upload-placeholder-content {{ ($user->cover && !$coverRemoved) ? 'd-none' : '' }}" id="coverPlaceholderContent">
                                    <i class="fas fa-cloud-upload-alt upload-icon"></i>
                                </div>
                            </div>
                            <input type="file" name="cover" class="d-none" id="coverUpload" accept="image/*">
                            <input type="hidden" name="remove_cover" value="{{ old('remove_cover', 0) }}" id="removeCoverInput">
                            <div class="upload-actions" style="bottom: 18px;">
                                <button type="button" class="btn btn-light btn-sm" id="coverChangeBtn"><i class="fas fa-camera me-1"></i>Change</button>
                                <button type="button" class="btn btn-outline-danger btn-sm {{ ($user->cover && !$coverRemoved) ? '' : 'd-none' }}" id="coverRemoveBtn"><i class="fas fa-trash-alt me-1"></i>Remove</button>
                            </div>
                        </div>
                        <p class="text-muted small mt-3">
                            <i class="fas fa-info-circle me-1"></i>
                            Recommended: 1500x500px, max 5MB
                        </p>
                    </div>

                    <!-- Basic Information Section -->
                    <div class="profile-section mb-5">
                        <h3 class="section-title"><i class="fas fa-info-circle"></i> Basic Information</h3>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="name" class="form-control" id="displayName" placeholder="Display Name" value="{{ old('name', $user->name) }}">
                                    <label for="displayName">Display Name</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-floating mb-3">
                                    <textarea class="form-control" name="bio" id="bio" style="height: 100px" placeholder="Tell us about yourself" maxlength="160">{{ old('bio', $user->bio) }}</textarea>
                                    <label for="bio">Bio</label>
                                    <div class="form-text text-end"><span id="bioCount">{{ Str::length(old('bio', $user->bio)) }}</span>/160 characters</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="location" class="form-control" id="location" placeholder="Location" value="{{ old('location', $user->address) }}">
                                    <label for="location">Location</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="d-flex justify-content-between align-items-center mt-5">
                        <a href="{{ route('skip.profile.completion') }}" class="skip-link btn btn-link">Complete Later</a>
                        <button type="submit" class="btn btn-continue">
                            <i class="fas fa-check me-2"></i>Complete Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.forEach(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));

            const avatarInput = document.getElementById('avatarUpload');
            const avatarPreview = document.getElementById('avatarPreview');
            const avatarPlaceholder = document.getElementById('avatarPlaceholderContent');
            const avatarDropzone = document.getElementById('avatarDropzone');
            const avatarChangeBtn = document.getElementById('avatarChangeBtn');
            const avatarRemoveBtn = document.getElementById('avatarRemoveBtn');
            const removeAvatarInput = document.getElementById('removeAvatarInput');

            const coverInput = document.getElementById('coverUpload');
            const coverPreview = document.getElementById('coverPreview');
            const coverPlaceholder = document.getElementById('coverPlaceholderContent');
            const coverDropzone = document.getElementById('coverDropzone');
            const coverChangeBtn = document.getElementById('coverChangeBtn');
            const coverRemoveBtn = document.getElementById('coverRemoveBtn');
            const removeCoverInput = document.getElementById('removeCoverInput');

            const bioInput = document.getElementById('bio');
            const bioCount = document.getElementById('bioCount');
            const locationInput = document.getElementById('location');
            const displayNameInput = document.getElementById('displayName');

            const progressBar = document.getElementById('profileProgressBar');
            const progressLabel = document.getElementById('profileProgressLabel');
            const progressRemaining = document.getElementById('profileProgressRemaining');
            const milestoneCards = document.querySelectorAll('.milestone-card');

            const updatePreview = (input, preview, placeholder) => {
                if (!input.files || !input.files[0]) {
                    preview.classList.remove('show');
                    placeholder?.classList.remove('d-none');
                    return false;
                }

                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target?.result;
                    preview.classList.add('show');
                    placeholder?.classList.add('d-none');
                };
                reader.readAsDataURL(input.files[0]);
                return true;
            };

            const bindDropzone = (dropzone, input) => {
                if (!dropzone || !input) {
                    return;
                }

                dropzone.addEventListener('click', () => input.click());
                dropzone.addEventListener('dragover', event => {
                    event.preventDefault();
                    dropzone.classList.add('drag-over');
                });
                dropzone.addEventListener('dragleave', () => dropzone.classList.remove('drag-over'));
                dropzone.addEventListener('drop', event => {
                    event.preventDefault();
                    dropzone.classList.remove('drag-over');
                    if (event.dataTransfer?.files?.length) {
                        input.files = event.dataTransfer.files;
                        input.dispatchEvent(new Event('change'));
                    }
                });
            };

            const refreshMilestones = (state) => {
                milestoneCards.forEach(card => {
                    const key = card.getAttribute('data-check');
                    const complete = state[key];
                    card.classList.toggle('is-complete', complete);
                    const statusText = card.querySelector('.milestone-status-text');
                    const statusIcon = card.querySelector('.milestone-status i');
                    if (statusText) {
                        statusText.textContent = complete ? 'Complete' : 'Pending';
                    }
                    if (statusIcon) {
                        statusIcon.className = complete ? 'fas fa-check-circle' : 'fas fa-circle';
                    }
                });
            };

            const updateProgress = () => {
                const state = {
                    avatar: avatarPreview?.classList.contains('show') && removeAvatarInput?.value !== '1',
                    cover: coverPreview?.classList.contains('show') && removeCoverInput?.value !== '1',
                    bio: !!bioInput?.value.trim(),
                    location: !!locationInput?.value.trim(),
                };

                const completed = Object.values(state).filter(Boolean).length;
                const total = Object.keys(state).length;
                const percent = Math.round((completed / total) * 100);
                const remaining = Math.max(total - completed, 0);

                if (progressBar) {
                    progressBar.style.width = `${percent}%`;
                    progressBar.setAttribute('aria-valuenow', `${percent}`);
                }
                if (progressLabel) {
                    progressLabel.textContent = `${percent}%`;
                }
                if (progressRemaining) {
                    progressRemaining.innerHTML = `<i class="fas fa-tasks me-1"></i>${remaining} ${remaining === 1 ? 'step' : 'steps'} remaining`;
                }

                refreshMilestones(state);
            };

            avatarInput?.addEventListener('change', () => {
                const hasPreview = updatePreview(avatarInput, avatarPreview, avatarPlaceholder);
                if (hasPreview) {
                    removeAvatarInput.value = '0';
                    avatarRemoveBtn?.classList.remove('d-none');
                }
                updateProgress();
            });

            coverInput?.addEventListener('change', () => {
                const hasPreview = updatePreview(coverInput, coverPreview, coverPlaceholder);
                if (hasPreview) {
                    removeCoverInput.value = '0';
                    coverRemoveBtn?.classList.remove('d-none');
                }
                updateProgress();
            });

            bindDropzone(avatarDropzone, avatarInput);
            bindDropzone(coverDropzone, coverInput);

            avatarChangeBtn?.addEventListener('click', () => avatarInput?.click());
            coverChangeBtn?.addEventListener('click', () => coverInput?.click());

            avatarRemoveBtn?.addEventListener('click', () => {
                if (!avatarPreview) {
                    return;
                }
                avatarPreview.classList.remove('show');
                avatarPlaceholder?.classList.remove('d-none');
                avatarInput.value = '';
                removeAvatarInput.value = '1';
                avatarRemoveBtn.classList.add('d-none');
                updateProgress();
            });

            coverRemoveBtn?.addEventListener('click', () => {
                if (!coverPreview) {
                    return;
                }
                coverPreview.classList.remove('show');
                coverPlaceholder?.classList.remove('d-none');
                coverInput.value = '';
                removeCoverInput.value = '1';
                coverRemoveBtn.classList.add('d-none');
                updateProgress();
            });

            if (bioInput && bioCount) {
                const updateBioCount = () => {
                    bioCount.textContent = bioInput.value.length;
                    updateProgress();
                };
                bioInput.addEventListener('input', updateBioCount);
                updateBioCount();
            }

            locationInput?.addEventListener('input', updateProgress);
            displayNameInput?.addEventListener('input', updateProgress);

            updateProgress();
        });
    </script>
