@extends('front_end.layouts.home')

@section('title', 'Newsfeed - SocialLink')
@php
    $boxAvatar = Auth::user()->avatar;
@endphp

@push('styles')
    @include('front_end.layouts.newsfeed_styles')
@endpush

@section('content')
<div class="newsfeed-container">
    <!-- Story Section START -->
    <div class="stories-container">
        <!-- Create Story Card -->
        <div class="create-story-card">
            <div class="create-story-content">
                <a href="{{ url('create_story') }}" class="create-story-btn">
                    <i class="fa-solid fa-plus"></i>
                </a>
                <p class="create-story-text">Share Your Story</p>
            </div>
        </div>

        <!-- Stories -->
        <div id="stories" class="storiesWrapper stories-square stories user-icon carousel scroll-enable"></div>
    </div>
    <!-- Story Section END -->

    @php
        $postType = 'post';
    @endphp
    @include('front_end.layouts.newsfeed_box')

    <!-- Welcome Section START -->
    <div class="card welcome_card">
        <div class="d-flex align-items-center">
            <div class="greet_icon">
                <i class="bi-sun time_icon"></i>
            </div>
            <div class="greet_content ms-3">
                <h5 id="greetHeading">Hello, Admin User!</h5>
                <p id="greetMessage">Hope you're having a great day.</p>
            </div>
        </div>
    </div>
    <!-- Welcome Section END -->

    <!-- Post Listing START -->
    <div id="postholder">
        <!-- Posts will be loaded here dynamically -->
    </div>
    <!-- Post Listing END -->
</div>

@push('scripts')
    @include('front_end.layouts.newsfeed_scripts')
@endpush

@section('extra-js')
    <script>
        $(document).ready(function() {
            loadNewsFeed();
        });
        
        function setGreeting() {
            const currentHour = new Date().getHours();
            const greetHeading = document.getElementById('greetHeading');
            const greetMessage = document.getElementById('greetMessage');
            const timeIcon = document.querySelector('.time_icon');

            if (currentHour < 12) {
                greetHeading.innerText = "Good Morning, Admin!";
                greetMessage.innerText = "Rise and shine! Wishing you a productive day ahead.";
                timeIcon.className = "bi bi-brightness-high time_icon";
            } else if (currentHour < 18) {
                greetHeading.innerText = "Good Afternoon, Admin!";
                greetMessage.innerText = "Keep going strong! You're doing great.";
                timeIcon.className = "bi bi-sun time_icon";
            } else {
                greetHeading.innerText = "Good Evening, Admin!";
                greetMessage.innerText = "Time to relax and unwind. Have a peaceful evening!";
                timeIcon.className = "bi bi-moon time_icon";
            }
        }

        document.addEventListener("DOMContentLoaded", setGreeting);

        // Dark mode toggle
        document.getElementById('darkModeSwitch').addEventListener('click', function () {
            document.body.classList.toggle('dark-mode');
            localStorage.setItem('darkMode', document.body.classList.contains('dark-mode'));
        });

        // Check for saved dark mode preference
        if (localStorage.getItem('darkMode') === 'true') {
            document.body.classList.add('dark-mode');
        }

        // Mark all notifications as read
        document.getElementById('markAllRead').addEventListener('click', function () {
            const notifications = document.querySelectorAll('#notificationList .badge-unread');
            notifications.forEach(notification => {
                notification.classList.remove('badge-unread');
            });
            document.querySelector('#notifDropdown .badge').style.display = 'none';
        });

        // Simple notification counter
        let messageCount = 0;
        const messageCounter = document.getElementById('message-counter');

        // Function to update message counter
        function updateMessageCounter(count) {
            messageCount = count;
            if (messageCount > 0) {
                messageCounter.textContent = messageCount;
                messageCounter.classList.remove('d-none');
            } else {
                messageCounter.classList.add('d-none');
            }
        }

        // Example of adding a new notification (you would typically do this with WebSocket)
        function addNotification(content) {
            const notificationList = document.getElementById('notificationList');
            const notification = document.createElement('li');
            notification.className = 'list-group-item list-group-item-action rounded badge-unread d-flex border-0 mb-1 p-3';
            notification.innerHTML = content;
            notificationList.prepend(notification);
        }
    </script>
@endsection

@endsection