@extends('front_end.layouts.app')

@section('title', 'Saved Products | Marketplace')

@section('content')
<div class="container py-4">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            @include('front_end.pages.marketplace.partials.sidebar')
        </div>
        
        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="card shadow-sm">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Saved Products</h5>
                </div>
                <div class="card-body">
                    @if($savedProducts->count() > 0)
                        <div class="row">
                            @foreach($savedProducts as $saved)
                                @php $product = $saved->product; @endphp
                                <div class="col-md-4 mb-4">
                                    <div class="card h-100 product-card">
                                        <div class="position-relative">
                                            @if($product->media->isNotEmpty())
                                                <img src="{{ asset('storage/' . $product->media->first()->file_path) }}" class="card-img-top product-img" alt="{{ $product->name }}">
                                            @else
                                                <img src="{{ asset('assets/images/placeholder.jpg') }}" class="card-img-top product-img" alt="No Image">
                                            @endif
                                            
                                            <button class="btn btn-sm position-absolute top-0 end-0 m-2 bg-white rounded-circle p-2 unsave-product" data-id="{{ $product->id }}" data-bs-toggle="tooltip" title="Remove from saved">
                                                <i class="fas fa-heart text-danger"></i>
                                            </button>
                                        </div>
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <h5 class="card-title mb-0">{{ $product->name }}</h5>
                                                <span class="badge {{ $product->stock_quantity > 0 ? 'bg-success' : 'bg-danger' }}">
                                                    {{ $product->stock_quantity > 0 ? 'In Stock' : 'Out of Stock' }}
                                                </span>
                                            </div>
                                            
                                            <p class="text-muted small mb-2">
                                                <i class="fas fa-tag me-1"></i> {{ $product->category->name ?? 'Uncategorized' }}
                                            </p>
                                            
                                            <p class="card-text text-muted small">{{ Str::limit($product->description, 50) }}</p>
                                            
                                            @if($product->discount_percentage > 0)
                                                <div class="d-flex align-items-center gap-2 mb-2">
                                                    <span class="text-primary fw-bold">{{ $product->currency }} {{ number_format($product->sale_price, 2) }}</span>
                                                    <span class="text-muted text-decoration-line-through">{{ $product->currency }} {{ number_format($product->price, 2) }}</span>
                                                    <span class="badge bg-danger">{{ $product->discount_percentage }}% OFF</span>
                                                </div>
                                            @else
                                                <div class="mb-2">
                                                    <span class="text-primary fw-bold">{{ $product->currency }} {{ number_format($product->price, 2) }}</span>
                                                </div>
                                            @endif
                                            
                                            <div class="d-flex align-items-center text-muted small mb-2">
                                                <i class="fas fa-store me-1"></i> 
                                                {{ $product->store->name ?? 'By ' . $product->user->name }}
                                            </div>
                                            
                                            <div class="d-flex align-items-center text-muted small">
                                                <i class="fas fa-map-marker-alt me-1"></i> {{ $product->location ?? 'Location not specified' }}
                                            </div>
                                        </div>
                                        <div class="card-footer bg-white">
                                            <div class="d-grid">
                                                <a href="{{ route('marketplace.product.detail', $product->id) }}" class="btn btn-primary">View Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-4">
                            {{ $savedProducts->links('pagination::bootstrap-5') }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <img src="{{ asset('assets/images/empty-wishlist.svg') }}" alt="No saved products" class="mb-3" style="max-width: 150px;">
                            <h4>No Saved Products</h4>
                            <p class="text-muted">You haven't saved any products yet. Browse the marketplace and save products you're interested in.</p>
                            <a href="{{ route('marketplace.index') }}" class="btn btn-primary">
                                <i class="fas fa-store"></i> Browse Marketplace
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.unsave-product').on('click', function() {
            const productId = $(this).data('id');
            const card = $(this).closest('.col-md-4');
            
            $.ajax({
                url: '{{ route("api.marketplace.toggle-save") }}/' + productId,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    // Fade out and remove the card
                    card.fadeOut(300, function() {
                        $(this).remove();
                        
                        // Check if there are no more products
                        if ($('.product-card').length === 0) {
                            location.reload(); // Reload to show empty state
                        }
                    });
                    
                    // Show notification
                    toastr.success('Product removed from saved items');
                },
                error: function(xhr) {
                    toastr.error('Error removing product from saved items');
                }
            });
        });
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
    });
</script>
@endpush

@push('styles')
<style>
    .product-img {
        height: 180px;
        object-fit: cover;
    }
    
    .product-card {
        transition: transform 0.3s;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
</style>
@endpush 