<div class="card shadow-sm">
    <div class="card-header bg-white">
        <h5 class="mb-0">Marketplace</h5>
    </div>
    <div class="list-group list-group-flush">
        <a href="{{ route('marketplace.index') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.index') ? 'active' : '' }}">
            <i class="fas fa-store me-2"></i> Browse Products
        </a>
        <a href="{{ route('marketplace.my-listings') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.my-listings') ? 'active' : '' }}">
            <i class="fas fa-box me-2"></i> My Listings
        </a>
        <a href="{{ route('marketplace.saved') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.saved') ? 'active' : '' }}">
            <i class="fas fa-bookmark me-2"></i> Saved Products
        </a>
        <a href="{{ route('marketplace.orders') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.orders*') ? 'active' : '' }}">
            <i class="fas fa-shopping-bag me-2"></i> My Orders
        </a>
        @if(auth()->user()->store)
            <a href="{{ route('marketplace.store.dashboard') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.store*') ? 'active' : '' }}">
                <i class="fas fa-chart-line me-2"></i> Store Dashboard
            </a>
        @else
            <a href="{{ route('marketplace.store.create') }}" class="list-group-item list-group-item-action {{ Route::is('marketplace.store.create') ? 'active' : '' }}">
                <i class="fas fa-plus-circle me-2"></i> Create a Store
            </a>
        @endif
    </div>
</div>

<div class="card shadow-sm mt-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Categories</h5>
    </div>
    <div class="list-group list-group-flush">
        @foreach($categories ?? [] as $category)
            <a href="{{ route('marketplace.category', $category->id) }}" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                {{ $category->name }}
                <span class="badge bg-primary rounded-pill">{{ $category->products_count ?? 0 }}</span>
            </a>
        @endforeach
    </div>
</div>

@if(isset($filters) && $filters)
<div class="card shadow-sm mt-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Filters</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('marketplace.index') }}" method="GET" id="filter-form">
            <!-- Price Range -->
            <div class="mb-3">
                <label class="form-label">Price Range</label>
                <div class="d-flex align-items-center">
                    <input type="number" name="min_price" class="form-control form-control-sm" placeholder="Min" value="{{ request('min_price') }}">
                    <span class="mx-2">-</span>
                    <input type="number" name="max_price" class="form-control form-control-sm" placeholder="Max" value="{{ request('max_price') }}">
                </div>
            </div>
            
            <!-- Condition -->
            <div class="mb-3">
                <label class="form-label">Condition</label>
                <div class="form-check">
                    <input class="form-check-input filter-check" type="checkbox" name="condition[]" value="new" id="condition-new" {{ in_array('new', request('condition', [])) ? 'checked' : '' }}>
                    <label class="form-check-label" for="condition-new">New</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input filter-check" type="checkbox" name="condition[]" value="used" id="condition-used" {{ in_array('used', request('condition', [])) ? 'checked' : '' }}>
                    <label class="form-check-label" for="condition-used">Used</label>
                </div>
            </div>
            
            <!-- Location -->
            <div class="mb-3">
                <label for="location" class="form-label">Location</label>
                <input type="text" class="form-control form-control-sm" id="location" name="location" placeholder="Enter location" value="{{ request('location') }}">
            </div>
            
            <button type="submit" class="btn btn-primary btn-sm w-100">Apply Filters</button>
            <a href="{{ route('marketplace.index') }}" class="btn btn-outline-secondary btn-sm w-100 mt-2">Clear Filters</a>
        </form>
    </div>
</div>
@endif 