@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'List an Item')

@section('left_sidebar')
@include('front_end.pages.marketplace.marketplace_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('marketplace.index') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">List an Item</h4>
                                    <p class="mb-0 text-white">Add your product to the marketplace</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <form id="createProductForm" enctype="multipart/form-data">
            <div class="row">
                <!-- Main Form Column -->
                <div class="col-lg-8">
                    <!-- Basic Information Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Basic Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="name" class="form-label">Product Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" required>
                                <div class="form-text">Enter a descriptive title for your product</div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="category_id" class="form-label">Category <span class="text-danger">*</span></label>
                                    <select class="form-select" id="category_id" name="category_id" required>
                                        <option value="">Select Category</option>
                                        @foreach($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="type" class="form-label">Condition <span class="text-danger">*</span></label>
                                    <select class="form-select" id="type" name="type" required>
                                        <option value="">Select Condition</option>
                                        <option value="new">New</option>
                                        <option value="like_new">Like New</option>
                                        <option value="used">Used</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="6"></textarea>
                                <div class="form-text">Describe your product in detail, including features and condition</div>
                            </div>
                        </div>
                    </div>

                    <!-- Price & Location Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Price & Location</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="price" class="form-label">Price <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">$</span>
                                        <input type="number" class="form-control" id="price" name="price" min="0" step="0.01" required>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="currency" class="form-label">Currency <span class="text-danger">*</span></label>
                                    <select class="form-select" id="currency" name="currency" required>
                                        @foreach($currencies as $code => $name)
                                            <option value="{{ $code }}">{{ $name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="location" class="form-label">Location <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="location" name="location" required>
                                <div class="form-text">Enter the city or neighborhood where this item is available</div>
                            </div>

                            <div class="mb-3">
                                <label for="units" class="form-label">Quantity</label>
                                <input type="number" class="form-control" id="units" name="units" min="1" value="1">
                                <div class="form-text">Number of items available for sale</div>
                            </div>
                        </div>
                    </div>

                    <!-- Product Images Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Product Images</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Upload Images <span class="text-danger">*</span></label>
                                <div class="input-group mb-3">
                                    <input type="file" class="form-control" id="productImages" name="productImages[]" multiple accept="image/*" data-preview="imagePreview">
                                    <button class="btn btn-outline-secondary" type="button" id="uploadImagesBtn">
                                        <i class="fas fa-upload me-2"></i>Add
                                    </button>
                                </div>
                                <div class="form-text">
                                    You can upload up to 5 images. First image will be the main image. 
                                    Max size: 2MB per image. Allowed formats: JPG, PNG, GIF.
                                    <span class="fw-bold ms-2">Remaining: <span id="remainingImages">5</span></span>
                                </div>
                            </div>

                            <div class="image-preview-grid" id="imagePreviewContainer">
                                <!-- Image previews will be added here -->
                            </div>
                        </div>
                    </div>

                    <!-- Delivery Options Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Delivery Options</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" id="deliveryShipping" name="delivery_options[]" value="shipping">
                                    <label class="form-check-label" for="deliveryShipping">
                                        Shipping Available
                                    </label>
                                </div>
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" id="deliveryPickup" name="delivery_options[]" value="pickup" checked>
                                    <label class="form-check-label" for="deliveryPickup">
                                        Local Pickup
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="deliveryFree" name="delivery_options[]" value="free_delivery">
                                    <label class="form-check-label" for="deliveryFree">
                                        Free Delivery
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar Column -->
                <div class="col-lg-4">
                    <!-- Submission Card -->
                    <div class="card border-0 shadow-sm mb-4 sticky-top" style="top: 20px;">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Submit Listing</h5>
                        </div>
                        <div class="card-body">
                            <p>Your listing will be reviewed before being published. This usually takes less than 24 hours.</p>
                            
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="promoteListing" name="promote_listing">
                                    <label class="form-check-label" for="promoteListing">
                                        Promote Listing (Additional Fee)
                                    </label>
                                </div>
                                <div class="form-text">Featured listings appear at the top of search results</div>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-check-circle me-2"></i>Submit Listing
                                </button>
                                <button type="button" class="btn btn-outline-secondary" id="saveAsDraft">
                                    <i class="fas fa-save me-2"></i>Save as Draft
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Tips Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-light py-3">
                            <h5 class="card-title mb-0">Listing Tips</h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-unstyled mb-0">
                                <li class="mb-3">
                                    <div class="d-flex">
                                        <span class="text-primary me-3">
                                            <i class="fas fa-check-circle"></i>
                                        </span>
                                        <span>Use clear, well-lit photos</span>
                                    </div>
                                </li>
                                <li class="mb-3">
                                    <div class="d-flex">
                                        <span class="text-primary me-3">
                                            <i class="fas fa-check-circle"></i>
                                        </span>
                                        <span>Write detailed descriptions</span>
                                    </div>
                                </li>
                                <li class="mb-3">
                                    <div class="d-flex">
                                        <span class="text-primary me-3">
                                            <i class="fas fa-check-circle"></i>
                                        </span>
                                        <span>Set a competitive price</span>
                                    </div>
                                </li>
                                <li>
                                    <div class="d-flex">
                                        <span class="text-primary me-3">
                                            <i class="fas fa-check-circle"></i>
                                        </span>
                                        <span>Respond quickly to inquiries</span>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

@push('styles')
<style>
.image-preview-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
    gap: 15px;
    margin-top: 15px;
}

.image-preview-container {
    position: relative;
    border-radius: 6px;
    overflow: hidden;
}

.image-preview-container img {
    width: 100%;
    height: 120px;
    object-fit: cover;
}

.image-preview-placeholder {
    border: 2px dashed #dee2e6;
    height: 120px;
    border-radius: 6px;
}
</style>
@endpush

@push('scripts')
<script src="{{ asset('assets/js/ckeditor.js') }}"></script>
@if(isset($jquery_ui) && $jquery_ui)
<script src="{{ asset('assets/js/jquery-ui.min.js') }}"></script>
@endif
<script src="{{ asset('assets/js/marketplace-create.js') }}"></script>
@endpush

@endsection