@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Job Detail')

@section('left_sidebar')
@include('front_end.pages.jobs.job_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/jobs') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Job Details</h4>
                                    <p class="mb-0 text-white">View complete job information and apply</p>
                                </div>
                            </div>
                            <div class="d-flex gap-2">
                                <button class="btn btn-light" id="shareJob">
                                    <i class="fas fa-share-alt me-2"></i>Share
                                </button>
                                <button class="btn btn-light" id="saveJob">
                                    <i class="fas fa-bookmark me-2"></i>Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Job Header -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <img src="" alt="Company Logo" id="companyLogo" class="rounded-3 me-4" style="width: 100px; height: 100px; object-fit: cover;">
                            <div>
                                <h2 class="mb-1" id="jobTitle"></h2>
                                <p class="text-primary mb-2" id="companyName"></p>
                                <div class="d-flex flex-wrap gap-2" id="jobMeta">
                                    <!-- Job meta badges will be inserted here -->
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="d-flex gap-2">
                            <button class="btn btn-primary" id="applyNow">
                                <i class="fas fa-paper-plane me-2"></i>Apply Now
                            </button>
                            <button class="btn btn-outline-primary" id="quickApply">
                                <i class="fas fa-bolt me-2"></i>Quick Apply
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Job Details Sections -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Job Description</h4>
                        <div id="jobDescription" class="formatted-content mb-4">
                            <!-- Job description will be inserted here -->
                        </div>

                        <h5 class="mb-3">Key Responsibilities</h5>
                        <ul class="list-unstyled" id="responsibilities">
                            <!-- Responsibilities will be inserted here -->
                        </ul>

                        <h5 class="mb-3">Requirements</h5>
                        <ul class="list-unstyled" id="requirements">
                            <!-- Requirements will be inserted here -->
                        </ul>

                        <h5 class="mb-3">Required Skills</h5>
                        <div class="d-flex flex-wrap gap-2 mb-4" id="skills">
                            <!-- Skills will be inserted here -->
                        </div>

                        <h5 class="mb-3">Benefits</h5>
                        <div class="row g-3 mb-4" id="benefits">
                            <!-- Benefits will be inserted here -->
                        </div>
                    </div>
                </div>

                <!-- Application Process -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">How to Apply</h4>
                        <div id="applicationProcess">
                            <!-- Application process will be inserted here -->
                        </div>
                    </div>
                </div>

                <!-- Similar Jobs -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Similar Jobs</h4>
                        <div id="similarJobs">
                            <!-- Similar jobs will be inserted here -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Job Overview -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Job Overview</h4>
                        <ul class="list-unstyled">
                            <li class="mb-3">
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-calendar-alt"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Date Posted</p>
                                        <p class="mb-0 fw-medium" id="datePosted"></p>
                                    </div>
                                </div>
                            </li>
                            <li class="mb-3">
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Location</p>
                                        <p class="mb-0 fw-medium" id="location"></p>
                                    </div>
                                </div>
                            </li>
                            <li class="mb-3">
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-briefcase"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Job Type</p>
                                        <p class="mb-0 fw-medium" id="jobType"></p>
                                    </div>
                                </div>
                            </li>
                            <li class="mb-3">
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-dollar-sign"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Salary Range</p>
                                        <p class="mb-0 fw-medium" id="salaryRange"></p>
                                    </div>
                                </div>
                            </li>
                            <li class="mb-3">
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-user-graduate"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Experience</p>
                                        <p class="mb-0 fw-medium" id="experience"></p>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="d-flex">
                                    <span class="icon-circle bg-primary bg-opacity-10 text-primary me-3">
                                        <i class="fas fa-clock"></i>
                                    </span>
                                    <div>
                                        <p class="text-muted mb-1">Application Deadline</p>
                                        <p class="mb-0 fw-medium" id="deadline"></p>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Company Info -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Company Information</h4>
                        <div class="text-center mb-4">
                            <img id="companyLogoLarge" class="rounded-3 mb-3" style="width: 120px; height: 120px; object-fit: cover;">
                            <h5 id="companyNameLarge" class="mb-2"></h5>
                            <p class="text-muted mb-3" id="companyLocation"></p>
                            <a href="#" class="btn btn-outline-primary btn-sm" id="companyWebsite" target="_blank">
                                <i class="fas fa-globe me-2"></i>Visit Website
                            </a>
                        </div>
                        <div id="companyDescription">
                            <!-- Company description will be inserted here -->
                        </div>
                    </div>
                </div>

                <!-- Application Stats -->
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Application Statistics</h4>
                        <ul class="list-unstyled">
                            <li class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Total Applicants</span>
                                    <span class="badge bg-primary" id="totalApplicants">0</span>
                                </div>
                            </li>
                            <li class="mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Views</span>
                                    <span class="badge bg-info" id="totalViews">0</span>
                                </div>
                            </li>
                            <li>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Time Left to Apply</span>
                                    <span class="badge bg-warning" id="timeLeft"></span>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Apply Job Modal -->
<div class="modal fade" id="applyJobModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Apply for Position</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="jobApplicationForm">
                    <input type="hidden" id="jobId">
                    
                    <!-- Personal Information -->
                    <div class="mb-4">
                        <h6 class="mb-3">Personal Information</h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" name="phone" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">LinkedIn Profile</label>
                                <input type="url" class="form-control" name="linkedin_url">
                            </div>
                        </div>
                    </div>

                    <!-- Professional Information -->
                    <div class="mb-4">
                        <h6 class="mb-3">Professional Information</h6>
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Resume/CV <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="cv_file" accept=".pdf,.doc,.docx" required>
                                <small class="text-muted">Max file size: 2MB. Supported formats: PDF, DOC, DOCX</small>
                            </div>
                            <div class="col-12">
                                <label class="form-label">Cover Letter</label>
                                <textarea class="form-control" name="cover_letter" rows="4"></textarea>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Portfolio URL</label>
                                <input type="url" class="form-control" name="portfolio_url">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Expected Salary</label>
                                <input type="number" class="form-control" name="expected_salary">
                            </div>
                        </div>
                    </div>

                    <!-- Additional Information -->
                    <div id="screeningQuestions">
                        <!-- Screening questions will be inserted here -->
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="submitApplication">Submit Application</button>
            </div>
        </div>
    </div>
</div>

<!-- Share Job Modal -->
<div class="modal fade" id="shareJobModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Share Job</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="d-flex justify-content-center gap-3">
                    <button class="btn btn-outline-primary share-btn" data-platform="facebook">
                        <i class="fab fa-facebook-f fa-lg"></i>
                    </button>
                    <button class="btn btn-outline-info share-btn" data-platform="twitter">
                        <i class="fab fa-twitter fa-lg"></i>
                    </button>
                    <button class="btn btn-outline-success share-btn" data-platform="whatsapp">
                        <i class="fab fa-whatsapp fa-lg"></i>
                    </button>
                    <button class="btn btn-outline-primary share-btn" data-platform="linkedin">
                        <i class="fab fa-linkedin-in fa-lg"></i>
                    </button>
                    <button class="btn btn-outline-secondary" id="copyLink">
                        <i class="fas fa-link fa-lg"></i>
                    </button>
                </div>
                <div class="mt-4">
                    <label class="form-label">Direct Link</label>
                    <div class="input-group">
                        <input type="text" class="form-control" id="jobLink" readonly>
                        <button class="btn btn-outline-primary" type="button" id="copyLinkBtn">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.icon-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.formatted-content {
    line-height: 1.6;
}

.formatted-content ul {
    padding-left: 1.2rem;
}

.benefit-card {
    transition: all 0.3s ease;
}

.benefit-card:hover {
    transform: translateY(-5px);
}

.share-btn {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.share-btn:hover {
    transform: scale(1.1);
}
</style>
@endpush

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.1/moment.min.js"></script>
<script src="{{ asset('assets/js/job-detail.js') }}"></script>
@endpush

@endsection