@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'My Applications')

@section('left_sidebar')
@include('front_end.pages.jobs.job_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/jobs') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">My Applications</h4>
                                    <p class="mb-0 text-white">Track and manage your job applications</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Application Stats -->
        <div class="row mb-4">
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-primary bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-paper-plane fa-2x text-primary mb-2"></i>
                        <h3 class="mb-0" id="totalApplications">0</h3>
                        <p class="mb-0">Total Applications</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-warning bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-clock fa-2x text-warning mb-2"></i>
                        <h3 class="mb-0" id="pendingApplications">0</h3>
                        <p class="mb-0">Pending Review</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-success bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-check-circle fa-2x text-success mb-2"></i>
                        <h3 class="mb-0" id="shortlistedApplications">0</h3>
                        <p class="mb-0">Shortlisted</p>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-danger bg-opacity-10">
                    <div class="card-body text-center">
                        <i class="fas fa-times-circle fa-2x text-danger mb-2"></i>
                        <h3 class="mb-0" id="rejectedApplications">0</h3>
                        <p class="mb-0">Rejected</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter Section -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Search Jobs</label>
                        <input type="text" class="form-control" id="searchInput" placeholder="Search by job title or company">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="statusFilter">
                            <option value="">All Status</option>
                            <option value="pending">Pending</option>
                            <option value="shortlisted">Shortlisted</option>
                            <option value="interviewed">Interviewed</option>
                            <option value="rejected">Rejected</option>
                            <option value="hired">Hired</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Sort By</label>
                        <select class="form-select" id="sortBy">
                            <option value="created_at">Application Date</option>
                            <option value="status">Status</option>
                            <option value="job_title">Job Title</option>
                            <option value="company_name">Company Name</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Order</label>
                        <select class="form-select" id="sortOrder">
                            <option value="desc">Newest First</option>
                            <option value="asc">Oldest First</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Applications List -->
        <div id="applicationsList">
            <!-- Applications will be dynamically added here -->
        </div>

        <!-- Load More Button -->
        <div class="text-center mt-4" id="loadMoreContainer" style="display: none;">
            <button class="btn btn-outline-primary" id="loadMoreBtn">
                Load More
            </button>
        </div>

        <!-- Empty State -->
        <div id="emptyState" class="text-center py-5" style="display: none;">
            <img src="/assets/images/empty-state.svg" alt="No Applications" style="width: 200px;" class="mb-4">
            <h4>No Applications Found</h4>
            <p class="text-muted mb-4">You haven't applied to any jobs yet.</p>
            <a href="{{ url('/jobs') }}" class="btn btn-primary">
                Browse Jobs
            </a>
        </div>
    </div>
</div>

<!-- Application Details Modal -->
<div class="modal fade" id="applicationModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Application Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="applicationDetails">
                    <!-- Application details will be dynamically added here -->
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.application-card {
    transition: transform 0.2s ease-in-out;
}

.application-card:hover {
    transform: translateY(-5px);
}

.status-badge {
    min-width: 100px;
    text-align: center;
}

.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline:before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #e9ecef;
}

.timeline-item {
    position: relative;
    padding-bottom: 1.5rem;
}

.timeline-item:last-child {
    padding-bottom: 0;
}

.timeline-item:before {
    content: '';
    position: absolute;
    left: -34px;
    top: 0;
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: #0d6efd;
}

.animated-count {
    transition: all 0.3s ease-in-out;
}
</style>
@endpush

@push('scripts')
<script src="{{ asset('assets/js/moment.min.js') }}"></script>
<script src="{{ asset('assets/js/applied-jobs.js') }}"></script>
@endpush

@endsection