@extends('front_end.layouts.home')

@php
    $showRightSidebar = false;
@endphp

@section('title', 'Help Center')

@section('content')
<div class="container px-0 px-lg-3">
    <div class="row g-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                <div class="row g-0 align-items-center">
                    <div class="col-lg-12 p-4 p-lg-4">
                        <div class="d-flex align-items-center mb-3">
                            <span class="badge bg-primary bg-opacity-10 text-primary fs-6 me-2">
                                <i class="fas fa-life-ring me-2"></i>Need a hand?
                            </span>
                        </div>
                        <h1 class="display-6 fw-bold mb-3">Help Center</h1>
                        <p class="text-muted mb-4">Explore step-by-step guides, troubleshooting articles, and community tips to get the most out of Socialink.</p>

                        <form class="row g-2" method="GET" action="{{ route('help-center.index') }}">
                            <div class="col-12 col-md-9">
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light border-0">
                                        <i class="fas fa-search text-muted"></i>
                                    </span>
                                    <input type="text" name="q" class="form-control border-0 bg-light" placeholder="Search for a feature, topic, or question…" value="{{ $searchQuery }}">
                                </div>
                            </div>
                            <div class="col-12 col-md-3">
                                <button class="btn btn-primary btn-lg w-100" type="submit">
                                    Search
                                </button>
                            </div>
                        </form>

                        <div class="d-flex flex-wrap gap-3 mt-4">
                            <div>
                                <small class="text-muted text-uppercase">Popular searches:</small>
                            </div>
                            @foreach ($featuredArticles->take(3) as $quickArticle)
                                <a href="{{ route('help-center.article', [$quickArticle->topic->slug, $quickArticle->slug]) }}" class="badge rounded-pill bg-secondary bg-opacity-10 text-secondary">
                                    <i class="fas fa-arrow-up-right-from-square me-1"></i>{{ $quickArticle->title }}
                                </a>
                            @endforeach
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>

        @if ($searchQuery !== '')
            <div class="col-12">
                <div class="card border-0 shadow-sm rounded-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 flex-column flex-md-row gap-2">
                            <h5 class="card-title mb-0 text-break">
                                <i class="fas fa-search me-2 text-primary"></i>Search results for "{{ $searchQuery }}"
                            </h5>
                            <span class="text-muted flex-shrink-0">{{ $searchResults->count() }} matches</span>
                        </div>
                        @if ($searchResults->isEmpty())
                            <p class="text-muted mb-0">No articles matched your search. Try adjusting your keywords or explore the topics below.</p>
                        @else
                            <div class="list-group list-group-flush">
                                @foreach ($searchResults as $result)
                                    <a href="{{ route('help-center.article', [$result->topic->slug, $result->slug]) }}" class="list-group-item list-group-item-action py-3">
                                        <div class="d-flex justify-content-between align-items-start flex-column flex-md-row gap-2">
                                            <div class="flex-grow-1 min-w-0">
                                                <h6 class="mb-1 text-break">{{ $result->title }}</h6>
                                                <p class="text-muted mb-1">{{ Str::limit(strip_tags($result->summary ?? $result->content), 160) }}</p>
                                                <small class="text-primary">
                                                    <i class="fas fa-layer-group me-1"></i>{{ $result->topic->title }}
                                                </small>
                                            </div>
                                            <div class="text-end text-md-end ms-md-3 flex-shrink-0">
                                                <small class="text-muted text-uppercase">Read time</small>
                                                <div class="fw-semibold">{{ $result->estimated_reading_time ?? '—' }} min</div>
                                            </div>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        @if ($featuredArticles->isNotEmpty())
            <div class="col-12">
                <div class="card border-0 shadow-sm rounded-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 flex-column flex-md-row gap-2">
                            <h5 class="card-title mb-0">Featured guides</h5>
                            <a href="{{ route('help-center.index') }}" class="text-primary text-decoration-none">
                                View all
                                <i class="fas fa-arrow-right ms-1"></i>
                            </a>
                        </div>
                        <div class="row g-3">
                            @foreach ($featuredArticles as $article)
                                <div class="col-12 col-md-6 col-xl-4">
                                    <a href="{{ route('help-center.article', [$article->topic->slug, $article->slug]) }}" class="card h-100 border-0 shadow-sm hover-shadow transition-hover rounded-4 text-decoration-none text-dark">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <span class="badge bg-primary bg-opacity-10 text-primary">
                                                    <i class="fas fa-star me-1"></i>Featured
                                                </span>
                                            </div>
                                            <h6 class="fw-semibold mb-2 text-break">{{ $article->title }}</h6>
                                            <p class="text-muted mb-3">{{ Str::limit(strip_tags($article->summary ?? $article->content), 120) }}</p>
                                            <div class="d-flex justify-content-between align-items-center text-muted small flex-wrap gap-2">
                                                <span class="text-break"><i class="fas fa-layer-group me-1"></i>{{ $article->topic->title }}</span>
                                                <span class="flex-shrink-0"><i class="far fa-clock me-1"></i>{{ $article->estimated_reading_time ?? '—' }} min</span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <div class="col-12">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between mb-4 flex-column flex-md-row gap-3">
                        <div>
                            <h4 class="mb-1">Browse by topic</h4>
                            <p class="text-muted mb-0">Everything you need to know, organized for quick answers.</p>
                        </div>
                    </div>
                    <div class="row g-4">
                        @foreach ($topics as $topic)
                            <div class="col-12 col-md-6 col-xl-4">
                                <div class="card h-100 border-0 bg-light-subtle hover-shadow transition-hover rounded-4">
                                    <div class="card-body d-flex flex-column p-4">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="icon icon-shape bg-primary bg-opacity-10 text-primary rounded-circle me-3 flex-shrink-0">
                                                <i class="{{ $topic->icon ?? 'fas fa-book' }}"></i>
                                            </div>
                                            <div class="flex-grow-1 min-w-0">
                                                <h5 class="mb-0 text-break">{{ $topic->title }}</h5>
                                                <small class="text-muted">{{ $topic->articles->count() }} articles</small>
                                            </div>
                                        </div>
                                        <p class="text-muted flex-grow-1 mb-3">{{ Str::limit(strip_tags($topic->description), 140) }}</p>
                                        <div class="d-flex flex-wrap gap-2 mb-3">
                                            @foreach ($topic->articles->take(3) as $topicArticle)
                                                <a href="{{ route('help-center.article', [$topic->slug, $topicArticle->slug]) }}" class="badge rounded-pill bg-white border text-secondary text-wrap text-break" style="max-width: 100%; word-break: break-word; white-space: normal;">
                                                    {{ Str::limit($topicArticle->title, 50) }}
                                                </a>
                                            @endforeach
                                        </div>
                                        <a href="{{ route('help-center.topic', $topic->slug) }}" class="btn btn-sm btn-outline-primary mt-auto align-self-start">
                                            Explore topic <i class="fas fa-arrow-right ms-2"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between mb-3 flex-column flex-md-row gap-2">
                        <h5 class="card-title mb-0">Latest updates</h5>
                        <a href="{{ route('help-center.index') }}" class="text-muted small text-decoration-none">
                            Updated {{ optional($recentArticles->first())->updated_at?->diffForHumans() ?? 'recently' }}
                        </a>
                    </div>
                    <div class="list-group list-group-flush">
                        @forelse ($recentArticles as $recent)
                            <a href="{{ route('help-center.article', [$recent->topic->slug, $recent->slug]) }}" class="list-group-item list-group-item-action py-3">
                                <div class="d-flex justify-content-between align-items-start flex-column flex-md-row gap-2">
                                    <div class="flex-grow-1 min-w-0">
                                        <h6 class="mb-1 text-break">{{ $recent->title }}</h6>
                                        <small class="text-muted">
                                            <i class="fas fa-layer-group me-1"></i>{{ $recent->topic->title }}
                                            <span class="mx-2">•</span>
                                            <i class="far fa-clock me-1"></i>{{ $recent->updated_at?->diffForHumans() ?? '—' }}
                                        </small>
                                    </div>
                                    <span class="badge bg-primary bg-opacity-10 text-primary flex-shrink-0">
                                        {{ $recent->estimated_reading_time ?? '—' }} min read
                                    </span>
                                </div>
                            </a>
                        @empty
                            <div class="list-group-item text-muted text-center py-4">
                                Articles you publish will show up here.
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card border-0 shadow-sm rounded-4 bg-primary text-white">
                <div class="card-body d-flex flex-column flex-lg-row align-items-lg-center justify-content-between">
                    <div class="mb-3 mb-lg-0">
                        <h4 class="text-white mb-2">Still need assistance?</h4>
                        <p class="mb-0 text-white-50">Our support team is here 24/7. Reach out and we'll help you get back on track.</p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="mailto:support@socialink.com" class="btn btn-light text-primary">
                            <i class="fas fa-envelope me-2"></i>Email Support
                        </a>
                      
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
