@php
$showLeftSidebar = false;
$showRightSidebar = false;
$mainContentClass = 'col-12';
$boxAvatar = Auth::user()->avatar ?? null;
@endphp

@extends('front_end.layouts.home')

@section('title', $group->name . ' - Group - Socialink')

@push('styles')
@include('front_end.layouts.newsfeed_styles')
<style>
    :root {
        --primary-color: #1877f2;
        --secondary-color: #42b72a;
        --text-dark: #050505;
        --text-muted: #65676b;
        --border-light: #e4e6eb;
        --bg-light: #f0f2f5;
        --card-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        --card-hover-shadow: 0 2px 12px rgba(0, 0, 0, 0.15);
    }

    body {
        background-color: var(--bg-light);
    }

    /* Layout */
    .profile-page-container {
        max-width: 1080px;
        margin: 0 auto;
        padding: 0 16px;
        width: 100%;
    }

    @media (min-width: 1200px) {
        .profile-page-container {
            max-width: 1080px;
            padding: 0 24px;
        }
    }

    @media (max-width: 991px) {
        .profile-page-container {
            padding: 0 12px;
        }
    }

    /* Profile Cover */
    .profile-cover-section {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
    }

    .profile-cover {
        height: 300px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        background-size: cover;
        background-position: center;
        position: relative;
    }

    .profile-cover::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 100px;
        background: linear-gradient(to bottom, transparent, rgba(0,0,0,0.3));
    }

    /* Profile Info Section */
    .profile-info-section {
        padding: 16px 24px 20px;
        position: relative;
        display: flex;
        align-items: flex-end;
        gap: 16px;
    }

    @media (max-width: 768px) {
        .profile-info-section {
            padding: 16px 16px 16px;
            flex-direction: column;
            align-items: center;
        }
    }

    .profile-avatar-container {
        margin-top: -100px;
        position: relative;
        z-index: 10;
        flex-shrink: 0;
    }

    .profile-avatar {
        width: 180px;
        height: 180px;
        border: 6px solid white;
        border-radius: 50%;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.18);
        object-fit: cover;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 72px;
        color: var(--primary-color);
        font-weight: 700;
    }

    .profile-header-details {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: flex-end;
        padding-bottom: 8px;
    }

    .profile-name-section h1 {
        font-size: 32px;
        font-weight: 700;
        color: var(--text-dark);
        margin: 0 0 8px;
        line-height: 1.2;
    }

    /* Action Buttons */
    .profile-action-bar {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
        align-items: center;
        margin-top: 16px;
    }

    .btn-profile-action {
        padding: 10px 18px;
        font-size: 15px;
        font-weight: 600;
        border-radius: 999px;
        border: none;
        cursor: pointer;
        transition: all 0.2s;
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
    }

    .btn-primary-custom {
        background: var(--primary-color);
        color: white;
    }

    .btn-primary-custom:hover {
        background: #166fe5;
        color: white;
    }

    .btn-secondary-custom {
        background: var(--border-light);
        color: var(--text-dark);
    }

    .btn-secondary-custom:hover {
        background: #d8dadf;
        color: var(--text-dark);
    }

    .btn-success-custom {
        background: var(--secondary-color);
        color: white;
    }

    .btn-outline-custom {
        background: white;
        border: 1px solid var(--border-light);
        color: var(--text-dark);
    }

    .btn-outline-custom:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    /* Navigation Tabs */
    .profile-tabs {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        padding: 0 16px;
        margin-bottom: 16px;
    }

    .profile-nav-tabs {
        display: flex;
        gap: 8px;
        border: none;
    }

    .profile-nav-tabs .nav-link {
        padding: 16px 20px;
        color: var(--text-muted);
        font-weight: 600;
        font-size: 15px;
        border: none;
        border-bottom: 3px solid transparent;
        background: transparent;
        transition: all 0.2s;
    }

    .profile-nav-tabs .nav-link:hover {
        background: var(--bg-light);
        color: var(--text-dark);
    }

    .profile-nav-tabs .nav-link.active {
        color: var(--primary-color);
        border-bottom-color: var(--primary-color);
        background: transparent;
    }

    /* Content Area */
    .profile-content-wrapper {
        display: grid;
        grid-template-columns: 360px 1fr;
        gap: 16px;
        align-items: start;
    }

    @media (max-width: 991px) {
        .profile-content-wrapper {
            grid-template-columns: 1fr;
        }
    }

    /* Sidebar Cards */
    .profile-card {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        margin-bottom: 16px;
        overflow: hidden;
    }

    .profile-card-body {
        padding: 16px;
    }

    .profile-section-header {
        font-size: 16px;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .profile-section-header i {
        color: var(--primary-color);
    }

    .intro-list {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .intro-list li {
        display: flex;
        align-items: flex-start;
        gap: 10px;
        font-size: 15px;
        color: var(--text-dark);
        line-height: 1.4;
    }

    .intro-list li i {
        color: var(--primary-color);
        font-size: 18px;
        margin-top: 2px;
    }

    .profile-friend-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
    }

    .profile-friend-grid .friend-tile {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 8px;
        border-radius: 8px;
        text-decoration: none;
        color: var(--text-dark);
        transition: background 0.2s;
    }

    .profile-friend-grid .friend-tile:hover {
        background: var(--bg-light);
    }

    .profile-friend-grid .friend-tile img {
        width: 100%;
        aspect-ratio: 1;
        border-radius: 8px;
        object-fit: cover;
        margin-bottom: 8px;
    }

    .friend-name {
        font-size: 13px;
        font-weight: 600;
        color: var(--text-dark);
        line-height: 1.2;
    }

    .see-more-link {
        font-size: 15px;
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 600;
    }

    .see-more-link:hover {
        text-decoration: underline;
    }

    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-muted);
    }

    .empty-state i {
        font-size: 48px;
        margin-bottom: 12px;
        opacity: 0.5;
    }

    .empty-state p {
        margin: 0;
        font-size: 15px;
    }

    .profile-photo-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 8px;
    }

    .profile-photo-grid .photo-item {
        padding-bottom: 100%;
        border-radius: 8px;
        overflow: hidden;
        position: relative;
        background: var(--bg-light);
        cursor: pointer;
    }

    .profile-photo-grid .photo-item img {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* About Tab Styling */
    .about-section {
        background: white;
        border-radius: 8px;
        box-shadow: var(--card-shadow);
        padding: 20px;
    }

    .about-item {
        padding: 16px 0;
        border-bottom: 1px solid var(--border-light);
    }

    .about-item:last-child {
        border-bottom: none;
    }

    .about-label {
        font-size: 13px;
        color: var(--text-muted);
        margin-bottom: 6px;
        font-weight: 500;
    }

    .about-value {
        font-size: 15px;
        color: var(--text-dark);
        line-height: 1.5;
    }

    .about-value a {
        color: var(--primary-color);
        text-decoration: none;
        font-weight: 500;
    }

    .about-value a:hover {
        text-decoration: underline;
    }

    /* Invite Modal Styles */
    .invite-user-item {
        display: flex;
        align-items: center;
        padding: 12px;
        border-radius: 8px;
        margin-bottom: 8px;
        transition: background 0.2s;
        cursor: pointer;
    }

    .invite-user-item:hover {
        background: var(--bg-light);
    }

    .invite-user-item.selected {
        background: rgba(24, 119, 242, 0.1);
    }

    .invite-user-item img {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        object-fit: cover;
        margin-right: 12px;
    }

    .invite-user-info {
        flex: 1;
    }

    .invite-user-name {
        font-weight: 600;
        color: var(--text-dark);
        font-size: 15px;
    }

    .invite-user-username {
        font-size: 13px;
        color: var(--text-muted);
    }

    .invite-checkbox {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        border: 2px solid var(--border-light);
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
    }

    .invite-user-item.selected .invite-checkbox {
        background: var(--primary-color);
        border-color: var(--primary-color);
        color: white;
    }

    .invite-search-box {
        position: relative;
        margin-bottom: 16px;
    }

    .invite-search-box input {
        width: 100%;
        padding: 12px 16px 12px 40px;
        border: 1px solid var(--border-light);
        border-radius: 8px;
        font-size: 15px;
    }

    .invite-search-box i {
        position: absolute;
        left: 14px;
        top: 50%;
        transform: translateY(-50%);
        color: var(--text-muted);
    }
</style>
@endpush

@section('content')
<div class="profile-page-container">
    <!-- Profile Cover and Info -->
    <div class="profile-cover-section">
        <div class="profile-cover" style="background-image: url('{{ $group->cover_url ?? asset('assets/images/bg/04.jpg') }}');"></div>

        <div class="profile-info-section">
            <div class="profile-avatar-container">
                @if($group->avatar_url)
                    <img src="{{ $group->avatar_url }}" alt="{{ $group->name }}" class="profile-avatar">
                @else
                    <div class="profile-avatar">{{ strtoupper(substr($group->name, 0, 1)) }}</div>
                @endif
            </div>

            <div class="profile-header-details">
                <div class="profile-name-section">
                    <h1>{{ $group->name }}</h1>
                </div>

                <div class="profile-action-bar">
                    @if(!$group->already_member)
                        <button class="btn-profile-action btn-primary-custom join-group-btn" data-group-id="{{ $group->id }}">
                            <i class="bi bi-person-plus-fill"></i> Join Group
                        </button>
                    @else
                        <button class="btn-profile-action btn-success-custom" disabled>
                            <i class="bi bi-check-circle-fill"></i> Member
                        </button>
                        <button class="btn-profile-action btn-primary-custom" data-bs-toggle="modal" data-bs-target="#inviteMembersModal">
                            <i class="bi bi-person-plus-fill"></i> Invite Members
                        </button>
                        @if($group->is_group_owner)
                            <button class="btn-profile-action btn-secondary-custom" data-bs-toggle="modal" data-bs-target="#addMembersModal">
                                <i class="bi bi-person-check-fill"></i> Add Members
                            </button>
                            <a href="#" class="btn-profile-action btn-outline-custom">
                                <i class="bi bi-pencil-square"></i> Edit Group
                            </a>
                        @endif
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Tabs -->
    <div class="profile-tabs">
        <ul class="nav profile-nav-tabs" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="posts-tab" data-bs-toggle="tab" data-bs-target="#posts" type="button" role="tab">
                    <i class="bi bi-grid-3x3-gap me-1"></i> Posts
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="photos-tab" data-bs-toggle="tab" data-bs-target="#photos" type="button" role="tab">
                    <i class="bi bi-images me-1"></i> Photos
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="videos-tab" data-bs-toggle="tab" data-bs-target="#videos" type="button" role="tab">
                    <i class="bi bi-camera-video me-1"></i> Videos
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="members-tab" data-bs-toggle="tab" data-bs-target="#members" type="button" role="tab">
                    <i class="bi bi-people me-1"></i> Members
                </button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="about-tab" data-bs-toggle="tab" data-bs-target="#about" type="button" role="tab">
                    <i class="bi bi-info-circle me-1"></i> About
                </button>
            </li>
        </ul>
    </div>

    <!-- Tab Content -->
    <div class="tab-content">
        <!-- Posts Tab -->
        <div class="tab-pane fade show active" id="posts" role="tabpanel">
            <div class="profile-content-wrapper">
                <!-- Sidebar -->
                <div class="profile-sidebar">
                    <!-- Intro Card -->
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="profile-section-header mb-3">
                                <i class="bi bi-person-lines-fill"></i> Intro
                            </div>
                            @if($group->description)
                                <p class="text-muted mb-3">{{ $group->description }}</p>
                            @endif
                            <ul class="intro-list">
                                <li>
                                    <i class="bi bi-people-fill"></i>
                                    <span><strong>{{ number_format($group->members_count ?? 0) }}</strong> Members</span>
                                </li>
                                <li>
                                    <i class="bi bi-{{ $group->is_private ? 'lock' : 'globe' }}"></i>
                                    <span>{{ $group->is_private ? 'Private' : 'Public' }} Group</span>
                                </li>
                                @if($group->creator)
                                <li>
                                    <i class="bi bi-person"></i>
                                    <span>Created by <strong>{{ $group->creator->name ?? 'Unknown' }}</strong></span>
                                </li>
                                @endif
                            </ul>
                        </div>
                    </div>

                    <!-- Photos Widget -->
                    @php
                        $allPhotos = [];
                        foreach($photos as $photo) {
                            if($photo->media && $photo->media->count() > 0) {
                                foreach($photo->media as $media) {
                                    if($media->isImage()) {
                                        $allPhotos[] = $media;
                                    }
                                }
                            }
                        }
                    @endphp
                    @if(count($allPhotos) > 0)
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div class="profile-section-header mb-0">
                                    <i class="bi bi-images"></i> Photos
                                </div>
                                <a href="#photos" class="see-more-link" data-bs-toggle="tab" data-bs-target="#photos" role="tab">See all</a>
                            </div>
                            <div class="profile-photo-grid">
                                @foreach(array_slice($allPhotos, 0, 9) as $media)
                                <div class="photo-item" onclick="window.location.href='#photos'; document.getElementById('photos-tab').click();">
                                    <img src="{{ getMedia($media->media_path) }}" alt="Photo">
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Recent Members -->
                    @if($recentMembers && $recentMembers->count() > 0)
                    <div class="profile-card">
                        <div class="profile-card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div class="profile-section-header mb-0">
                                    <i class="bi bi-people"></i> Recent Members
                                </div>
                                <a href="#members" class="see-more-link" data-bs-toggle="tab" data-bs-target="#members" role="tab">See all</a>
                            </div>
                            <div class="profile-friend-grid">
                                @foreach($recentMembers as $member)
                                    <a href="{{ route('user.detail', ['username' => $member->username]) }}" class="friend-tile">
                                        <img src="{{ $member->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" alt="{{ $member->name }}">
                                        <div>
                                            <span class="friend-name">{{ $member->first_name ?? $member->name }}</span>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Main Content -->
                <div class="profile-main-content">
                    @php
                        $postType = 'group_post';
                        $groupId = $group->id;
                    @endphp
                    <input type="hidden" id="postType" value="{{ $postType }}">
                    <input type="hidden" id="groupId" value="{{ $groupId }}">
                    
                    @if($canPost)
                        @include('front_end.layouts.newsfeed_box')
                    @endif

                    <!-- Posts will be loaded here -->
                    <div id="postholder"></div>
                </div>
            </div>
        </div>

        <!-- Photos Tab -->
        <div class="tab-pane fade" id="photos" role="tabpanel">
            @php
                $allPhotos = [];
                foreach($photos as $photo) {
                    if($photo->media && $photo->media->count() > 0) {
                        foreach($photo->media as $media) {
                            if($media->isImage()) {
                                $allPhotos[] = $media;
                            }
                        }
                    }
                }
            @endphp
            @if(count($allPhotos) > 0)
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="profile-section-header mb-3">
                        <i class="bi bi-images"></i> Photos
                    </div>
                    <div class="profile-photo-grid" style="grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        @foreach($allPhotos as $media)
                        <div class="photo-item">
                            <img src="{{ getMedia($media->media_path) }}" alt="Photo">
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @else
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="empty-state">
                        <i class="bi bi-images"></i>
                        <p>No photos to show</p>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Videos Tab -->
        <div class="tab-pane fade" id="videos" role="tabpanel">
            @php
                $allVideos = [];
                foreach($photos as $post) {
                    if($post->media && $post->media->count() > 0) {
                        foreach($post->media as $media) {
                            if($media->isVideo()) {
                                $allVideos[] = $media;
                            }
                        }
                    }
                }
            @endphp
            @if(count($allVideos) > 0)
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="profile-section-header mb-3">
                        <i class="bi bi-camera-video"></i> Videos
                    </div>
                    <div class="profile-photo-grid" style="grid-template-columns: repeat(4, 1fr); gap: 8px;">
                        @foreach($allVideos as $media)
                        <div class="photo-item">
                            <video src="{{ getMedia($media->media_path) }}" style="width: 100%; height: 100%; object-fit: cover;"></video>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @else
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="empty-state">
                        <i class="bi bi-camera-video"></i>
                        <p>No videos to show</p>
                    </div>
                </div>
            </div>
            @endif
        </div>

        <!-- Members Tab -->
        <div class="tab-pane fade" id="members" role="tabpanel">
            <div class="profile-card">
                <div class="profile-card-body">
                    <div class="profile-section-header mb-3">
                        <i class="bi bi-people"></i> Members ({{ number_format($group->members_count ?? 0) }})
                    </div>
                    <div class="profile-friend-grid" style="grid-template-columns: repeat(4, 1fr);">
                        @foreach($group->members as $member)
                        <a href="{{ route('user.detail', ['username' => $member->username]) }}" class="friend-tile">
                            <img src="{{ $member->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" alt="{{ $member->name }}">
                            <div>
                                <span class="friend-name">{{ $member->first_name ?? $member->name }}</span>
                            </div>
                        </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- About Tab -->
        <div class="tab-pane fade" id="about" role="tabpanel">
            <div class="about-section">
                <div class="profile-section-header mb-4">
                    <i class="bi bi-info-circle"></i> About
                </div>
                
                @if($group->description)
                <div class="about-item">
                    <div class="about-label">Description</div>
                    <div class="about-value">{{ $group->description }}</div>
                </div>
                @endif

                <div class="about-item">
                    <div class="about-label">Privacy</div>
                    <div class="about-value">{{ $group->is_private ? 'Private Group' : 'Public Group' }}</div>
                </div>

                <div class="about-item">
                    <div class="about-label">Members</div>
                    <div class="about-value"><strong>{{ number_format($group->members_count ?? 0) }}</strong> people are members of this group</div>
                </div>

                @if($group->creator)
                <div class="about-item">
                    <div class="about-label">Created by</div>
                    <div class="about-value">
                        <div class="d-flex align-items-center">
                            <img src="{{ $group->creator->avatar_url ?? asset('assets/images/avatar/07.jpg') }}" 
                                class="rounded-circle me-2" 
                                style="width: 36px; height: 36px;"
                                alt="Creator Avatar">
                            <div>
                                <a href="{{ route('user.detail', ['username' => $group->creator->username]) }}">{{ $group->creator->name ?? 'Unknown' }}</a>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <div class="about-item">
                    <div class="about-label">Created</div>
                    <div class="about-value">{{ $group->created_at->format('F d, Y') }}</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Invite Members Modal -->
<div class="modal fade" id="inviteMembersModal" tabindex="-1" aria-labelledby="inviteMembersModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="inviteMembersModalLabel">
                    <i class="bi bi-person-plus-fill me-2"></i>Invite Members
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="invite-search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" id="inviteUserSearch" class="form-control" placeholder="Search for friends to invite...">
                </div>
                <div id="inviteUsersList" style="max-height: 400px; overflow-y: auto;">
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                        <p class="mt-2">Search for users to invite</p>
                    </div>
                </div>
                <div id="selectedUsersList" class="mt-3" style="display: none;">
                    <div class="d-flex flex-wrap gap-2" id="selectedUsersTags"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="sendInvitesBtn" disabled>
                    <i class="bi bi-send me-2"></i>Send Invites
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Add Members Modal -->
<div class="modal fade" id="addMembersModal" tabindex="-1" aria-labelledby="addMembersModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMembersModalLabel">
                    <i class="bi bi-person-check-fill me-2"></i>Add Members
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="invite-search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" id="addUserSearch" class="form-control" placeholder="Search for users to add...">
                </div>
                <div id="addUsersList" style="max-height: 400px; overflow-y: auto;">
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                        <p class="mt-2">Search for users to add to the group</p>
                    </div>
                </div>
                <div id="selectedAddUsersList" class="mt-3" style="display: none;">
                    <div class="d-flex flex-wrap gap-2" id="selectedAddUsersTags"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="addMembersBtn" disabled>
                    <i class="bi bi-person-check-fill me-2"></i>Add Members
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
@include('front_end.layouts.newsfeed_scripts')
<script src="{{ asset('assets/js/groups.js') }}"></script>
<script>
    $(document).ready(function() {
        // Load newsfeed for group posts
        loadNewsFeed();

        // Invite Members Functionality
        let selectedUserIds = [];
        let searchTimeout;

        // Search users
        $('#inviteUserSearch').on('input', function() {
            const query = $(this).val().trim();
            
            clearTimeout(searchTimeout);
            
            if (query.length < 2) {
                $('#inviteUsersList').html(`
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                        <p class="mt-2">Type at least 2 characters to search</p>
                    </div>
                `);
                return;
            }

            searchTimeout = setTimeout(function() {
                searchUsers(query);
            }, 300);
        });

        function searchUsers(query) {
            $('#inviteUsersList').html('<div class="text-center py-4"><div class="spinner-border" role="status"></div></div>');

            axios.get(`${base_url}/webapi/messenger/users/search`, {
                params: { query: query }
            })
            .then(response => {
                if (response.data.status === 200 && response.data.data && response.data.data.length > 0) {
                    renderUsersList(response.data.data);
                } else {
                    $('#inviteUsersList').html(`
                        <div class="text-center text-muted py-4">
                            <i class="bi bi-person-x" style="font-size: 32px; opacity: 0.5;"></i>
                            <p class="mt-2">No users found</p>
                        </div>
                    `);
                }
            })
            .catch(error => {
                console.error('Error searching users:', error);
                let errorMessage = 'Error searching users. Please try again.';
                if (error.response && error.response.data && error.response.data.message) {
                    errorMessage = error.response.data.message;
                }
                $('#inviteUsersList').html(`
                    <div class="text-center text-danger py-4">
                        <p>${errorMessage}</p>
                    </div>
                `);
            });
        }

        function renderUsersList(users) {
            const currentGroupId = {{ $group->id }};
            const currentMemberIds = @json($group->members->pluck('id')->toArray());
            
            let html = '';
            let hasUsers = false;
            
            users.forEach(user => {
                // Skip if user is already a member
                if (currentMemberIds.includes(user.id)) {
                    return;
                }

                hasUsers = true;
                const isSelected = selectedUserIds.includes(user.id);
                const avatar = user.avatar || '{{ asset("assets/images/avatar/07.jpg") }}';
                const name = user.full_name || (user.first_name + ' ' + user.last_name).trim() || user.username || 'User';
                const username = user.username || '';

                html += `
                    <div class="invite-user-item ${isSelected ? 'selected' : ''}" data-user-id="${user.id}">
                        <img src="${avatar}" alt="${name}">
                        <div class="invite-user-info">
                            <div class="invite-user-name">${name}</div>
                            ${username ? `<div class="invite-user-username">@${username}</div>` : ''}
                        </div>
                        <div class="invite-checkbox">
                            ${isSelected ? '<i class="bi bi-check"></i>' : ''}
                        </div>
                    </div>
                `;
            });

            $('#inviteUsersList').html(hasUsers ? html : `
                <div class="text-center text-muted py-4">
                    <i class="bi bi-person-x" style="font-size: 32px; opacity: 0.5;"></i>
                    <p class="mt-2">No users found or all users are already members</p>
                </div>
            `);
        }

        // Toggle user selection
        $(document).on('click', '.invite-user-item', function() {
            const userId = parseInt($(this).data('user-id'));
            const index = selectedUserIds.indexOf(userId);

            if (index > -1) {
                selectedUserIds.splice(index, 1);
                $(this).removeClass('selected');
                $(this).find('.invite-checkbox').html('');
            } else {
                selectedUserIds.push(userId);
                $(this).addClass('selected');
                $(this).find('.invite-checkbox').html('<i class="bi bi-check"></i>');
            }

            updateSelectedUsersList();
            updateSendButton();
        });

        function updateSelectedUsersList() {
            if (selectedUserIds.length === 0) {
                $('#selectedUsersList').hide();
                return;
            }

            $('#selectedUsersList').show();
            // You can add selected users tags here if needed
        }

        function updateSendButton() {
            $('#sendInvitesBtn').prop('disabled', selectedUserIds.length === 0);
        }

        // Send invites
        $('#sendInvitesBtn').on('click', function() {
            if (selectedUserIds.length === 0) return;

            const btn = $(this);
            const originalText = btn.html();
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Sending...');

            axios.post(`${base_url}/webapi/groups/invite-users`, {
                group_id: {{ $group->id }},
                user_ids: selectedUserIds
            })
            .then(response => {
                if (response.data.status === 200) {
                    // Show success message
                    const data = response.data.data || {};
                    let message = `Invites sent successfully!`;
                    if (data.already_members > 0 || data.already_invited > 0) {
                        message += ` (${data.invited_count} sent`;
                        if (data.already_members > 0) message += `, ${data.already_members} already members`;
                        if (data.already_invited > 0) message += `, ${data.already_invited} already invited`;
                        message += ')';
                    }
                    
                    alert(message);
                    
                    // Close modal and reset
                    $('#inviteMembersModal').modal('hide');
                    selectedUserIds = [];
                    $('#inviteUserSearch').val('');
                    $('#inviteUsersList').html(`
                        <div class="text-center text-muted py-4">
                            <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                            <p class="mt-2">Search for users to invite</p>
                        </div>
                    `);
                    $('#selectedUsersList').hide();
                } else {
                    alert(response.data.message || 'Failed to send invites');
                }
            })
            .catch(error => {
                console.error('Error sending invites:', error);
                alert(error.response?.data?.message || 'Failed to send invites. Please try again.');
            })
            .finally(() => {
                btn.prop('disabled', false).html(originalText);
            });
        });

        // Reset modal when closed
        $('#inviteMembersModal').on('hidden.bs.modal', function() {
            selectedUserIds = [];
            $('#inviteUserSearch').val('');
            $('#inviteUsersList').html(`
                <div class="text-center text-muted py-4">
                    <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                    <p class="mt-2">Search for users to invite</p>
                </div>
            `);
            $('#selectedUsersList').hide();
            updateSendButton();
        });

        // Add Members Functionality (Owner Only)
        let selectedAddUserIds = [];
        let addSearchTimeout;

        // Search users for adding
        $('#addUserSearch').on('input', function() {
            const query = $(this).val().trim();
            
            clearTimeout(addSearchTimeout);
            
            if (query.length < 2) {
                $('#addUsersList').html(`
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                        <p class="mt-2">Type at least 2 characters to search</p>
                    </div>
                `);
                return;
            }

            addSearchTimeout = setTimeout(function() {
                searchUsersForAdd(query);
            }, 300);
        });

        function searchUsersForAdd(query) {
            $('#addUsersList').html('<div class="text-center py-4"><div class="spinner-border" role="status"></div></div>');

            axios.get(`${base_url}/webapi/messenger/users/search`, {
                params: { query: query }
            })
            .then(response => {
                if (response.data.status === 200 && response.data.data && response.data.data.length > 0) {
                    renderAddUsersList(response.data.data);
                } else {
                    $('#addUsersList').html(`
                        <div class="text-center text-muted py-4">
                            <i class="bi bi-person-x" style="font-size: 32px; opacity: 0.5;"></i>
                            <p class="mt-2">No users found</p>
                        </div>
                    `);
                }
            })
            .catch(error => {
                console.error('Error searching users:', error);
                let errorMessage = 'Error searching users. Please try again.';
                if (error.response && error.response.data && error.response.data.message) {
                    errorMessage = error.response.data.message;
                }
                $('#addUsersList').html(`
                    <div class="text-center text-danger py-4">
                        <p>${errorMessage}</p>
                    </div>
                `);
            });
        }

        function renderAddUsersList(users) {
            const currentGroupId = {{ $group->id }};
            const currentMemberIds = @json($group->members->pluck('id')->toArray());
            
            let html = '';
            let hasUsers = false;
            
            users.forEach(user => {
                // Skip if user is already a member
                if (currentMemberIds.includes(user.id)) {
                    return;
                }

                hasUsers = true;
                const isSelected = selectedAddUserIds.includes(user.id);
                const avatar = user.avatar || '{{ asset("assets/images/avatar/07.jpg") }}';
                const name = user.full_name || (user.first_name + ' ' + user.last_name).trim() || user.username || 'User';
                const username = user.username || '';

                html += `
                    <div class="invite-user-item ${isSelected ? 'selected' : ''}" data-user-id="${user.id}">
                        <img src="${avatar}" alt="${name}">
                        <div class="invite-user-info">
                            <div class="invite-user-name">${name}</div>
                            ${username ? `<div class="invite-user-username">@${username}</div>` : ''}
                        </div>
                        <div class="invite-checkbox">
                            ${isSelected ? '<i class="bi bi-check"></i>' : ''}
                        </div>
                    </div>
                `;
            });

            $('#addUsersList').html(hasUsers ? html : `
                <div class="text-center text-muted py-4">
                    <i class="bi bi-person-x" style="font-size: 32px; opacity: 0.5;"></i>
                    <p class="mt-2">No users found or all users are already members</p>
                </div>
            `);
        }

        // Toggle user selection for adding
        $(document).on('click', '#addUsersList .invite-user-item', function() {
            const userId = parseInt($(this).data('user-id'));
            const index = selectedAddUserIds.indexOf(userId);

            if (index > -1) {
                selectedAddUserIds.splice(index, 1);
                $(this).removeClass('selected');
                $(this).find('.invite-checkbox').html('');
            } else {
                selectedAddUserIds.push(userId);
                $(this).addClass('selected');
                $(this).find('.invite-checkbox').html('<i class="bi bi-check"></i>');
            }

            updateSelectedAddUsersList();
            updateAddButton();
        });

        function updateSelectedAddUsersList() {
            if (selectedAddUserIds.length === 0) {
                $('#selectedAddUsersList').hide();
                return;
            }

            $('#selectedAddUsersList').show();
        }

        function updateAddButton() {
            $('#addMembersBtn').prop('disabled', selectedAddUserIds.length === 0);
        }

        // Add members
        $('#addMembersBtn').on('click', function() {
            if (selectedAddUserIds.length === 0) return;

            const btn = $(this);
            const originalText = btn.html();
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>Adding...');

            axios.post(`${base_url}/webapi/groups/add-members`, {
                group_id: {{ $group->id }},
                user_ids: selectedAddUserIds
            })
            .then(response => {
                if (response.data.status === 200) {
                    // Show success message
                    const data = response.data.data || {};
                    let message = `Members added successfully!`;
                    if (data.already_members > 0) {
                        message += ` (${data.added_count} added, ${data.already_members} already members)`;
                    }
                    
                    alert(message);
                    
                    // Reload page to update member count and list
                    window.location.reload();
                } else {
                    alert(response.data.message || 'Failed to add members');
                }
            })
            .catch(error => {
                console.error('Error adding members:', error);
                alert(error.response?.data?.message || 'Failed to add members. Please try again.');
            })
            .finally(() => {
                btn.prop('disabled', false).html(originalText);
            });
        });

        // Reset add members modal when closed
        $('#addMembersModal').on('hidden.bs.modal', function() {
            selectedAddUserIds = [];
            $('#addUserSearch').val('');
            $('#addUsersList').html(`
                <div class="text-center text-muted py-4">
                    <i class="bi bi-search" style="font-size: 32px; opacity: 0.5;"></i>
                    <p class="mt-2">Search for users to add to the group</p>
                </div>
            `);
            $('#selectedAddUsersList').hide();
            updateAddButton();
        });
    });
</script>
@endpush
