@extends('front_end.layouts.home')

@section('title', $game->title)

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.index') }}">Games</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.category', $game->category->slug) }}">{{ $game->category->name }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ $game->title }}</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="row g-0">
                    <div class="col-md-4">
                        <img src="{{ $game->thumbnail_url ?? asset('images/game-placeholder.jpg') }}" class="img-fluid rounded-start h-100" style="object-fit: cover;" alt="{{ $game->title }}">
                    </div>
                    <div class="col-md-8">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <h1 class="card-title mb-0">{{ $game->title }}</h1>
                                <div>
                                    @if($game->is_multiplayer)
                                    <span class="badge bg-info">Multiplayer</span>
                                    @endif
                                    <span class="badge bg-secondary ms-1">{{ $game->min_age }}+</span>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-3">
                                <div class="game-rating me-2" data-rating="{{ $game->avg_rating }}"></div>
                                <span class="text-muted">({{ $game->ratings->count() }} ratings)</span>
                            </div>
                            
                            <p class="card-text">{{ $game->description }}</p>
                            
                            <div class="row mb-4">
                                <div class="col-sm-6">
                                    <p class="mb-1"><strong>Category:</strong> {{ $game->category->name }}</p>
                                    <p class="mb-1"><strong>Age Rating:</strong> {{ $game->min_age }}+</p>
                                </div>
                                <div class="col-sm-6">
                                    <p class="mb-1"><strong>Multiplayer:</strong> {{ $game->is_multiplayer ? 'Yes' : 'No' }}</p>
                                    <p class="mb-1"><strong>Total Plays:</strong> {{ number_format($game->plays_count) }}</p>
                                </div>
                            </div>
                            
                            <div class="d-flex gap-2">
                                <a href="{{ route('games.play', $game->slug) }}" class="btn btn-primary">
                                    <i class="fas fa-play me-2"></i>Play Now
                                </a>
                            </div>
                            
                            <!-- Rating Form -->
                            @auth
                            <div class="mt-4">
                                <h4>Rate this game</h4>
                                <form action="{{ route('games.rate', $game) }}" method="POST">
                                    @csrf
                                    <div class="mb-3">
                                        <label for="rating">Your Rating:</label>
                                        <div id="user-rating"></div>
                                        <input type="hidden" name="rating" id="rating-value" value="{{ $userRating->rating ?? 0 }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="comment">Your Comment (Optional):</label>
                                        <textarea class="form-control" id="comment" name="comment" rows="3">{{ $userRating->comment ?? '' }}</textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit Rating</button>
                                </form>
                            </div>
                            @else
                            <div class="mt-4">
                                <p>Please <a href="{{ route('login') }}">login</a> to rate this game.</p>
                            </div>
                            @endauth
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Game Instructions Section -->
    @if($game->instructions)
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-3">
                    <h3 class="mb-0">How to Play</h3>
                </div>
                <div class="card-body">
                    <div class="p-3">
                        {!! nl2br(e($game->instructions)) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    
    <!-- Related Games Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="mb-4">Similar Games</h3>
            <div class="row g-4">
                @foreach($relatedGames as $relatedGame)
                <div class="col-lg-3 col-md-6">
                    @include('front_end.pages.games.partials.game_card', ['game' => $relatedGame])
                </div>
                @endforeach
            </div>
        </div>
    </div>
    
    <!-- Game Reviews Section -->
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="mb-4">User Reviews</h3>
            @if($game->ratings->count() > 0)
                @foreach($game->ratings as $rating)
                <div class="card mb-3 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <h5 class="mb-0">{{ $rating->user->name }}</h5>
                                <div class="game-rating" data-rating="{{ $rating->rating }}"></div>
                            </div>
                            <small class="text-muted">{{ $rating->created_at->diffForHumans() }}</small>
                        </div>
                        @if($rating->comment)
                        <p class="card-text">{{ $rating->comment }}</p>
                        @else
                        <p class="text-muted"><em>No written comment</em></p>
                        @endif
                    </div>
                </div>
                @endforeach
            @else
                <div class="alert alert-info">
                    No reviews yet. Be the first to review this game!
                </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize readonly game ratings
        $('.game-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
        
        // Initialize user rating input
        $("#user-rating").rateYo({
            rating: {{ $userRating->rating ?? 0 }},
            fullStar: true,
            starWidth: "24px",
            onChange: function(rating, rateYoInstance) {
                $("#rating-value").val(rating);
            }
        });
    });
</script>
@endpush
@endsection