@extends('front_end.layouts.home')

@section('title', 'Play ' . $game->title)

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb" class="mb-3">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('index') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.index') }}">Games</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('games.show', $game->slug) }}">{{ $game->title }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Play</li>
                </ol>
            </nav>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-9">
            <!-- Game Frame -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body p-0">
                    <div class="ratio ratio-16x9">
                        <iframe src="{{ $game->game_url }}" allowfullscreen frameborder="0" webkitallowfullscreen mozallowfullscreen msallowfullscreen></iframe>
                    </div>
                </div>
            </div>
            
            <!-- Game Info -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body">
                    <h1 class="mb-2">{{ $game->title }}</h1>
                    <div class="d-flex align-items-center mb-3">
                        <div class="game-rating me-2" data-rating="{{ $game->avg_rating }}"></div>
                        <span class="text-muted">({{ $game->ratings->count() }} ratings)</span>
                        <span class="mx-2">•</span>
                        <span>{{ $game->category->name }}</span>
                        <span class="mx-2">•</span>
                        <span>{{ number_format($game->plays_count) }} plays</span>
                        @if($game->is_multiplayer)
                        <span class="mx-2">•</span>
                        <span class="badge bg-info">Multiplayer</span>
                        @endif
                        <span class="mx-2">•</span>
                        <span class="badge bg-secondary">{{ $game->min_age }}+</span>
                    </div>
                    <p>{{ $game->description }}</p>
                </div>
            </div>
            
            <!-- Game Instructions -->
            @if($game->instructions)
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">How to Play</h5>
                </div>
                <div class="card-body">
                    <div class="p-2">
                        {!! nl2br(e($game->instructions)) !!}
                    </div>
                </div>
            </div>
            @endif
        </div>
        
        <div class="col-md-3">
            <!-- Related Games -->
            <h4 class="mb-3">You Might Also Like</h4>
            @foreach($relatedGames as $relatedGame)
            <div class="card mb-3 border-0 shadow-sm">
                <div class="row g-0">
                    <div class="col-4">
                        <a href="{{ route('games.show', $relatedGame->slug) }}">
                            <img src="{{ $relatedGame->thumbnail_url ?? asset('images/game-placeholder.jpg') }}" class="img-fluid rounded-start" alt="{{ $relatedGame->title }}" style="object-fit: cover; height: 100%;">
                        </a>
                    </div>
                    <div class="col-8">
                        <div class="card-body py-2">
                            <h6 class="card-title mb-1">
                                <a href="{{ route('games.show', $relatedGame->slug) }}" class="text-decoration-none">{{ $relatedGame->title }}</a>
                            </h6>
                            <div class="game-rating" data-rating="{{ $relatedGame->avg_rating }}"></div>
                            <p class="card-text small text-muted mb-0">{{ number_format($relatedGame->plays_count) }} plays</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
            
            <!-- Call to Action -->
            <div class="card border-0 bg-light shadow-sm mt-4">
                <div class="card-body text-center">
                    <h5 class="mb-3">Enjoying the game?</h5>
                    <a href="{{ route('games.show', $game->slug) }}#rating" class="btn btn-primary mb-2 w-100">Rate this Game</a>
                    <a href="{{ route('games.category', $game->category->slug) }}" class="btn btn-outline-primary w-100">More {{ $game->category->name }} Games</a>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('.game-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "16px"
            });
        });
    });
</script>
@endpush
@endsection