@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'HTML5 Games')

@section('left_sidebar')
@include('front_end.pages.games.games_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">HTML5 Games</h4>
                                    <p class="mb-0 text-white">Play hundreds of free games directly in your browser</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('search.games') }}" class="btn btn-info">
                                    <i class="fas fa-search me-2"></i>Browse All Games
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <!-- Categories Section -->
        <div class="row mb-5">
            <div class="col-12">
                <h3 class="mb-4">Game Categories</h3>
                <div class="row g-3">
                    @foreach($categories as $category)
                    <div class="col-md-3 col-sm-6">
                        <a href="{{ route('games.category', $category->slug) }}" class="text-decoration-none">
                            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                                <div class="card-body text-center p-4">
                                    <div class="rounded-circle bg-primary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                        <i class="{{ $category->icon ?? 'fas fa-gamepad' }} fa-2x text-primary"></i>
                                    </div>
                                    <h5 class="card-title">{{ $category->name }}</h5>
                                    <p class="text-muted small mb-0">{{ $category->games_count ?? 0 }} games</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Featured Games -->
        @if($featuredGames->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Featured Games</h3>
                    <a href="{{ route('search.games') }}?featured=1" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($featuredGames as $game)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.games.partials.game_card', ['game' => $game])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Popular Games -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Most Popular</h3>
                    <a href="{{ route('search.games') }}?sort=popularity" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($popularGames as $game)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.games.partials.game_card', ['game' => $game])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- New Games -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Newest Games</h3>
                    <a href="{{ route('search.games') }}?sort=newest" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($newestGames as $game)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.games.partials.game_card', ['game' => $game])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Top Rated Games -->
        @if($topRatedGames->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Top Rated</h3>
                    <a href="{{ route('search.games') }}?sort=rating" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($topRatedGames as $game)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.games.partials.game_card', ['game' => $game])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

       
    </div>
</div>

@push('scripts')
<script>
    // Game rating initialization
    $(document).ready(function() {
        $('.game-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection