{{-- views/front_end/friends/index.blade.php --}}
@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp

@section('title', 'Friends')

@section('styles')
<style>
    .loading-opacity {
        opacity: 0.6;
        pointer-events: none;
    }

    .transition-all {
        transition: all 0.3s ease;
    }

    .hover-shadow-lg:hover {
        transform: translateY(-3px);
    }

    .friend-card-wrapper {
        margin-bottom: 1.5rem;
    }

    .profile-image-wrapper img {
        border: 4px solid white;
        transition: transform 0.3s ease;
    }

    .friend-card-wrapper:hover .profile-image-wrapper img {
        transform: scale(1.05);
    }

    .role-selection-menu {
        background: white;
        border-radius: 0.5rem;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        z-index: 1000;
        min-width: 200px;
    }

    .empty-state {
        padding: 3rem;
        background: #f8f9fa;
        border-radius: 1rem;
    }

    .friend-filter.active {
        background-color: var(--bs-primary);
        color: white;
    }
</style>
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="bg-primary text-white p-4 rounded-top-3">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <a href="{{ url('/') }}" class="text-white me-3">
                            <i class="fas fa-arrow-left fa-lg"></i>
                        </a>
                        <div>
                            <h4 class="mb-0 text-white">Friends</h4>
                            <p class="mb-0 text-white-50">Manage your connections</p>
                        </div>
                    </div>
                    {{-- <div class="d-flex gap-2">
                        <a href="{{ url('friends/find') }}" class="btn btn-light">
                            <i class="fas fa-user-plus me-2"></i>Find Friends
                        </a>
                       
                    </div> --}}
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <!-- Error Container -->
        <div id="error-container"></div>

        <!-- Stats Overview -->
        <div class="row g-3 mb-4" id="stats-container">
           

            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-primary bg-opacity-10 hover-shadow-lg transition-hover rounded-3">
                    <div class="card-body text-center">
                        <div class="icon-md bg-primary bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-user-friends text-primary"></i>
                        </div>
                        <h4 class="mb-1" id="total-friends">-</h4>
                        <p class="mb-0 small">Total Friends</p>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-success bg-opacity-10 hover-shadow-lg transition-hover rounded-3">
                    <div class="card-body text-center">
                        <div class="icon-md bg-success bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-circle text-success"></i>
                        </div>
                        <h4 class="mb-0" id="online-now">0</h4>
                        <p class="mb-0 small">Online Now</p>
                    </div>
                </div>
            </div>



            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-warning bg-opacity-10 hover-shadow-lg transition-hover rounded-3">
                    <div class="card-body text-center">
                        <div class="icon-md bg-warning bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-birthday-cake text-warning"></i>
                        </div>
                        <h4 class="mb-0" id="birthdays-today">0</h4>
                        <p class="mb-0 small">Birthdays Today</p>
                    </div>
                </div>
            </div>




            <div class="col-sm-6 col-lg-3">
                <div class="card border-0 bg-danger bg-opacity-10 hover-shadow-lg transition-hover rounded-3">
                    <div class="card-body text-center">
                        <div class="icon-md bg-danger bg-opacity-10 rounded-circle mb-2 mx-auto">
                            <i class="fas fa-user-plus text-danger"></i>
                        </div>
                        <h4 class="mb-0" id="new-requests">0</h4>
                        <p class="mb-0 small">New Requests</p>
                    </div>
                </div>
            </div>





        </div>

        <!-- Search and Filters -->
        <div class="card border-0 shadow-sm rounded-3 mb-4">
            <div class="card-body p-4">
                <div class="row g-3">
                    <div class="col-md-8">
                        <div class="input-group">
                            <span class="input-group-text bg-transparent border-end-0">
                                <i class="fas fa-search"></i>
                            </span>
                            <input type="text"
                                class="form-control border-start-0 ps-0"
                                id="search-input"
                                placeholder="Search friends...">
                            <span class="input-group-text bg-transparent border-start-0 d-none" id="search-indicator">
                                <i class="fas fa-spinner fa-spin"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <select class="form-select" id="sort-select">
                            <option value="recent">Recently Active</option>
                            <option value="alphabetical">Alphabetical</option>
                            <option value="mutual">Most Mutual Friends</option>
                            <option value="newest">Newest First</option>
                        </select>
                    </div>
                </div>

                <!-- Filter Pills -->
                <div class="mt-4">
                    <div class="d-flex flex-wrap gap-2">
                        <button class="btn btn-light friend-filter active" data-filter="all">
                            <i class="fas fa-users me-2"></i>All Friends
                        </button>
                        <button class="btn btn-light friend-filter" data-filter="close">
                            <i class="fas fa-star me-2"></i>Close Friends
                        </button>
                        <button class="btn btn-light friend-filter" data-filter="family">
                            <i class="fas fa-home me-2"></i>Family
                        </button>
                        <button class="btn btn-light friend-filter" data-filter="work">
                            <i class="fas fa-briefcase me-2"></i>Work
                        </button>
                        <button class="btn btn-light friend-filter" data-filter="school">
                            <i class="fas fa-graduation-cap me-2"></i>School
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loading Indicator -->
        <div id="loading-indicator" class="text-center py-4 d-none">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>

        <!-- Friends Grid -->
        <div class="row g-4" id="friends-container"></div>

        <!-- Load More -->
        <div class="text-center my-4">
            <button id="load-more-friends" class="btn btn-primary px-4 py-2" style="display: none;">
                <i class="fas fa-sync-alt me-2"></i>Load More
            </button>
        </div>

    </div>
</div>


@endsection

@push('scripts')
<script src="{{ asset('assets/js/friends.js') }}"></script>
@endpush

@section('extra-js')
<script>
    $(document).ready(function() {
        // Initialize components
        get_all_friends();
        getFriendStats();
        loadFriendLists();

        // Load More button click handler
        $("#load-more-friends").on("click", function() {
            loadMoreFriends();
        });

        // Initialize infinite scroll (optional - you can remove if only using button)
        $(window).scroll(function() {
            if ($(window).scrollTop() + $(window).height() > $(document).height() - 100) {
                if (!state.loading && !state.allLoaded) {
                    loadMoreFriends();
                }
            }
        });
    });
</script>
@endsection