@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', $event->name)

@section('left_sidebar')
@include('front_end.pages.events.events_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Event Header -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <!-- Cover Image / Header -->
                    <div class="position-relative mb-3">
                        <img src="{{ getMedia($event->cover_image) }}" class="card-img-top rounded-top-3" alt="{{ $event->name }}" style="height: 300px; object-fit: cover;">
                        
                        <!-- Return arrow - positioned on top -->
                        <div class="position-absolute top-0 start-0 m-3">
                            {{-- <a href="{{ route('events.index') }}" class="btn btn-light btn-icon rounded-circle shadow-sm">
                                <i class="fas fa-arrow-left"></i>
                            </a> --}}
                        </div>
                        
                        <!-- Event status indicator -->
                        <div class="position-absolute top-0 end-0 m-3">
                            @if(Carbon\Carbon::parse($event->end_date)->isPast())
                                <span class="badge bg-danger fs-6 px-3 py-2">Event Ended</span>
                            @elseif(Carbon\Carbon::parse($event->start_date)->isToday())
                                <span class="badge bg-success fs-6 px-3 py-2">Happening Today</span>
                            @elseif(Carbon\Carbon::parse($event->start_date)->isPast() && Carbon\Carbon::parse($event->end_date)->isFuture())
                                <span class="badge bg-primary fs-6 px-3 py-2">Ongoing</span>
                            @else
                                <span class="badge bg-info fs-6 px-3 py-2">Upcoming</span>
                            @endif
                        </div>
                        
                        <!-- Event category badge -->
                        <div class="position-absolute bottom-0 start-0 m-3">
                            <span class="badge bg-light text-dark text-capitalize fs-6 px-3 py-2">
                                <i class="fas fa-tag me-1"></i>{{ $event->category }}
                            </span>
                        </div>
                    </div>
                    
                    <!-- Event Title and Actions -->
                    <div class="p-4">
                        <div class="d-md-flex justify-content-between align-items-center">
                            <div>
                                <h1 class="mb-2">{{ $event->name }}</h1>
                                <div class="d-flex align-items-center text-muted mb-3">
                                    <div class="me-3">
                                        <i class="fas fa-user-circle me-1"></i>Hosted by 
                                        <a href="{{ url('profile/' . $event->organizer->username) }}" class="text-decoration-none">
                                            {{ $event->organizer->name }}
                                        </a>
                                    </div>
                                    <div>
                                        <i class="fas fa-users me-1"></i>{{ $goingCount }} {{ $goingCount == 1 ? 'person' : 'people' }} going
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="d-flex flex-wrap gap-2">
                                @if(Auth::check())
                                    @if($isHost)
                                        <a href="{{ route('events.edit', $event->slug) }}" class="btn btn-outline-primary">
                                            <i class="fas fa-edit me-2"></i>Edit Event
                                        </a>
                                        <form action="{{ route('events.delete', $event->slug) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this event?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger">
                                                <i class="fas fa-trash-alt me-2"></i>Delete
                                            </button>
                                        </form>
                                    @else
                                        <button type="button" class="btn {{ $isUserGoing ? 'btn-success' : 'btn-primary' }} going-button" data-event-id="{{ $event->id }}">
                                            <i class="fas {{ $isUserGoing ? 'fa-check-circle' : 'fa-calendar-check' }} me-2"></i>
                                            {{ $isUserGoing ? "I'm Going" : 'Going' }}
                                        </button>
                                        <button type="button" class="btn {{ $isUserInterested ? 'btn-warning' : 'btn-outline-warning' }} interest-button" data-event-id="{{ $event->id }}">
                                            <i class="fas {{ $isUserInterested ? 'fa-star' : 'fa-star' }} me-2"></i>
                                            {{ $isUserInterested ? 'Interested' : 'Interested' }}
                                        </button>
                                    @endif
                                    <button type="button" class="btn btn-outline-secondary" onclick="shareEvent()">
                                        <i class="fas fa-share-alt me-2"></i>Share
                                    </button>
                                @else
                                    <a href="{{ route('login') }}" class="btn btn-primary">
                                        <i class="fas fa-sign-in-alt me-2"></i>Login to Participate
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container pb-5">
        <div class="row">
            <!-- Event Details Column -->
            <div class="col-lg-8">
                <!-- Event Info Card -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Event Details</h4>
                        
                        <!-- Event Time and Location Section -->
                        <div class="d-flex mb-4">
                            <div class="flex-shrink-0 me-3">
                                <div class="bg-light p-3 rounded-3 text-center">
                                    <div class="text-primary fw-bold">{{ Carbon\Carbon::parse($event->start_date)->format('M') }}</div>
                                    <div class="h3 mb-0">{{ Carbon\Carbon::parse($event->start_date)->format('d') }}</div>
                                </div>
                            </div>
                            <div>
                                <h5 class="mb-2">Date & Time</h5>
                                <p class="mb-1">
                                    <i class="far fa-calendar-alt me-2 text-primary"></i>
                                    {{ Carbon\Carbon::parse($event->start_date)->format('l, F j, Y') }}
                                </p>
                                <p class="mb-1">
                                    <i class="far fa-clock me-2 text-primary"></i>
                                    {{ Carbon\Carbon::parse($event->start_time)->format('g:i A') }} - 
                                    {{ Carbon\Carbon::parse($event->end_time)->format('g:i A') }}
                                </p>
                                @if(!Carbon\Carbon::parse($event->start_date)->isPast())
                                    <p class="text-muted">
                                        <i class="fas fa-hourglass-half me-2"></i>
                                        Starts {{ Carbon\Carbon::parse("{$event->start_date} {$event->start_time}")->diffForHumans() }}
                                    </p>
                                @endif
                            </div>
                        </div>
                        
                        <!-- Location Section -->
                        <div class="d-flex mb-4">
                            <div class="flex-shrink-0 me-3">
                                <div class="bg-light p-3 rounded-3 text-center">
                                    <i class="fas fa-map-marker-alt text-danger fa-2x"></i>
                                </div>
                            </div>
                            <div>
                                <h5 class="mb-2">Location</h5>
                                <p class="mb-2">{{ $event->location }}</p>
                                <a href="https://maps.google.com/?q={{ urlencode($event->location) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-directions me-2"></i>Get Directions
                                </a>
                            </div>
                        </div>
                        
                        <!-- Event Description -->
                        <div class="mt-4">
                            <h5 class="mb-3">About This Event</h5>
                            <div class="event-description mb-4">
                                {{ $event->description }}
                            </div>
                            
                            @if($event->event_url)
                                <a href="{{ $event->event_url }}" target="_blank" class="btn btn-primary">
                                    <i class="fas fa-external-link-alt me-2"></i>Visit Event Website
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                
                <!-- Event Participants -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="card-title mb-0">Going</h4>
                            <span class="badge bg-success rounded-pill">{{ $goingCount }}</span>
                        </div>
                        
                        @if($participants->count() > 0)
                            <div class="row g-3">
                                @foreach($participants->take(12) as $participant)
                                    <div class="col-md-3 col-6">
                                        <div class="card border-0 text-center">
                                            <a href="{{ url('profile/' . ($participant->user->username ?? 'user')) }}" class="text-decoration-none">
                                                <img src="{{ getMedia($participant->user->avatar) }}" class="rounded-circle mx-auto" style="width: 64px; height: 64px; object-fit: cover;">
                                                <div class="mt-2 text-truncate">{{ $participant->user->name }}</div>
                                            </a>
                                            @if($participant->is_host)
                                                <span class="badge bg-primary mt-1">Host</span>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            
                            @if($goingCount > 12)
                                <div class="text-center mt-3">
                                    <a href="#" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#goingModal">
                                        View All {{ $goingCount }} Attendees
                                    </a>
                                </div>
                            @endif
                        @else
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-users fa-3x mb-3"></i>
                                <p>No one has RSVP'd yet. Be the first to join!</p>
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Interested Users -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="card-title mb-0">Interested</h4>
                            <span class="badge bg-warning rounded-pill">{{ $interestedCount }}</span>
                        </div>
                        
                        @if($interestedUsers->count() > 0)
                            <div class="row g-3">
                                @foreach($interestedUsers->take(12) as $interested)
                                    <div class="col-md-3 col-6">
                                        <div class="card border-0 text-center">
                                            <a href="{{ url('profile/' . ($interested->user->username ?? 'user')) }}" class="text-decoration-none">
                                                <img src="{{ getMedia($interested->user->avatar) }}" class="rounded-circle mx-auto" style="width: 64px; height: 64px; object-fit: cover;">
                                                <div class="mt-2 text-truncate">{{ $interested->user->name }}</div>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            
                            @if($interestedCount > 12)
                                <div class="text-center mt-3">
                                    <a href="#" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#interestedModal">
                                        View All {{ $interestedCount }} Interested
                                    </a>
                                </div>
                            @endif
                        @else
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-star fa-3x mb-3"></i>
                                <p>No one has shown interest yet.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Event Summary Card -->
                <div class="card border-0 shadow-sm  mb-4" style="top: 20px; z-index: 100;">
                    <div class="card-body">
                        <h4 class="card-title mb-4">Event Summary</h4>
                        
                        <!-- Quick Info -->
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="flex-shrink-0 me-3">
                                    <div class="bg-primary bg-opacity-10 p-3 rounded-circle">
                                        <i class="fas fa-calendar-alt text-primary"></i>
                                    </div>
                                </div>
                                <div>
                                    <div class="text-muted small">When</div>
                                    <div>{{ Carbon\Carbon::parse($event->start_date)->format('D, M j, Y') }}</div>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-3">
                                <div class="flex-shrink-0 me-3">
                                    <div class="bg-danger bg-opacity-10 p-3 rounded-circle">
                                        <i class="fas fa-map-marker-alt text-danger"></i>
                                    </div>
                                </div>
                                <div>
                                    <div class="text-muted small">Where</div>
                                    <div>{{ Str::limit($event->location, 30) }}</div>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-3">
                                <div class="flex-shrink-0 me-3">
                                    <div class="bg-success bg-opacity-10 p-3 rounded-circle">
                                        <i class="fas fa-users text-success"></i>
                                    </div>
                                </div>
                                <div>
                                    <div class="text-muted small">Attendees</div>
                                    <div>{{ $goingCount }} Going • {{ $interestedCount }} Interested</div>
                                </div>
                            </div>
                            
                            @if($event->max_participants)
                                <div class="d-flex align-items-center mb-3">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="bg-info bg-opacity-10 p-3 rounded-circle">
                                            <i class="fas fa-ticket-alt text-info"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="text-muted small">Capacity</div>
                                        <div>
                                            {{ $goingCount }} / {{ $event->max_participants }} Spots Filled
                                            @if($goingCount >= $event->max_participants)
                                                <span class="badge bg-danger ms-2">Full</span>
                                            @else
                                                <span class="badge bg-success ms-2">{{ $event->max_participants - $goingCount }} Available</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        
                        <!-- Call to Action -->
                        @if(Auth::check() && !$isHost)
                            <div class="d-grid gap-2">
                                <button type="button" class="btn {{ $isUserGoing ? 'btn-success' : 'btn-primary' }} going-button" data-event-id="{{ $event->id }}">
                                    <i class="fas {{ $isUserGoing ? 'fa-check-circle' : 'fa-calendar-check' }} me-2"></i>
                                    {{ $isUserGoing ? "I'm Going" : 'Going' }}
                                </button>
                                <button type="button" class="btn {{ $isUserInterested ? 'btn-warning' : 'btn-outline-warning' }} interest-button" data-event-id="{{ $event->id }}">
                                    <i class="fas {{ $isUserInterested ? 'fa-star' : 'fa-star' }} me-2"></i>
                                    {{ $isUserInterested ? 'Interested' : 'Interested' }}
                                </button>
                            </div>
                        @elseif(!Auth::check())
                            <div class="d-grid">
                                <a href="{{ route('login') }}" class="btn btn-primary">
                                    <i class="fas fa-sign-in-alt me-2"></i>Login to Participate
                                </a>
                            </div>
                        @endif
                        
                        <!-- Share Links -->
                        <div class="mt-4">
                            <div class="text-center mb-2">Share this event</div>
                            <div class="d-flex justify-content-center gap-2">
                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(route('events.show', $event->slug)) }}" target="_blank" class="btn btn-sm btn-outline-primary rounded-circle">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="https://twitter.com/intent/tweet?text={{ urlencode($event->name) }}&url={{ urlencode(route('events.show', $event->slug)) }}" target="_blank" class="btn btn-sm btn-outline-info rounded-circle">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a href="https://wa.me/?text={{ urlencode($event->name . ' - ' . route('events.show', $event->slug)) }}" target="_blank" class="btn btn-sm btn-outline-success rounded-circle">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                                {{-- <a href="mailto:?subject={{ urlencode($event->name) }}&body={{ urlencode("Check out this event: " . $event->name . "\n" . route('events.show', $event->slug)) }}" class="btn btn-sm btn-outline-secondary rounded-circle">
                                    <i class="fas fa-envelope"></i>
                                </a> --}}
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Host Card -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Event Host</h5>
                        <div class="d-flex align-items-center">
                            <img src="{{ getMedia($event->organizer->avatar) }}" class="rounded-circle me-3" style="width: 64px; height: 64px; object-fit: cover;">
                            <div>
                                <h6 class="mb-1">{{ $event->organizer->name }}</h6>
                                <a href="{{ url('profile/' . $event->organizer->username) }}" class="btn btn-sm btn-outline-primary mt-2">
                                    View Profile
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Related Events (if applicable) -->
                <!-- You could add recommended events based on category here -->
            </div>
        </div>
    </div>
</div>

<!-- Modal for Going List -->
<div class="modal fade" id="goingModal" tabindex="-1" aria-labelledby="goingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="goingModalLabel">People Going</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    @foreach($participants as $participant)
                        <div class="col-md-4 col-6">
                            <div class="d-flex align-items-center">
                                <img src="{{ getMedia($participant->user->avatar) }}" class="rounded-circle me-2" style="width: 48px; height: 48px; object-fit: cover;">
                                <div>
                                    <div>{{ $participant->user->name }}</div>
                                    @if($participant->is_host)
                                        <span class="badge bg-primary">Host</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Interested List -->
<div class="modal fade" id="interestedModal" tabindex="-1" aria-labelledby="interestedModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="interestedModalLabel">People Interested</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    @foreach($interestedUsers as $interested)
                        <div class="col-md-4 col-6">
                            <div class="d-flex align-items-center">
                                <img src="{{ getMedia($interested->user->avatar) }}" class="rounded-circle me-2" style="width: 48px; height: 48px; object-fit: cover;">
                                <div>{{ $interested->user->name }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Going button click
        $('.going-button').click(function() {
            var eventId = $(this).data('event-id');
            var isGoing = $(this).hasClass('btn-success');
            
            // Call the API to toggle going status
            axios.post(`${base_url}/webapi/event/go-to-event`, {
                event_id: eventId
            })
            .then(function(response) {
                // Toggle button state
                if (response.data.status === 'going') {
                    $('.going-button').removeClass('btn-primary').addClass('btn-success');
                    $('.going-button i').removeClass('fa-calendar-check').addClass('fa-check-circle');
                    $('.going-button').html('<i class="fas fa-check-circle me-2"></i>I\'m Going');
                    
                    // Show success message
                    myAlert.fire({
                        icon: 'success',
                        title: 'You\'re going!',
                        text: response.data.message
                    });
                } else {
                    $('.going-button').removeClass('btn-success').addClass('btn-primary');
                    $('.going-button i').removeClass('fa-check-circle').addClass('fa-calendar-check');
                    $('.going-button').html('<i class="fas fa-calendar-check me-2"></i>Going');
                    
                    // Show success message
                    myAlert.fire({
                        icon: 'success',
                        title: 'RSVP removed',
                        text: response.data.message
                    });
                }
                
                // Refresh the page to update counts
                setTimeout(function() {
                    location.reload();
                }, 1500);
            })
            .catch(function(error) {
                console.error(error);
                myAlert.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            });
        });
        
        // Interest button click
        $('.interest-button').click(function() {
            var eventId = $(this).data('event-id');
            var isInterested = $(this).hasClass('btn-warning');
            
            // Call the API to toggle interest status
            axios.post(`${base_url}/webapi/event/show-interest`, {
                event_id: eventId
            })
            .then(function(response) {
                // Toggle button state
                if (response.data.status === 'interested') {
                    $('.interest-button').removeClass('btn-outline-warning').addClass('btn-warning');
                    $('.interest-button').html('<i class="fas fa-star me-2"></i>Interested');
                    
                    // Show success message
                    myAlert.fire({
                        icon: 'success',
                        title: 'You\'re interested!',
                        text: response.data.message
                    });
                } else {
                    $('.interest-button').removeClass('btn-warning').addClass('btn-outline-warning');
                    $('.interest-button').html('<i class="fas fa-star me-2"></i>Interested');
                    
                    // Show success message
                    myAlert.fire({
                        icon: 'success',
                        title: 'Interest removed',
                        text: response.data.message
                    });
                }
                
                // Refresh the page to update counts
                setTimeout(function() {
                    location.reload();
                }, 1500);
            })
            .catch(function(error) {
                console.error(error);
                myAlert.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred. Please try again.'
                });
            });
        });
    });
    
    // Share event function
    function shareEvent() {
        if (navigator.share) {
            navigator.share({
                title: '{{ $event->name }}',
                text: 'Check out this event: {{ $event->name }}',
                url: window.location.href,
            })
            .then(() => console.log('Successful share'))
            .catch((error) => console.log('Error sharing', error));
        } else {
            // Fallback for browsers that don't support Web Share API
            $('#shareDropdown').dropdown('toggle');
        }
    }
</script>
@endpush
@endsection
