@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Student Dashboard')

@section('left_sidebar')
@include('front_end.pages.courses.courses_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('courses.index') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Student Dashboard</h4>
                                    <p class="mb-0 text-white">Manage your learning journey</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Dashboard Stats -->
        <div class="row mb-5">
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-graduation-cap fa-3x text-primary opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $enrollments->count() }}</h2>
                        <p class="text-muted mb-0">Enrolled Courses</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-spinner fa-3x text-warning opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $inProgressCourses->count() }}</h2>
                        <p class="text-muted mb-0">In Progress</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-check-circle fa-3x text-success opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $completedCourses->count() }}</h2>
                        <p class="text-muted mb-0">Completed Courses</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-heart fa-3x text-danger opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $wishlist->count() }}</h2>
                        <p class="text-muted mb-0">Wishlist</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Continue Learning Section -->
        @if($inProgressCourses->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Continue Learning</h3>
                    <a href="{{ route('student.myCourses') }}" class="btn btn-sm btn-outline-primary">View All Courses</a>
                </div>
                <div class="row g-4">
                    @foreach($inProgressCourses as $enrollment)
                    <div class="col-md-6 col-lg-3">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                            <a href="{{ route('courses.learn', $enrollment->course->slug) }}">
                                <img src="{{ $enrollment->course->thumbnail ? asset('storage/' . $enrollment->course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                     class="card-img-top" alt="{{ $enrollment->course->title }}">
                            </a>
                            <div class="card-body p-4">
                                <h5 class="card-title mb-3">
                                    <a href="{{ route('courses.learn', $enrollment->course->slug) }}" class="text-decoration-none text-dark">{{ $enrollment->course->title }}</a>
                                </h5>
                                <div class="progress mb-3" style="height: 6px;">
                                    <div class="progress-bar" role="progressbar" style="width: {{ $enrollment->getProgressPercentage() }}%" aria-valuenow="{{ $enrollment->getProgressPercentage() }}" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center text-muted small">
                                    <span>{{ $enrollment->getProgressPercentage() }}% complete</span>
                                    <span>Last accessed: {{ optional($enrollment->last_accessed_at)->diffForHumans() ?? 'N/A' }}</span>
                                </div>
                            </div>
                            <div class="card-footer bg-white border-top-0 p-4">
                                <a href="{{ route('courses.learn', $enrollment->course->slug) }}" class="btn btn-primary w-100">
                                    <i class="fas fa-play-circle me-2"></i>Continue Learning
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Recently Enrolled Courses -->
        @if($recentlyEnrolledCourses->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Recently Enrolled</h3>
                </div>
                <div class="row g-4">
                    @foreach($recentlyEnrolledCourses as $enrollment)
                    <div class="col-md-6 col-lg-3">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                            <a href="{{ route('courses.learn', $enrollment->course->slug) }}">
                                <img src="{{ $enrollment->course->thumbnail ? asset('storage/' . $enrollment->course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                     class="card-img-top" alt="{{ $enrollment->course->title }}">
                            </a>
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="badge bg-{{ $enrollment->course->level == 'beginner' ? 'success' : ($enrollment->course->level == 'intermediate' ? 'warning' : 'danger') }}">
                                        {{ ucfirst($enrollment->course->level) }}
                                    </span>
                                    <small class="text-muted">Enrolled {{ $enrollment->created_at->diffForHumans() }}</small>
                                </div>
                                <h5 class="card-title mb-2">
                                    <a href="{{ route('courses.learn', $enrollment->course->slug) }}" class="text-decoration-none text-dark">{{ $enrollment->course->title }}</a>
                                </h5>
                                <p class="text-muted small mb-0">
                                    <i class="fas fa-user-tie me-1"></i> {{ $enrollment->course->instructor->name ?? 'Unknown Instructor' }}
                                </p>
                            </div>
                            <div class="card-footer bg-white border-top-0 p-4">
                                <a href="{{ route('courses.learn', $enrollment->course->slug) }}" class="btn btn-primary w-100">
                                    <i class="fas fa-play-circle me-2"></i>Start Learning
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Wishlist Section -->
        @if($wishlist->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Your Wishlist</h3>
                    <a href="{{ route('student.wishlist') }}" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($wishlist as $item)
                    <div class="col-md-6 col-lg-3">
                        <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                            <a href="{{ route('courses.show', $item->course->slug) }}">
                                <img src="{{ $item->course->thumbnail ? asset('storage/' . $item->course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                     class="card-img-top" alt="{{ $item->course->title }}">
                            </a>
                            @if($item->course->discount_price && $item->course->discount_ends_at > now())
                            <div class="position-absolute top-0 end-0 bg-danger text-white px-2 py-1 m-2 rounded">
                                {{ round((($item->course->price - $item->course->discount_price) / $item->course->price) * 100) }}% OFF
                            </div>
                            @endif
                            <div class="card-body p-4">
                                <h5 class="card-title mb-2">
                                    <a href="{{ route('courses.show', $item->course->slug) }}" class="text-decoration-none text-dark">{{ $item->course->title }}</a>
                                </h5>
                                <p class="text-muted small mb-3">
                                    <i class="fas fa-user-tie me-1"></i> {{ $item->course->instructor->name ?? 'Unknown Instructor' }}
                                </p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        @if($item->course->price == 0)
                                        <span class="h5 text-success fw-bold">Free</span>
                                        @elseif($item->course->discount_price && $item->course->discount_ends_at > now())
                                        <span class="h5 fw-bold">${{ number_format($item->course->discount_price, 2) }}</span>
                                        <del class="text-muted ms-2">${{ number_format($item->course->price, 2) }}</del>
                                        @else
                                        <span class="h5 fw-bold">${{ number_format($item->course->price, 2) }}</span>
                                        @endif
                                    </div>
                                    <form action="{{ route('student.removeFromWishlist', $item->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                            <div class="card-footer bg-white border-top-0 p-4">
                                <a href="{{ route('courses.enroll', $item->course->slug) }}" class="btn btn-primary w-100">
                                    @if($item->course->price == 0)
                                    <i class="fas fa-unlock-alt me-2"></i>Enroll for Free
                                    @else
                                    <i class="fas fa-shopping-cart me-2"></i>Enroll Now
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Recommended Courses Section -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Recommended for You</h3>
                    <a href="{{ route('courses.index') }}" class="btn btn-sm btn-outline-primary">Browse All Courses</a>
                </div>
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-0">
                        <div class="p-4 bg-light rounded-top">
                            <h5 class="mb-0">Based on your interests and enrollments</h5>
                        </div>
                        <!-- This would be dynamically populated with recommended courses based on user's history -->
                        <div class="p-5 text-center">
                            <i class="fas fa-magic fa-3x text-muted mb-3"></i>
                            <h5>Personalized Recommendations Coming Soon</h5>
                            <p class="text-muted mb-4">We're working on analyzing your learning patterns to provide better course recommendations.</p>
                            <a href="{{ route('courses.index') }}" class="btn btn-primary">Browse All Courses</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Course rating initialization
        $('.course-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection