@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Edit Course - ' . $course->title)

@section('left_sidebar')
@include('front_end.pages.courses.instructor_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('instructor.courses') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Edit Course</h4>
                                    <p class="mb-0 text-white">{{ $course->title }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <form action="{{ route('instructor.courses.togglePublish', $course->id) }}" method="POST" class="me-2">
                                    @csrf
                                    <button type="submit" class="btn btn-{{ $course->is_published ? 'warning' : 'success' }}">
                                        <i class="fas {{ $course->is_published ? 'fa-eye-slash' : 'fa-eye' }} me-2"></i>
                                        {{ $course->is_published ? 'Unpublish' : 'Publish' }}
                                    </button>
                                </form>
                                <a href="{{ route('courses.show', $course->slug) }}" class="btn btn-primary" target="_blank">
                                    <i class="fas fa-external-link-alt me-2"></i>Preview
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Course Editor Tabs -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-0">
                        <nav class="nav nav-pills nav-justified" id="courseEditorTab" role="tablist">
                            <button class="nav-link active rounded-0 border-0 py-3" id="details-tab" data-bs-toggle="pill" data-bs-target="#details" type="button" role="tab" aria-controls="details" aria-selected="true">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-info-circle fa-lg mb-2"></i>
                                    <span class="fw-semibold">Basic Details</span>
                                    <small class="text-muted">Course information</small>
                                </div>
                            </button>
                            <button class="nav-link rounded-0 border-0 py-3" id="curriculum-tab" data-bs-toggle="pill" data-bs-target="#curriculum" type="button" role="tab" aria-controls="curriculum" aria-selected="false">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-list-alt fa-lg mb-2"></i>
                                    <span class="fw-semibold">Curriculum</span>
                                    <small class="text-muted">Sections & lessons</small>
                                </div>
                            </button>
                            <button class="nav-link rounded-0 border-0 py-3" id="pricing-tab" data-bs-toggle="pill" data-bs-target="#pricing" type="button" role="tab" aria-controls="pricing" aria-selected="false">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-dollar-sign fa-lg mb-2"></i>
                                    <span class="fw-semibold">Pricing</span>
                                    <small class="text-muted">Price & coupons</small>
                                </div>
                            </button>
                            <button class="nav-link rounded-0 border-0 py-3" id="media-tab" data-bs-toggle="pill" data-bs-target="#media" type="button" role="tab" aria-controls="media" aria-selected="false">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-photo-video fa-lg mb-2"></i>
                                    <span class="fw-semibold">Media</span>
                                    <small class="text-muted">Images & videos</small>
                                </div>
                            </button>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-content" id="courseEditorTabContent">
            <!-- Basic Details Tab -->
            <div class="tab-pane fade show active" id="details" role="tabpanel" aria-labelledby="details-tab">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light border-0">
                                <div class="d-flex align-items-center">
                                    <div class="bg-primary bg-opacity-10 rounded-circle p-2 me-3">
                                        <i class="fas fa-info-circle text-primary"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Course Information</h5>
                                        <small class="text-muted">Basic details about your course</small>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-4">
                                <form action="{{ route('instructor.courses.update', $course->id) }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="mb-4">
                                        <label for="title" class="form-label fw-semibold">Course Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control form-control-lg @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title', $course->title) }}" required>
                                        @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <label for="slug" class="form-label fw-semibold">URL Slug</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light">{{ url('/courses/') }}/</span>
                                            <input type="text" class="form-control @error('slug') is-invalid @enderror" id="slug" name="slug" value="{{ old('slug', $course->slug) }}" readonly>
                                        </div>
                                        <div class="form-text">This is automatically generated from your title.</div>
                                        @error('slug')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <label for="category_id" class="form-label fw-semibold">Category <span class="text-danger">*</span></label>
                                        <select class="form-select form-select-lg @error('category_id') is-invalid @enderror" id="category_id" name="category_id" required>
                                            <option value="">Select Category</option>
                                            @foreach($categories as $category)
                                            <option value="{{ $category->id }}" {{ old('category_id', $course->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <label for="description" class="form-label fw-semibold">Description <span class="text-danger">*</span></label>
                                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="6" required>{{ old('description', $course->description) }}</textarea>
                                        @error('description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label for="level" class="form-label fw-semibold">Level <span class="text-danger">*</span></label>
                                            <select class="form-select @error('level') is-invalid @enderror" id="level" name="level" required>
                                                <option value="beginner" {{ old('level', $course->level) == 'beginner' ? 'selected' : '' }}>Beginner</option>
                                                <option value="intermediate" {{ old('level', $course->level) == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                                                <option value="advanced" {{ old('level', $course->level) == 'advanced' ? 'selected' : '' }}>Advanced</option>
                                            </select>
                                            @error('level')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="language" class="form-label fw-semibold">Language <span class="text-danger">*</span></label>
                                            <select class="form-select @error('language') is-invalid @enderror" id="language" name="language" required>
                                                <option value="English" {{ old('language', $course->language) == 'English' ? 'selected' : '' }}>English</option>
                                                <option value="Spanish" {{ old('language', $course->language) == 'Spanish' ? 'selected' : '' }}>Spanish</option>
                                                <option value="French" {{ old('language', $course->language) == 'French' ? 'selected' : '' }}>French</option>
                                                <option value="German" {{ old('language', $course->language) == 'German' ? 'selected' : '' }}>German</option>
                                                <option value="Chinese" {{ old('language', $course->language) == 'Chinese' ? 'selected' : '' }}>Chinese</option>
                                                <option value="Japanese" {{ old('language', $course->language) == 'Japanese' ? 'selected' : '' }}>Japanese</option>
                                                <option value="Hindi" {{ old('language', $course->language) == 'Hindi' ? 'selected' : '' }}>Hindi</option>
                                                <option value="Arabic" {{ old('language', $course->language) == 'Arabic' ? 'selected' : '' }}>Arabic</option>
                                                <option value="Portuguese" {{ old('language', $course->language) == 'Portuguese' ? 'selected' : '' }}>Portuguese</option>
                                                <option value="Russian" {{ old('language', $course->language) == 'Russian' ? 'selected' : '' }}>Russian</option>
                                            </select>
                                            @error('language')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <label for="what_you_will_learn" class="form-label fw-semibold">What You Will Learn</label>
                                        <textarea class="form-control @error('what_you_will_learn') is-invalid @enderror" id="what_you_will_learn" name="what_you_will_learn" rows="6" placeholder="Enter each point on a new line">{{ old('what_you_will_learn', $course->what_you_will_learn) }}</textarea>
                                        <div class="form-text">Enter each learning point on a new line. These will be displayed as bullet points.</div>
                                        @error('what_you_will_learn')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <label for="requirements" class="form-label fw-semibold">Requirements</label>
                                        <textarea class="form-control @error('requirements') is-invalid @enderror" id="requirements" name="requirements" rows="4" placeholder="Enter each requirement on a new line">{{ old('requirements', $course->requirements) }}</textarea>
                                        <div class="form-text">Enter each requirement on a new line.</div>
                                        @error('requirements')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="mb-4">
                                        <label for="target_audience" class="form-label fw-semibold">Target Audience</label>
                                        <textarea class="form-control @error('target_audience') is-invalid @enderror" id="target_audience" name="target_audience" rows="4" placeholder="Enter each audience type on a new line">{{ old('target_audience', $course->target_audience) }}</textarea>
                                        <div class="form-text">Enter each audience type on a new line.</div>
                                        @error('target_audience')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fas fa-save me-2"></i>Save Course Details
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light border-0">
                                <h6 class="mb-0">
                                    <i class="fas fa-lightbulb text-warning me-2"></i>
                                    Tips for Success
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Create a compelling title</h6>
                                    <p class="small text-muted mb-0">Your course title should clearly state what students will learn and be engaging.</p>
                                </div>
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Write a detailed description</h6>
                                    <p class="small text-muted mb-0">Include what students will learn, prerequisites, and course structure.</p>
                                </div>
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Choose the right category</h6>
                                    <p class="small text-muted mb-0">Select the most relevant category to help students find your course.</p>
                                </div>
                                <div class="mb-0">
                                    <h6 class="fw-semibold text-primary">Define learning outcomes</h6>
                                    <p class="small text-muted mb-0">Clearly state what students will be able to do after completing your course.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Curriculum Tab -->
            <div class="tab-pane fade" id="curriculum" role="tabpanel" aria-labelledby="curriculum-tab">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-light border-0">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="bg-success bg-opacity-10 rounded-circle p-2 me-3">
                                    <i class="fas fa-list-alt text-success"></i>
                                </div>
                                <div>
                                    <h5 class="mb-0">Course Curriculum</h5>
                                    <small class="text-muted">Organize your course content into sections and lessons</small>
                                </div>
                            </div>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSectionModal">
                                <i class="fas fa-plus-circle me-2"></i>Add Section
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        @if($course->sections->count() > 0)
                        <div class="curriculum-builder" id="curriculumSortable">
                            @foreach($course->sections as $section)
                            <div class="card mb-4 section-card border-start border-primary border-3" data-section-id="{{ $section->id }}">
                                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                    <h6 class="mb-0 fw-bold">
                                        <i class="fas fa-grip-vertical me-2 text-muted cursor-move section-handle"></i>
                                        <i class="fas fa-folder-open text-primary me-2"></i>
                                        {{ $section->title }}
                                    </h6>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editSectionModal{{ $section->id }}">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <a href="{{ route('instructor.courses.createLesson', ['courseId' => $course->id, 'sectionId' => $section->id]) }}" class="btn btn-sm btn-outline-success">
                                            <i class="fas fa-plus"></i> Lesson
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteSectionModal{{ $section->id }}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="card-body p-0">
                                    @if($section->lessons->count() > 0)
                                    <ul class="list-group list-group-flush lesson-sortable" data-section-id="{{ $section->id }}">
                                        @foreach($section->lessons as $lesson)
                                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 border-bottom py-3" data-lesson-id="{{ $lesson->id }}">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-grip-vertical me-3 text-muted cursor-move lesson-handle"></i>
                                                <div class="me-3">
                                                    <div class="bg-{{ $lesson->video_url ? 'danger' : 'info' }} bg-opacity-10 rounded-circle p-2">
                                                        <i class="fas {{ $lesson->video_url ? 'fa-play-circle text-danger' : 'fa-file-alt text-info' }}"></i>
                                                    </div>
                                                </div>
                                                <div>
                                                    <div class="d-flex align-items-center mb-1">
                                                        <span class="fw-semibold">{{ $lesson->title }}</span>
                                                        @if(!$lesson->is_published)
                                                        <span class="badge bg-warning ms-2">Draft</span>
                                                        @endif
                                                        @if($lesson->is_free)
                                                        <span class="badge bg-success ms-2">Free</span>
                                                        @endif
                                                    </div>
                                                    <small class="text-muted">
                                                        <i class="fas fa-clock me-1"></i>{{ $lesson->duration }} min
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('instructor.courses.editLesson', ['courseId' => $course->id, 'lessonId' => $lesson->id]) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteLessonModal{{ $lesson->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    @else
                                    <div class="text-center py-5">
                                        <div class="mb-3">
                                            <i class="fas fa-video fa-3x text-muted"></i>
                                        </div>
                                        <h6 class="text-muted mb-2">No lessons in this section yet</h6>
                                        <p class="text-muted small mb-3">Add your first lesson to get started</p>
                                        <a href="{{ route('instructor.courses.createLesson', ['courseId' => $course->id, 'sectionId' => $section->id]) }}" class="btn btn-outline-primary">
                                            <i class="fas fa-plus me-2"></i>Add Lesson
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Edit Section Modal -->
                            <div class="modal fade" id="editSectionModal{{ $section->id }}" tabindex="-1" aria-labelledby="editSectionModal{{ $section->id }}Label" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form action="{{ route('instructor.courses.updateSection', $section->id) }}" method="POST">
                                            @csrf
                                            @method('PUT')
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="editSectionModal{{ $section->id }}Label">Edit Section</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label for="title" class="form-label">Section Title</label>
                                                    <input type="text" class="form-control" id="title" name="title" value="{{ $section->title }}" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="description" class="form-label">Description (Optional)</label>
                                                    <textarea class="form-control" id="description" name="description" rows="3">{{ $section->description }}</textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-primary">Save Changes</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- Delete Section Modal -->
                            <div class="modal fade" id="deleteSectionModal{{ $section->id }}" tabindex="-1" aria-labelledby="deleteSectionModal{{ $section->id }}Label" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form action="{{ route('instructor.courses.deleteSection', $section->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteSectionModal{{ $section->id }}Label">Delete Section</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Are you sure you want to delete the section "{{ $section->title }}"?</p>
                                                @if($section->lessons->count() > 0)
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                    This section contains {{ $section->lessons->count() }} lessons. You need to delete them first.
                                                </div>
                                                @endif
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-danger" {{ $section->lessons->count() > 0 ? 'disabled' : '' }}>Delete Section</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            @foreach($section->lessons as $lesson)
                            <!-- Delete Lesson Modal -->
                            <div class="modal fade" id="deleteLessonModal{{ $lesson->id }}" tabindex="-1" aria-labelledby="deleteLessonModal{{ $lesson->id }}Label" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form action="{{ route('instructor.courses.deleteLesson', ['courseId' => $course->id, 'lessonId' => $lesson->id]) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="deleteLessonModal{{ $lesson->id }}Label">Delete Lesson</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Are you sure you want to delete the lesson "{{ $lesson->title }}"?</p>
                                                <div class="alert alert-warning">
                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                    This action cannot be undone. All lesson content and student progress for this lesson will be deleted.
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-danger">Delete Lesson</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                            @endforeach
                        </div>
                        @else
                        <div class="text-center py-5">
                            <i class="fas fa-book-open fa-3x text-muted mb-3"></i>
                            <h5>No Sections Yet</h5>
                            <p class="text-muted mb-4">Start building your course by adding sections and lessons.</p>
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSectionModal">
                                <i class="fas fa-plus-circle me-2"></i>Add Your First Section
                            </button>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Pricing Tab -->
            <div class="tab-pane fade" id="pricing" role="tabpanel" aria-labelledby="pricing-tab">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light border-0">
                                <div class="d-flex align-items-center">
                                    <div class="bg-warning bg-opacity-10 rounded-circle p-2 me-3">
                                        <i class="fas fa-dollar-sign text-warning"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Course Pricing</h5>
                                        <small class="text-muted">Set your course price and discount options</small>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-4">
                                <form action="{{ route('instructor.courses.update', $course->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label for="price" class="form-label fw-semibold">Regular Price ($) <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">$</span>
                                                <input type="number" class="form-control form-control-lg @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price', $course->price) }}" min="0" step="0.01" required>
                                            </div>
                                            <div class="form-text">Set to 0 for a free course.</div>
                                            @error('price')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="discount_price" class="form-label fw-semibold">Discount Price ($)</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">$</span>
                                                <input type="number" class="form-control form-control-lg @error('discount_price') is-invalid @enderror" id="discount_price" name="discount_price" value="{{ old('discount_price', $course->discount_price) }}" min="0" step="0.01">
                                            </div>
                                            <div class="form-text">Optional. Must be less than regular price.</div>
                                            @error('discount_price')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <label for="discount_ends_at" class="form-label fw-semibold">Discount End Date</label>
                                            <input type="date" class="form-control form-control-lg @error('discount_ends_at') is-invalid @enderror" id="discount_ends_at" name="discount_ends_at" value="{{ old('discount_ends_at', $course->discount_ends_at ? date('Y-m-d', strtotime($course->discount_ends_at)) : '') }}">
                                            <div class="form-text">When the discount will expire.</div>
                                            @error('discount_ends_at')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fas fa-save me-2"></i>Save Pricing
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light border-0">
                                <h6 class="mb-0">
                                    <i class="fas fa-chart-line text-info me-2"></i>
                                    Pricing Tips
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Research competitor pricing</h6>
                                    <p class="small text-muted mb-0">Look at similar courses to price yours competitively.</p>
                                </div>
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Consider your content value</h6>
                                    <p class="small text-muted mb-0">Price should reflect the quality and depth of your course.</p>
                                </div>
                                <div class="mb-3">
                                    <h6 class="fw-semibold text-primary">Use limited-time discounts</h6>
                                    <p class="small text-muted mb-0">Create urgency with temporary discount offers.</p>
                                </div>
                                <div class="mb-0">
                                    <h6 class="fw-semibold text-primary">Start with free previews</h6>
                                    <p class="small text-muted mb-0">Mark some lessons as free to attract students.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Coupons Section -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-light border-0">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="bg-success bg-opacity-10 rounded-circle p-2 me-3">
                                    <i class="fas fa-tags text-success"></i>
                                </div>
                                <div>
                                    <h5 class="mb-0">Course Coupons</h5>
                                    <small class="text-muted">Create discount coupons for your course</small>
                                </div>
                            </div>
                            <a href="{{ route('instructor.courses.coupons', $course->id) }}" class="btn btn-primary">
                                <i class="fas fa-tags me-2"></i>Manage Coupons
                            </a>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        @if($course->coupons && $course->coupons->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Code</th>
                                        <th>Discount</th>
                                        <th>Usage / Limit</th>
                                        <th>Expires</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($course->coupons->take(5) as $coupon)
                                    <tr>
                                        <td><span class="badge bg-dark">{{ $coupon->code }}</span></td>
                                        <td>
                                            @if($coupon->discount_type == 'percentage')
                                            <span class="text-success fw-semibold">{{ $coupon->discount_amount }}%</span>
                                            @else
                                            <span class="text-success fw-semibold">${{ number_format($coupon->discount_amount, 2) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="progress me-2" style="width: 60px; height: 6px;">
                                                    <div class="progress-bar" role="progressbar" style="width: {{ $coupon->usage_limit ? round(($coupon->usage_count / $coupon->usage_limit) * 100) : 0 }}%"></div>
                                                </div>
                                                <span class="small">{{ $coupon->usage_count }} / {{ $coupon->usage_limit ?? '∞' }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            @if($coupon->expires_at)
                                            <span class="small">{{ date('M d, Y', strtotime($coupon->expires_at)) }}</span>
                                            @else
                                            <span class="text-muted small">Never</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $coupon->is_active ? 'success' : 'secondary' }}">
                                                {{ $coupon->is_active ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @if($course->coupons->count() > 5)
                        <div class="text-center mt-3">
                            <a href="{{ route('instructor.courses.coupons', $course->id) }}" class="btn btn-outline-primary">View All Coupons</a>
                        </div>
                        @endif
                        @else
                        <div class="text-center py-5">
                            <div class="mb-3">
                                <i class="fas fa-tags fa-3x text-muted"></i>
                            </div>
                            <h5>No Coupons Yet</h5>
                            <p class="text-muted mb-4">Create coupons to offer special discounts to your students.</p>
                            <a href="{{ route('instructor.courses.coupons', $course->id) }}" class="btn btn-primary">
                                <i class="fas fa-plus-circle me-2"></i>Create Your First Coupon
                            </a>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Media Tab -->
            <div class="tab-pane fade" id="media" role="tabpanel" aria-labelledby="media-tab">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-light border-0">
                        <div class="d-flex align-items-center">
                            <div class="bg-info bg-opacity-10 rounded-circle p-2 me-3">
                                <i class="fas fa-photo-video text-info"></i>
                            </div>
                            <div>
                                <h5 class="mb-0">Course Media</h5>
                                <small class="text-muted">Upload your course thumbnail and preview video</small>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <form action="{{ route('instructor.courses.update', $course->id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-header bg-light border-0">
                                            <h6 class="mb-0">
                                                <i class="fas fa-image text-primary me-2"></i>
                                                Course Thumbnail
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                @if($course->thumbnail)
                                                <div class="text-center">
                                                    <img src="{{ asset('storage/' . $course->thumbnail) }}" alt="Course thumbnail" class="img-fluid rounded shadow-sm mb-3" style="max-width: 100%; max-height: 200px;">
                                                </div>
                                                @else
                                                <div class="text-center py-4">
                                                    <i class="fas fa-image fa-3x text-muted mb-3"></i>
                                                    <p class="text-muted">No thumbnail uploaded yet</p>
                                                </div>
                                                @endif
                                            </div>
                                            <div class="input-group">
                                                <input type="file" class="form-control @error('thumbnail') is-invalid @enderror" id="thumbnail" name="thumbnail" accept="image/*">
                                                <label class="input-group-text" for="thumbnail">
                                                    <i class="fas fa-upload me-2"></i>Upload
                                                </label>
                                            </div>
                                            <div class="form-text">Recommended size: 1280x720 pixels (16:9 ratio)</div>
                                            @error('thumbnail')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-header bg-light border-0">
                                            <h6 class="mb-0">
                                                <i class="fas fa-video text-danger me-2"></i>
                                                Preview Video
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="preview_video" class="form-label fw-semibold">Preview Video URL</label>
                                                <input type="url" class="form-control @error('preview_video') is-invalid @enderror" id="preview_video" name="preview_video" value="{{ old('preview_video', $course->preview_video) }}" placeholder="https://...">
                                                <div class="form-text">YouTube, Vimeo, or other embedded video URL.</div>
                                                @error('preview_video')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            
                                            @if($course->preview_video)
                                            <div class="mt-3">
                                                <label class="form-label fw-semibold">Current Preview:</label>
                                                <div class="ratio ratio-16x9">
                                                    <iframe src="{{ $course->preview_video }}" title="Course Preview" allowfullscreen class="rounded"></iframe>
                                                </div>
                                            </div>
                                            @else
                                            <div class="text-center py-4">
                                                <i class="fas fa-video fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No preview video added yet</p>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-save me-2"></i>Save Media
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Section Modal -->
<div class="modal fade" id="addSectionModal" tabindex="-1" aria-labelledby="addSectionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('instructor.courses.addSection', $course->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addSectionModalLabel">Add New Section</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="title" class="form-label">Section Title</label>
                        <input type="text" class="form-control" id="section_title" name="title" required>
                        <div class="form-text">E.g., "Introduction", "Advanced Techniques", etc.</div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description (Optional)</label>
                        <textarea class="form-control" id="section_description" name="description" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Section</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.14.0/Sortable.min.js"></script>
<style>
    .nav-pills .nav-link {
        border-radius: 0;
        transition: all 0.3s ease;
        border-bottom: 3px solid transparent;
        background: transparent;
        color: #6c757d;
    }
    
    .nav-pills .nav-link:hover {
        background: #f8f9fa;
        color: #0d6efd;
        border-bottom-color: #0d6efd;
    }
    
    .nav-pills .nav-link.active {
        background: #0d6efd;
        color: #fff;
        border-bottom-color: #0d6efd;
    }
    
    .cursor-move {
        cursor: move;
    }
    
    .section-card {
        transition: all 0.3s ease;
    }
    
    .section-card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
    }
    
    .lesson-sortable li {
        transition: all 0.3s ease;
    }
    
    .lesson-sortable li:hover {
        background: #f8f9fa;
    }
    
    .form-control:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .form-select:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
    
    .btn-primary {
        background: linear-gradient(135deg, #0d6efd 0%, #0056b3 100%);
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, #0056b3 0%, #004085 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    
    .card {
        transition: all 0.3s ease;
    }
    
    .card:hover {
        transform: translateY(-2px);
    }
    
    .progress-bar {
        background: linear-gradient(90deg, #28a745 0%, #20c997 100%);
    }
    
    .badge {
        font-size: 0.75em;
        font-weight: 500;
    }
    
    .form-control-lg {
        font-size: 1.1rem;
        padding: 0.75rem 1rem;
    }
    
    .form-select-lg {
        font-size: 1.1rem;
        padding: 0.75rem 1rem;
    }
</style>
<script>
    $(document).ready(function() {
        // Auto-generate slug from title
        $('#title').on('blur', function() {
            const title = $(this).val();
            if (title) {
                const slug = title.toLowerCase()
                    .replace(/[^\w ]+/g, '')
                    .replace(/ +/g, '-');
                $('#slug').val(slug);
            }
        });
        
        // Thumbnail preview when uploading new image
        $('#thumbnail').on('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // If there's an existing thumbnail, replace it; otherwise create a new image element
                    if ($('.img-thumbnail').length) {
                        $('.img-thumbnail').attr('src', e.target.result);
                    } else {
                        $('.alert-warning').replaceWith('<img src="' + e.target.result + '" alt="Course thumbnail preview" class="img-thumbnail mb-3" style="max-width: 300px;">');
                    }
                }
                reader.readAsDataURL(file);
            }
        });
        
        // Initialize sortable for curriculum sections
        if ($('#curriculumSortable').length) {
            const sectionSortable = new Sortable(document.getElementById('curriculumSortable'), {
                handle: '.section-handle',
                animation: 150,
                ghostClass: 'border-primary',
                onEnd: function(evt) {
                    const sections = [];
                    $('.section-card').each(function() {
                        sections.push($(this).data('section-id'));
                    });
                    
                    // Send sorted sections order to server
                    $.ajax({
                        url: "{{ route('instructor.courses.reorderSections', $course->id) }}",
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            sections: sections
                        },
                        success: function(response) {
                            // Optional: show success message
                            console.log('Sections reordered successfully');
                        },
                        error: function(xhr) {
                            console.error('Error reordering sections', xhr);
                        }
                    });
                }
            });
        }
        
        // Initialize sortable for lessons within each section
        $('.lesson-sortable').each(function() {
            const sectionId = $(this).data('section-id');
            new Sortable(this, {
                handle: '.lesson-handle',
                animation: 150,
                ghostClass: 'border-primary',
                group: 'lessons',
                onEnd: function(evt) {
                    const lessons = [];
                    $(evt.to).find('li').each(function() {
                        lessons.push($(this).data('lesson-id'));
                    });
                    
                    // Send sorted lessons order to server
                    $.ajax({
                        url: "{{ url('instructor/courses/sections') }}/" + sectionId + "/reorder-lessons",
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            lessons: lessons
                        },
                        success: function(response) {
                            // Optional: show success message
                            console.log('Lessons reordered successfully');
                        },
                        error: function(xhr) {
                            console.error('Error reordering lessons', xhr);
                        }
                    });
                }
            });
        });
        
        // Switch tabs if URL contains hash
        let url = document.location.toString();
        if (url.match('#')) {
            $('.nav-tabs a[href="#' + url.split('#')[1] + '"]').tab('show');
        }
        
        // Change hash for page-reload
        $('.nav-tabs a').on('shown.bs.tab', function (e) {
            window.location.hash = e.target.hash;
        });
        
        // Confirm before delete
        $('.btn-outline-danger').on('click', function(e) {
            if (!confirm('Are you sure you want to delete this item? This action cannot be undone.')) {
                e.preventDefault();
                return false;
            }
        });
    });
</script>
@endpush
@endsection