@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Instructor Dashboard')

@section('left_sidebar')
@include('front_end.pages.courses.instructor_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('courses.index') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Instructor Dashboard</h4>
                                    <p class="mb-0 text-white">Manage your courses and track your performance</p>
                                </div>
                            </div>
                            <div>
                                <a href="{{ route('instructor.courses.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus-circle me-2"></i>Create New Course
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Dashboard Stats -->
        <div class="row mb-5">
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-book fa-3x text-primary opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $totalCourses }}</h2>
                        <p class="text-muted mb-0">Courses</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-users fa-3x text-success opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $totalStudents }}</h2>
                        <p class="text-muted mb-0">Students</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-star fa-3x text-warning opacity-75"></i>
                        </div>
                        <h2 class="mb-1">{{ $courses->avg('average_rating') ? number_format($courses->avg('average_rating'), 1) : 'N/A' }}</h2>
                        <p class="text-muted mb-0">Avg. Rating</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body">
                        <div class="mb-3">
                            <i class="fas fa-dollar-sign fa-3x text-danger opacity-75"></i>
                        </div>
                        <h2 class="mb-1">${{ number_format($totalRevenue, 2) }}</h2>
                        <p class="text-muted mb-0">Revenue</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Courses Section -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Your Courses</h3>
                    <a href="{{ route('instructor.courses') }}" class="btn btn-sm btn-outline-primary">Manage All Courses</a>
                </div>
                
                @if($courses->count() > 0)
                <div class="table-responsive overflow-visible">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Course</th>
                                <th>Category</th>
                                <th>Price</th>
                                <th>Status</th>
                                <th>Students</th>
                                <th>Rating</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($courses as $course)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $course->thumbnail ? asset('storage/' . $course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                             alt="{{ $course->title }}" class="rounded me-3" width="50" height="30">
                                        <a href="{{ route('instructor.courses.edit', $course->id) }}" class="text-decoration-none text-dark fw-medium">{{ $course->title }}</a>
                                    </div>
                                </td>
                                <td>{{ $course->category->name ?? 'Uncategorized' }}</td>
                                <td>
                                    @if($course->price == 0)
                                    <span class="text-success">Free</span>
                                    @elseif($course->discount_price && $course->discount_ends_at > now())
                                    <span>${{ number_format($course->discount_price, 2) }}</span>
                                    <del class="text-muted small">${{ number_format($course->price, 2) }}</del>
                                    @else
                                    <span>${{ number_format($course->price, 2) }}</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $course->is_published ? 'success' : 'warning' }}">
                                        {{ $course->is_published ? 'Published' : 'Draft' }}
                                    </span>
                                </td>
                                <td>{{ $course->total_students }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="text-warning me-1">
                                            <i class="fas fa-star small"></i>
                                        </div>
                                        <span>{{ number_format($course->average_rating, 1) }}</span>
                                        <span class="text-muted small ms-1">({{ $course->reviews_count ?? 0 }})</span>
                                    </div>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenuButton{{ $course->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton{{ $course->id }}">
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.edit', $course->id) }}"><i class="fas fa-edit me-2"></i>Edit</a></li>
                                            <li><a class="dropdown-item" href="{{ route('courses.show', $course->slug) }}"><i class="fas fa-eye me-2"></i>View</a></li>
                                            <li>
                                                <form action="{{ route('instructor.courses.togglePublish', $course->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item">
                                                        <i class="fas {{ $course->is_published ? 'fa-eye-slash' : 'fa-eye' }} me-2"></i>
                                                        {{ $course->is_published ? 'Unpublish' : 'Publish' }}
                                                    </button>
                                                </form>
                                            </li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.students', $course->id) }}"><i class="fas fa-users me-2"></i>Students</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.reviews', $course->id) }}"><i class="fas fa-star me-2"></i>Reviews</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.questions', $course->id) }}"><i class="fas fa-question-circle me-2"></i>Q&A</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.announcements', $course->id) }}"><i class="fas fa-bullhorn me-2"></i>Announcements</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.coupons', $course->id) }}"><i class="fas fa-tags me-2"></i>Coupons</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-5 text-center">
                        <i class="fas fa-book fa-3x text-muted mb-3"></i>
                        <h4>No Courses Yet</h4>
                        <p class="text-muted mb-4">You haven't created any courses yet. Start creating your first course now!</p>
                        <a href="{{ route('instructor.courses.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus-circle me-2"></i>Create Your First Course
                        </a>
                    </div>
                </div>
                @endif
        </div>

     
        
        <!-- Tips & Resources Section -->
        <div class="row">
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h4 class="mb-4">Tips for Course Success</h4>
                        <div class="row g-4">
                            <div class="col-md-4">
                                <div class="d-flex">
                                    <div class="me-3">
                                        <div class="rounded-circle bg-primary bg-opacity-10 p-3" style="width: 60px; height: 60px;">
                                            <i class="fas fa-video fa-2x text-primary"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5>Quality Content</h5>
                                        <p class="text-muted small mb-0">Create engaging videos and clear explanations to keep students engaged.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex">
                                    <div class="me-3">
                                        <div class="rounded-circle bg-success bg-opacity-10 p-3" style="width: 60px; height: 60px;">
                                            <i class="fas fa-comments fa-2x text-success"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5>Stay Engaged</h5>
                                        <p class="text-muted small mb-0">Respond promptly to student questions and provide helpful feedback.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex">
                                    <div class="me-3">
                                        <div class="rounded-circle bg-warning bg-opacity-10 p-3" style="width: 60px; height: 60px;">
                                            <i class="fas fa-bullhorn fa-2x text-warning"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <h5>Regular Updates</h5>
                                        <p class="text-muted small mb-0">Keep your course fresh with new content and regular announcements.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
{{-- Charts implementation can be added here when real data is available --}}
@endpush
@endsection