@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Create New Course')

@section('left_sidebar')
@include('front_end.pages.courses.instructor_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center">
                            <a href="{{ route('instructor.courses') }}" class="text-white me-3">
                                <i class="fas fa-arrow-left fa-lg"></i>
                            </a>
                            <div>
                                <h4 class="mb-0 text-white">Create New Course</h4>
                                <p class="mb-0 text-white">Fill in the basic details to get started</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="">
        <div class="row">
            <div class="col-lg-12 mx-auto">
                <div class="card border-0 shadow-sm mb-5">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-4">Course Information</h5>
                        
                        <form action="{{ route('instructor.courses.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="title" class="form-label">Course Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" placeholder="Enter a descriptive title" required>
                                <div class="form-text">Make it clear and compelling. What will students learn?</div>
                                @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="category_id" class="form-label">Category <span class="text-danger">*</span></label>
                                <select class="form-select @error('category_id') is-invalid @enderror" id="category_id" name="category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Course Description <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="6" placeholder="Describe what your course is about and what students will learn" required>{{ old('description') }}</textarea>
                                <div class="form-text">Provide a comprehensive overview of your course content.</div>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="level" class="form-label">Level <span class="text-danger">*</span></label>
                                    <select class="form-select @error('level') is-invalid @enderror" id="level" name="level" required>
                                        <option value="">Select Level</option>
                                        <option value="beginner" {{ old('level') == 'beginner' ? 'selected' : '' }}>Beginner</option>
                                        <option value="intermediate" {{ old('level') == 'intermediate' ? 'selected' : '' }}>Intermediate</option>
                                        <option value="advanced" {{ old('level') == 'advanced' ? 'selected' : '' }}>Advanced</option>
                                    </select>
                                    @error('level')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="language" class="form-label">Language <span class="text-danger">*</span></label>
                                    <select class="form-select @error('language') is-invalid @enderror" id="language" name="language" required>
                                        <option value="">Select Language</option>
                                        <option value="English" {{ old('language') == 'English' ? 'selected' : '' }}>English</option>
                                        <option value="Spanish" {{ old('language') == 'Spanish' ? 'selected' : '' }}>Spanish</option>
                                        <option value="French" {{ old('language') == 'French' ? 'selected' : '' }}>French</option>
                                        <option value="German" {{ old('language') == 'German' ? 'selected' : '' }}>German</option>
                                        <option value="Chinese" {{ old('language') == 'Chinese' ? 'selected' : '' }}>Chinese</option>
                                        <option value="Japanese" {{ old('language') == 'Japanese' ? 'selected' : '' }}>Japanese</option>
                                        <option value="Hindi" {{ old('language') == 'Hindi' ? 'selected' : '' }}>Hindi</option>
                                        <option value="Arabic" {{ old('language') == 'Arabic' ? 'selected' : '' }}>Arabic</option>
                                        <option value="Portuguese" {{ old('language') == 'Portuguese' ? 'selected' : '' }}>Portuguese</option>
                                        <option value="Russian" {{ old('language') == 'Russian' ? 'selected' : '' }}>Russian</option>
                                    </select>
                                    @error('language')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="price" class="form-label">Price ($) <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text">$</span>
                                        <input type="number" class="form-control @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price', 0) }}" min="0" step="0.01" required>
                                    </div>
                                    <div class="form-text">Set to 0 for a free course.</div>
                                    @error('price')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-4">
                                <label for="thumbnail" class="form-label">Course Thumbnail <span class="text-danger">*</span></label>
                                <input type="file" class="form-control @error('thumbnail') is-invalid @enderror" id="thumbnail" name="thumbnail" accept="image/*">
                                <div class="form-text">Recommended size: 1280x720 pixels (16:9 ratio)</div>
                                @error('thumbnail')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">Create Course</button>
                                <a href="{{ route('instructor.courses') }}" class="btn btn-outline-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-body p-4">
                        <h5 class="card-title mb-4">Course Creation Steps</h5>
                        
                        <div class="row">
                            <div class="col-md-4 text-center mb-4 mb-md-0">
                                <div class="rounded-circle bg-primary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                    <i class="fas fa-info-circle fa-2x text-primary"></i>
                                </div>
                                <h5>1. Basic Info</h5>
                                <p class="text-muted small">Create your course with basic information</p>
                            </div>
                            <div class="col-md-4 text-center mb-4 mb-md-0">
                                <div class="rounded-circle bg-secondary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                    <i class="fas fa-list fa-2x text-secondary"></i>
                                </div>
                                <h5>2. Curriculum</h5>
                                <p class="text-muted small">Add sections and lessons to your course</p>
                            </div>
                            <div class="col-md-4 text-center">
                                <div class="rounded-circle bg-secondary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                    <i class="fas fa-check-circle fa-2x text-secondary"></i>
                                </div>
                                <h5>3. Publish</h5>
                                <p class="text-muted small">Review and publish your course</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Preview image upload
        $('#thumbnail').on('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#thumbnailPreview').attr('src', e.target.result).removeClass('d-none');
                }
                reader.readAsDataURL(file);
            }
        });
    });
</script>
@endpush
@endsection