@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'My Courses - Instructor')

@section('left_sidebar')
@include('front_end.pages.courses.instructor_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-dark text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ route('instructor.dashboard') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">My Courses</h4>
                                    <p class="mb-0 text-white">Manage your {{ $courses->total() }} courses</p>
                                </div>
                            </div>
                            <div>
                                <a href="{{ route('instructor.courses.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus-circle me-2"></i>Create New Course
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-5">
        <!-- Search and Filter -->
        <div class="row mb-4">
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-text bg-white">
                        <i class="fas fa-search"></i>
                    </span>
                    <input type="text" class="form-control" id="searchCourse" placeholder="Search your courses">
                    <button class="btn btn-primary" type="button" id="searchButton">Search</button>
                </div>
            </div>
            <div class="col-md-4">
                <select class="form-select" id="filterCourses">
                    <option value="all">All Courses</option>
                    <option value="published">Published</option>
                    <option value="draft">Draft</option>
                    <option value="newest">Newest First</option>
                    <option value="oldest">Oldest First</option>
                    <option value="popular">Most Students</option>
                    <option value="rated">Highest Rated</option>
                </select>
            </div>
        </div>

        <!-- Course List -->
        @if($courses->count() > 0)
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body p-0">
                <div class="table-responsive overflow-visible">
                    <table class="table table-hover mb-0" id="courseTable">
                        <thead class="table-light">
                            <tr>
                                <th>Course</th>
                                <th>Category</th>
                                <th>Status</th>
                                <th>Students</th>
                                <th>Rating</th>
                                <th>Price</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($courses as $course)
                            <tr class="course-row" 
                                data-status="{{ $course->is_published ? 'published' : 'draft' }}"
                                data-students="{{ $course->total_students }}"
                                data-rating="{{ $course->average_rating }}"
                                data-created="{{ $course->created_at->timestamp }}">
                                <td>
                                    <div class="d-flex align-items-center">
                                        <img src="{{ $course->thumbnail ? asset('storage/' . $course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                             alt="{{ $course->title }}" class="rounded me-3" width="60" height="40">
                                        <div>
                                            <a href="{{ route('instructor.courses.edit', $course->id) }}" class="text-decoration-none text-dark fw-medium course-title">
                                                {{ $course->title }}
                                            </a>
                                            <div class="text-muted small">
                                                <i class="fas fa-clock me-1"></i>{{ $course->total_duration ?? 0 }} hrs 
                                                <i class="fas fa-list ms-2 me-1"></i>{{ $course->sections->count() }} sections
                                                <i class="fas fa-file-alt ms-2 me-1"></i>{{ $course->sections->flatMap->lessons->count() }} lessons
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <span class="badge bg-light text-dark">
                                        {{ $course->category->name ?? 'Uncategorized' }}
                                    </span>
                                </td>
                                <td class="align-middle">
                                    <span class="badge bg-{{ $course->is_published ? 'success' : 'warning' }}">
                                        {{ $course->is_published ? 'Published' : 'Draft' }}
                                    </span>
                                </td>
                                <td class="align-middle text-center">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-users text-muted me-2"></i>
                                        <span>{{ $course->total_students }}</span>
                                    </div>
                                </td>
                                <td class="align-middle text-center">
                                    <div class="d-flex align-items-center">
                                        <div class="text-warning me-1">
                                            <i class="fas fa-star small"></i>
                                        </div>
                                        <span>{{ number_format($course->average_rating, 1) }}</span>
                                        <span class="text-muted small ms-1">({{ $course->reviews_count ?? 0 }})</span>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    @if($course->price == 0)
                                    <span class="text-success">Free</span>
                                    @elseif($course->discount_price && $course->discount_ends_at > now())
                                    <span>${{ number_format($course->discount_price, 2) }}</span>
                                    <del class="text-muted small d-block">${{ number_format($course->price, 2) }}</del>
                                    @else
                                    <span>${{ number_format($course->price, 2) }}</span>
                                    @endif
                                </td>
                                <td class="align-middle">
                                    <div class="d-flex flex-column">
                                        <span>{{ $course->created_at->format('M d, Y') }}</span>
                                        <small class="text-muted">{{ $course->created_at->diffForHumans() }}</small>
                                    </div>
                                </td>
                                <td class="align-middle">
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" id="dropdownMenuButton{{ $course->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            Actions
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton{{ $course->id }}">
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.edit', $course->id) }}"><i class="fas fa-edit me-2"></i>Edit</a></li>
                                            <li><a class="dropdown-item" href="{{ route('courses.show', $course->slug) }}" target="_blank"><i class="fas fa-eye me-2"></i>View</a></li>
                                            <li>
                                                <form action="{{ route('instructor.courses.togglePublish', $course->id) }}" method="POST">
                                                    @csrf
                                                    <button type="submit" class="dropdown-item">
                                                        <i class="fas {{ $course->is_published ? 'fa-eye-slash' : 'fa-eye' }} me-2"></i>
                                                        {{ $course->is_published ? 'Unpublish' : 'Publish' }}
                                                    </button>
                                                </form>
                                            </li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.students', $course->id) }}"><i class="fas fa-users me-2"></i>Students</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.reviews', $course->id) }}"><i class="fas fa-star me-2"></i>Reviews</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.questions', $course->id) }}"><i class="fas fa-question-circle me-2"></i>Q&A</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.announcements', $course->id) }}"><i class="fas fa-bullhorn me-2"></i>Announcements</a></li>
                                            <li><a class="dropdown-item" href="{{ route('instructor.courses.coupons', $course->id) }}"><i class="fas fa-tags me-2"></i>Coupons</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <p class="text-muted mb-0">Showing {{ $courses->firstItem() ?? 0 }}-{{ $courses->lastItem() ?? 0 }} of {{ $courses->total() }} courses</p>
            </div>
            <div>
                {{ $courses->links('pagination::bootstrap-5') }}
            </div>
        </div>

        <!-- Course Performance Overview -->
        <div class="row mt-5">
            <div class="col-12">
                <h4 class="mb-4">Performance Overview</h4>
            </div>
        </div>
        <div class="row g-4 mb-4">
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0">Top Performing Courses</h5>
                    </div>
                    <div class="card-body">
                        @if($courses->count() > 0)
                            <div class="table-responsive overflow-visible">
                                <table class="table table-borderless">
                                    <thead>
                                        <tr>
                                            <th>Course</th>
                                            <th>Students</th>
                                            <th>Rating</th>
                                            <th>Revenue</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $topCourses = $courses->sortByDesc('total_students')->take(5);
                                        @endphp
                                        @forelse($topCourses as $course)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ $course->thumbnail ? asset('storage/' . $course->thumbnail) : asset('assets/images/course-placeholder.jpg') }}" 
                                                        alt="{{ $course->title }}" class="rounded me-2" width="40" height="30">
                                                    <div class="text-truncate" style="max-width: 150px;">{{ $course->title }}</div>
                                                </div>
                                            </td>
                                            <td>{{ $course->total_students }}</td>
                                            <td>
                                                <div class="text-warning">
                                                    <i class="fas fa-star small"></i>
                                                    <span>{{ number_format($course->average_rating, 1) }}</span>
                                                </div>
                                            </td>
                                            <td>
                                                @php
                                                    $revenue = $course->enrollments_sum_price_paid ?? 0;
                                                @endphp
                                                ${{ number_format($revenue, 2) }}
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="4" class="text-center">No data available</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-3">
                                <p class="text-muted mb-0">No courses available</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0">Recent Activities</h5>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            @forelse($courses as $course)
                                @if($loop->index < 5)
                                <div class="timeline-item">
                                    <div class="timeline-item-marker">
                                        <div class="timeline-item-marker-text">{{ $course->updated_at->format('M d') }}</div>
                                        <div class="timeline-item-marker-indicator bg-primary"></div>
                                    </div>
                                    <div class="timeline-item-content">
                                        Course "{{ $course->title }}" was {{ $course->created_at->format('Y-m-d') == $course->updated_at->format('Y-m-d') ? 'created' : 'updated' }}
                                        <div class="text-muted small">{{ $course->updated_at->diffForHumans() }}</div>
                                    </div>
                                </div>
                                @endif
                            @empty
                                <div class="text-center py-3">
                                    <p class="text-muted mb-0">No recent activities</p>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @else
            <!-- Empty State -->
            <div class="text-center py-5">
                <i class="fas fa-book-open fa-4x text-muted mb-4"></i>
                <h4>No Courses Yet</h4>
                <p class="text-muted mb-4">You haven't created any courses yet. Start creating your first course now!</p>
                <a href="{{ route('instructor.courses.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus-circle me-2"></i>Create Your First Course
                </a>
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
    /* Timeline styles */
    .timeline {
        position: relative;
        padding-left: 1.5rem;
    }

    .timeline::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0.625rem;
        height: 100%;
        width: 2px;
        background-color: #dee2e6;
    }

    .timeline-item {
        position: relative;
        margin-bottom: 1.5rem;
    }

    .timeline-item:last-child {
        margin-bottom: 0;
    }

    .timeline-item-marker {
        position: absolute;
        left: -1.5rem;
        width: 1.5rem;
    }

    .timeline-item-marker-text {
        position: absolute;
        left: -2.5rem;
        width: 3.5rem;
        text-align: right;
        color: #6c757d;
        font-size: 0.75rem;
        white-space: nowrap;
    }

    .timeline-item-marker-indicator {
        position: absolute;
        top: 0.25rem;
        left: 0.625rem;
        height: 0.75rem;
        width: 0.75rem;
        border-radius: 50%;
        transform: translateX(-50%);
    }

    .timeline-item-content {
        padding-left: 0.75rem;
        padding-bottom: 1.5rem;
        border-left: 2px solid transparent;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        // Search functionality
        $('#searchButton').on('click', function() {
            const searchTerm = $('#searchCourse').val().toLowerCase();
            
            $('.course-row').each(function() {
                const courseTitle = $(this).find('.course-title').text().toLowerCase();
                
                if (courseTitle.includes(searchTerm)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        
        // Filter functionality
        $('#filterCourses').on('change', function() {
            const filterValue = $(this).val();
            
            switch(filterValue) {
                case 'published':
                case 'draft':
                    $('.course-row').each(function() {
                        if ($(this).data('status') === filterValue) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                    break;
                
                case 'newest':
                    sortTableByDate(true);
                    break;
                    
                case 'oldest':
                    sortTableByDate(false);
                    break;
                    
                case 'popular':
                    sortTableByColumn('students', true);
                    break;
                    
                case 'rated':
                    sortTableByColumn('rating', true);
                    break;
                    
                case 'all':
                default:
                    $('.course-row').show();
                    sortTableByDate(true); // Default to newest first
                    break;
            }
        });
        
        // Sort table by date
        function sortTableByDate(descending = true) {
            const rows = $('#courseTable tbody tr').get();
            
            rows.sort(function(a, b) {
                const dateA = $(a).data('created');
                const dateB = $(b).data('created');
                
                if (descending) {
                    return dateB - dateA;
                } else {
                    return dateA - dateB;
                }
            });
            
            $.each(rows, function(index, row) {
                $('#courseTable tbody').append(row);
            });
            
            $('.course-row').show();
        }
        
        // Sort table by column
        function sortTableByColumn(column, descending = true) {
            const rows = $('#courseTable tbody tr').get();
            
            rows.sort(function(a, b) {
                const valueA = $(a).data(column);
                const valueB = $(b).data(column);
                
                if (descending) {
                    return valueB - valueA;
                } else {
                    return valueA - valueB;
                }
            });
            
            $.each(rows, function(index, row) {
                $('#courseTable tbody').append(row);
            });
            
            $('.course-row').show();
        }
    });
</script>
@endpush
@endsection