@extends('front_end.layouts.home')

@php
$showRightSidebar = false;
@endphp
@section('title', 'Course Marketplace')

@section('left_sidebar')
@include('front_end.pages.courses.courses_left_sidebar')
@endsection

@section('content')
<div class="bg-white shadow-sm border-0 rounded-3">
    <!-- Header Section -->
    <div class="card border-0 mb-4">
        <div class="card-body p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="bg-primary text-white p-4 rounded-top-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ url('/') }}" class="text-white me-3">
                                    <i class="fas fa-arrow-left fa-lg"></i>
                                </a>
                                <div>
                                    <h4 class="mb-0 text-white">Course Marketplace</h4>
                                    <p class="mb-0 text-white">Discover, learn, and grow with our expert-led courses</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('instructor.dashboard') }}" class="btn btn-info">
                                    <i class="fas fa-chalkboard-teacher me-2"></i>Become an Instructor
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
        <!-- Categories Section -->
        <div class="row mb-5">
            <div class="col-12">
                <h3 class="mb-4">Browse Categories</h3>
                <div class="row g-3">
                    @foreach($categories as $category)
                    <div class="col-md-3 col-sm-6">
                        <a href="{{ route('courses.category', $category->slug) }}" class="text-decoration-none">
                            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                                <div class="card-body text-center p-4">
                                    <div class="rounded-circle bg-primary bg-opacity-10 p-3 mx-auto mb-3" style="width: 62px; height: 62px;">
                                        <i class="{{ $category->icon ?? 'fas fa-bookmark' }} fa-2x text-primary"></i>
                                    </div>
                                    <h5 class="card-title">{{ $category->name }}</h5>
                                    <p class="text-muted small mb-0">{{ $category->courses_count ?? 0 }} courses</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Featured Courses -->
        @if($featuredCourses->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Featured Courses</h3>
                    <a href="{{ route('courses.search') }}?featured=1" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($featuredCourses as $course)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Popular Courses -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Most Popular</h3>
                    <a href="{{ route('courses.search') }}?sort=popularity" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($popularCourses as $course)
                    <div class="col-lg-4 col-md-6">
                        @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- New Courses -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Newest Courses</h3>
                    <a href="{{ route('courses.search') }}?sort=newest" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($newestCourses as $course)
                    <div class="col-lg-4 col-md-6">
                        @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Top Rated Courses -->
        @if($topRatedCourses->count() > 0)
        <div class="row mb-5">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h3 class="mb-0">Top Rated</h3>
                    <a href="{{ route('courses.search') }}?sort=rating" class="btn btn-sm btn-outline-primary">View All</a>
                </div>
                <div class="row g-4">
                    @foreach($topRatedCourses as $course)
                    <div class="col-lg-3 col-md-6">
                        @include('front_end.pages.courses.partials.course_card', ['course' => $course])
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        @endif

        <!-- Become an Instructor Banner -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card border-0 bg-primary bg-opacity-10 rounded-3">
                    <div class="card-body p-5">
                        <div class="row align-items-center">
                            <div class="col-lg-8">
                                <h2 class="mb-3">Become an Instructor</h2>
                                <p class="mb-4">Share your knowledge and expertise with millions of students worldwide. Create engaging courses and earn money while making a difference.</p>
                                <a href="{{ route('instructor.dashboard') }}" class="btn btn-primary btn-lg">Start Teaching Today</a>
                            </div>
                            <div class="col-lg-4 text-center d-none d-lg-block">
                                <i class="fas fa-chalkboard-teacher fa-5x text-primary opacity-75"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Course rating initialization
    $(document).ready(function() {
        $('.course-rating').each(function() {
            const rating = $(this).data('rating');
            $(this).rateYo({
                rating: rating,
                readOnly: true,
                starWidth: "18px"
            });
        });
    });
</script>
@endpush
@endsection