<div class="bg-white shadow-sm rounded-3 p-4 mb-4">
    <h5 class="mb-3">Course Navigation</h5>
    <div class="list-group list-group-flush">
        <a href="{{ route('courses.index') }}" class="list-group-item list-group-item-action {{ Route::is('courses.index') ? 'active' : '' }}">
            <i class="fas fa-home me-2"></i>Browse Courses
        </a>
        <a href="{{ route('courses.search') }}" class="list-group-item list-group-item-action {{ Route::is('courses.search') ? 'active' : '' }}">
            <i class="fas fa-search me-2"></i>Search Courses
        </a>
        @auth
            <a href="{{ route('student.dashboard') }}" class="list-group-item list-group-item-action {{ Route::is('student.dashboard') ? 'active' : '' }}">
                <i class="fas fa-tachometer-alt me-2"></i>Student Dashboard
            </a>
            <a href="{{ route('student.myCourses') }}" class="list-group-item list-group-item-action {{ Route::is('student.myCourses') ? 'active' : '' }}">
                <i class="fas fa-graduation-cap me-2"></i>My Courses
            </a>
            <a href="{{ route('student.wishlist') }}" class="list-group-item list-group-item-action {{ Route::is('student.wishlist') ? 'active' : '' }}">
                <i class="fas fa-heart me-2"></i>Wishlist
            </a>
            <a href="{{ route('student.purchaseHistory') }}" class="list-group-item list-group-item-action {{ Route::is('student.purchaseHistory') ? 'active' : '' }}">
                <i class="fas fa-history me-2"></i>Purchase History
            </a>
            <a href="{{ route('instructor.dashboard') }}" class="list-group-item list-group-item-action {{ str_starts_with(Route::currentRouteName(), 'instructor.') ? 'active' : '' }}">
                <i class="fas fa-chalkboard-teacher me-2"></i>Instructor Dashboard
            </a>
        @else
            <a href="{{ route('login') }}" class="list-group-item list-group-item-action">
                <i class="fas fa-sign-in-alt me-2"></i>Login to Access Courses
            </a>
        @endauth
    </div>
</div>

<div class="bg-white shadow-sm rounded-3 p-4 mb-4">
    <h5 class="mb-3">Course Categories</h5>
    <div class="list-group list-group-flush">
        @php
            $categories = \App\Models\Courses\CourseCategory::where('is_active', true)->get();
        @endphp
        
        @foreach($categories as $category)
        <a href="{{ route('courses.category', $category->slug) }}" 
            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center
            {{ request()->is('courses/category/'.$category->slug) ? 'active' : '' }}">
            <span><i class="{{ $category->icon ?? 'fas fa-folder' }} me-2"></i>{{ $category->name }}</span>
            <span class="badge bg-primary rounded-pill">{{ $category->courses_count ?? 0 }}</span>
        </a>
        @endforeach
    </div>
</div>

<div class="bg-primary bg-opacity-10 shadow-sm rounded-3 p-4 mb-4">
    <h5 class="mb-3">Become an Instructor</h5>
    <p class="mb-3">Share your knowledge with students around the world and earn money.</p>
    <a href="{{ route('instructor.dashboard') }}" class="btn btn-primary w-100">Start Teaching Today</a>
</div>