@extends('front_end.layouts.home')

@section('title', $blog->title)
@php
$showRightSidebar = false;
@endphp

@section('left_sidebar')
@include('front_end.pages.blogs.blogs_left_sidebar')
@endsection

@section('meta')
<meta name="description" content="{{ $blog->description }}">
@endsection

@section('content')
<div class="container py-4">
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb bg-light py-2 px-3 rounded-pill shadow-sm">
                    <li class="breadcrumb-item"><a href="{{ route('blogs.index') }}" class="text-decoration-none">Blog</a></li>
                    @php
                        $categories = [
                            1 => 'Technology',
                            2 => 'Health',
                            3 => 'Lifestyle',
                            4 => 'Finance',
                            5 => 'Education',
                            6 => 'Travel',
                            7 => 'Food',
                            8 => 'Entertainment',
                            9 => 'Sports',
                            10 => 'Business',
                            11 => 'Science',
                            12 => 'Art',
                            13 => 'Fashion',
                            14 => 'Environment',
                            15 => 'Politics',
                        ];
                    @endphp
                    <li class="breadcrumb-item">
                        <a href="{{ route('blogs.category', strtolower($categories[$blog->category] ?? 'uncategorized')) }}" class="text-decoration-none">
                            {{ $categories[$blog->category] ?? 'Uncategorized' }}
                        </a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ Str::limit($blog->title, 30) }}</li>
                </ol>
            </nav>

            <article class="card border-0 shadow-sm rounded-lg mb-5">
                @if($blog->thumbnail)
                <div class="position-relative">
                    <img src="{{ asset('storage/' . $blog->thumbnail) }}" class="card-img-top rounded-top" alt="{{ $blog->title }}" style="max-height: 450px; object-fit: cover;">
                    <div class="position-absolute bottom-0 start-0 w-100 p-3" style="background: linear-gradient(to top, rgba(0,0,0,0.7), transparent);">
                        <span class="badge bg-primary px-3 py-2 rounded-pill">
                            {{ $categories[$blog->category] ?? 'Uncategorized' }}
                        </span>
                        <span class="text-white ms-3">
                            <i class="bi bi-calendar-date"></i> {{ $blog->created_at->format('M d, Y') }}
                        </span>
                    </div>
                </div>
                @endif
                
                <div class="card-body p-4 p-lg-5">
                    <h1 class="card-title h2 font-weight-bold mb-3">{{ $blog->title }}</h1>
                    
                    <div class="blog-details-content">
                        <div class="blog-meta">
                            @if($blog->category_id && $blog->category)
                                <span class="category">
                                    <i class="fas fa-folder"></i> 
                                    <a href="{{ route('blogs.category', $blog->category->slug) }}">{{ $blog->category->name }}</a>
                                </span>
                            @else
                                <span class="category">
                                    <i class="fas fa-folder"></i> Uncategorized
                                </span>
                            @endif
                            <span class="date"><i class="far fa-calendar-alt"></i> {{ $blog->created_at->format('M d, Y') }}</span>
                        </div>
                        
                        <div class="mb-4 p-3 bg-light rounded">
                            <p class="lead mb-0">{{ $blog->description }}</p>
                        </div>
                        
                        <div class="blog-content">
                            {!! $blog->content !!}
                        </div>
                        
                        <div class="mt-5 pt-4 border-top">
                            <div class="d-flex align-items-center">
                                <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 60px; height: 60px; font-size: 1.5rem;">
                                    {{ substr($blog->user->name ?? 'A', 0, 1) }}
                                </div>
                                <div>
                                    <h6 class="mb-1 font-weight-bold">{{ $blog->user->name ?? 'Admin' }}</h6>
                                    <p class="text-muted mb-0">Author</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
            
            @if($relatedBlogs->count() > 0)
            <div class="mb-5">
                <h3 class="mb-4 font-weight-bold border-bottom pb-3">Related Articles</h3>
                <div class="row">
                    @foreach($relatedBlogs as $relatedBlog)
                    <div class="col-md-4 mb-4">
                        <div class="card h-100 border-0 shadow-sm rounded-lg hover-shadow transition-300">
                            @if($relatedBlog->thumbnail)
                            <img src="{{ asset('storage/' . $relatedBlog->thumbnail) }}" class="card-img-top rounded-top" alt="{{ $relatedBlog->title }}" style="height: 150px; object-fit: cover;">
                            @else
                            <div class="bg-light text-center py-4 rounded-top">
                                <i class="bi bi-image text-muted" style="font-size: 2rem;"></i>
                            </div>
                            @endif
                            <div class="card-body">
                                <h6 class="card-title font-weight-bold">{{ Str::limit($relatedBlog->title, 50) }}</h6>
                                <p class="card-text text-muted small mb-3">{{ Str::limit($relatedBlog->description, 80) }}</p>
                                <a href="{{ route('blogs.show', $relatedBlog->slug) }}" class="btn btn-sm btn-outline-primary rounded-pill px-3">
                                    Read More <i class="bi bi-arrow-right ml-1"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
            
            <div class="d-flex justify-content-between align-items-center mb-5">
                <a href="{{ route('blogs.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
                    <i class="bi bi-arrow-left mr-2"></i> Back to Blogs
                </a>
                <div class="d-flex">
                    <a href="#" class="btn btn-outline-primary rounded-circle mx-1" title="Share on Facebook">
                        <i class="bi bi-facebook"></i>
                    </a>
                    <a href="#" class="btn btn-outline-info rounded-circle mx-1" title="Share on Twitter">
                        <i class="bi bi-twitter"></i>
                    </a>
                    <a href="#" class="btn btn-outline-success rounded-circle mx-1" title="Share on WhatsApp">
                        <i class="bi bi-whatsapp"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.blog-content {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #444;
}

.blog-content img {
    max-width: 100%;
    height: auto;
    margin: 1.5rem 0;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.blog-content h2, 
.blog-content h3, 
.blog-content h4 {
    margin-top: 2rem;
    margin-bottom: 1rem;
    font-weight: 700;
    color: #333;
}

.blog-content p {
    margin-bottom: 1.5rem;
}

.blog-content ul, 
.blog-content ol {
    margin-bottom: 1.5rem;
    padding-left: 2rem;
}

.blog-content blockquote {
    border-left: 4px solid #4e73df;
    padding: 1rem 1.5rem;
    background-color: #f8f9fc;
    font-style: italic;
    margin: 1.5rem 0;
    border-radius: 0 8px 8px 0;
}

.hover-shadow {
    transition: all 0.3s ease;
}
.hover-shadow:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
}
.transition-300 {
    transition: all 0.3s ease;
}
</style>
@endsection 