<script>
    $(document).ready(function() {
        $('.form-check-input, input[type=text], select, textarea, input[type=color]').on('change', function(){
            var id = $(this).attr('id');
            var value = $(this).val(); 

            var type = "string";
            var element = $(this);
            if ($(element).is('input[type="checkbox"]')) {
                type = 'boolean';
            }

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}",
                },
                type: 'POST',
                url: '{{route('backend.settings.update')}}',
                data: {
                    'name': id,
                    'value': value,
                    'type': type
                },
                success: function(data) {
                    var value_reverse = value == 0 ? 1 : 0;
                    if (data == true) {
                        if ($(element).is('input[type="checkbox"]')) {
                            $(element).attr('value', value_reverse);
                        }
                        if ($(element).is('textarea') || $(element).is('select') || $(element).is('input[type=text]')) {
                            $(element).css('background-color', '#bdffbd');
                            setTimeout(function(){
                                $(element).css('background-color', '');
                            }, 3000);
                        }
                    } else {
                        showMessage('error', 'Error!!!', 'Something went wrong');
                    }
                },
                error: function(error, status) {
                    showMessage('error', 'Error!!!', 'Unknown error');
                }
            });
        });

        $('input[type=file]').on('change', function () {
            let fileInput = $(this);
            let file = fileInput[0].files[0];
            
            if (file) {
                let formData = new FormData();
                let inputName = fileInput.attr('id');
                formData.append('file', file);
                formData.append('input_name', inputName);
                formData.append('folder', 'Config'); // Change to your desired folder

                $.ajax({
                    url: '{{route("backend.uploadFile")}}',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                    success: function (response) {
                       if(response.success){
                            $(fileInput).next('.custom-file').val(response.filename).change();
                       }
                    },
                    error: function (xhr) {
                        showMessage('error', 'Error!!!', xhr.responseJSON.message);
                    }
                });
            }
        });
    });
</script>