@extends('admin.layouts.home')

@section('title', 'Manage Reward Settings')

@section('content')
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Reward Settings</h6>
            <a href="{{ route('admin.reward-settings.create') }}" class="btn btn-primary btn-sm">
                <i class="fas fa-plus"></i> Add New Setting
            </a>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Action Type</th>
                            <th>Reward Amount</th>
                            <th>Daily Limit</th>
                            <th>Monthly Limit</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($rewardSettings as $setting)
                            <tr>
                                <td>
                                    <strong>{{ $setting->action_type }}</strong>
                                    @if($setting->description)
                                        <br><small class="text-muted">{{ $setting->description }}</small>
                                    @endif
                                </td>
                                <td>${{ number_format($setting->reward_amount, 2) }}</td>
                                <td>{{ $setting->daily_limit ?: 'Unlimited' }}</td>
                                <td>{{ $setting->monthly_limit ?: 'Unlimited' }}</td>
                                <td>
                                    @if($setting->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('admin.reward-settings.edit', $setting->id) }}" class="btn btn-info btn-sm">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <form action="{{ route('admin.reward-settings.destroy', $setting->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this reward setting?')">
                                            <i class="fas fa-trash"></i> Delete
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No reward settings found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $rewardSettings->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection 