@extends('admin.layouts.home')

@section('title', 'Edit Reward Setting')

@section('content')
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Edit Reward Setting</h6>
        </div>
        <div class="card-body">
            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.reward-settings.update', $rewardSetting->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="form-group">
                    <label for="action_type">Action Type <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="action_type" name="action_type" value="{{ old('action_type', $rewardSetting->action_type) }}" required>
                    <small class="form-text text-muted">Examples: post_create, post_like, comment_create, etc.</small>
                </div>

                <div class="form-group">
                    <label for="reward_amount">Reward Amount ($) <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="reward_amount" name="reward_amount" value="{{ old('reward_amount', $rewardSetting->reward_amount) }}" step="0.01" min="0" required>
                </div>

                <div class="form-group">
                    <label for="daily_limit">Daily Limit <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="daily_limit" name="daily_limit" value="{{ old('daily_limit', $rewardSetting->daily_limit) }}" min="0" required>
                    <small class="form-text text-muted">Maximum number of rewards per day (0 = unlimited)</small>
                </div>

                <div class="form-group">
                    <label for="monthly_limit">Monthly Limit <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="monthly_limit" name="monthly_limit" value="{{ old('monthly_limit', $rewardSetting->monthly_limit) }}" min="0" required>
                    <small class="form-text text-muted">Maximum number of rewards per month (0 = unlimited)</small>
                </div>

                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $rewardSetting->description) }}</textarea>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $rewardSetting->is_active) ? 'checked' : '' }}>
                        <label class="custom-control-label" for="is_active">Active</label>
                    </div>
                </div>

                <div class="form-group">
                    <label for="conditions">Conditions (JSON)</label>
                    <textarea class="form-control" id="conditions" name="conditions" rows="3">{{ old('conditions', is_array($rewardSetting->conditions) ? json_encode($rewardSetting->conditions) : $rewardSetting->conditions) }}</textarea>
                    <small class="form-text text-muted">Optional JSON conditions for the reward (advanced)</small>
                </div>

                <button type="submit" class="btn btn-primary">Update Reward Setting</button>
                <a href="{{ route('admin.reward-settings.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection 