@extends('admin.layouts.home')

@section('title', 'Send Email')

@section('content')
<div class="container-fluid">
    <div>
        <h3>Send E-mail</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('admin') }}">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('admin.tools.index') }}">Tools</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Send E-mail</li>
            </ol>
        </nav>
    </div>
    
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Send E-mail To Users</h5>
            
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            
            <form action="{{ route('admin.tools.send-email') }}" method="POST">
                @csrf
                
                <div class="mb-3">
                    <label for="subject" class="form-label">Subject</label>
                    <input type="text" class="form-control @error('subject') is-invalid @enderror" 
                           id="subject" name="subject" required
                           placeholder="Choose the title for your message">
                    @error('subject')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label for="message" class="form-label">Message (HTML Allowed)</label>
                    <textarea class="form-control @error('message') is-invalid @enderror" 
                              id="message" name="message" rows="6" required
                              placeholder="Write your message here"></textarea>
                    @error('message')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label for="user_type" class="form-label">Send E-mail To</label>
                    <select class="form-select @error('user_type') is-invalid @enderror" 
                            id="user_type" name="user_type" required>
                        <option value="all">All Users</option>
                        <option value="active">Active Users</option>
                        <option value="inactive">Inactive Users</option>
                        <option value="week">Not Logged in for a Week</option>
                        <option value="month">Not Logged in for a Month</option>
                        <option value="3months">Not Logged in for 3 Months</option>
                        <option value="6months">Not Logged in for 6 Months</option>
                        <option value="12months">Not Logged in for a Year</option>
                        <option value="specific">Specific Users</option>
                    </select>
                    @error('user_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3" id="specific_users_div" style="display: none;">
                    <label for="specific_users" class="form-label">Search Users (Optional)</label>
                    <input type="text" class="form-control" id="specific_users" name="specific_users"
                           placeholder="Send only to these users, leave it empty to send to all users">
                    <small class="form-text text-muted">Enter usernames or emails separated by commas</small>
                </div>
                
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="test_message" name="test_message">
                        <label class="form-check-label" for="test_message">
                            Test Message (Send to my email first)
                        </label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Send</button>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('user_type').addEventListener('change', function() {
        const specificUsersDiv = document.getElementById('specific_users_div');
        specificUsersDiv.style.display = this.value === 'specific' ? 'block' : 'none';
    });
</script>
@endpush
@endsection