@extends('admin.layouts.home')

@section('title', 'Data Management Tools')

@section('content')
<div class="container-fluid">
    <div>
        <h3>Data Management Tools</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('home') }}">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('admin.tools.index') }}">Tools</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Data Management</li>
            </ol>
        </nav>
    </div>
    
    <div class="row">
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Auto Delete Website Data</h5>
                    
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> It's recommended to create a backup before applying any actions.
                        <a href="{{ route('admin.tools.backup') }}" class="alert-link">Create a backup</a>
                    </div>
                    
                    <form action="{{ route('admin.tools.delete') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="delete_option" class="form-label">Select what you would like to delete</label>
                            <select class="form-select" id="delete_option" name="delete_option" required>
                                <optgroup label="User Data">
                                    <option value="1">Delete all inactive users</option>
                                    <option value="2">Delete users that are not logged in more than 1 week</option>
                                    <option value="3">Delete users that are not logged in more than 1 month</option>
                                    <option value="4">Delete users that are not logged in more than 1 year</option>
                                </optgroup>
                                <optgroup label="Post Data">
                                    <option value="5">Delete posts that are older than 1 week</option>
                                    <option value="6">Delete posts that are older than 1 month</option>
                                    <option value="7">Delete posts that are older than 1 year</option>
                                </optgroup>
                                <optgroup label="Social Data">
                                    <option value="8">Delete pending friend requests older than 1 month</option>
                                    <option value="9">Delete comments older than 1 month</option>
                                    <option value="10">Delete notifications older than 1 month</option>
                                </optgroup>
                                <optgroup label="Job Data">
                                    <option value="11">Delete rejected job applications older than 3 months</option>
                                    <option value="12">Delete all expired job applications</option>
                                </optgroup>
                            </select>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> This process might take some time, and the changes cannot be undone. Please proceed with caution.
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this data? This action cannot be undone.');">
                                <i class="fas fa-trash-alt"></i> Delete Data
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Database Management</h5>
                    
                    <div class="list-group">
                        <a href="{{ route('admin.tools.backup') }}" class="list-group-item list-group-item-action">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1"><i class="fas fa-database"></i> Database Backup</h6>
                                <small><i class="fas fa-chevron-right"></i></small>
                            </div>
                            <p class="mb-1">Create a backup of your database to prevent data loss.</p>
                        </a>
                        
                        <a href="{{ route('admin.tools.backups') }}" class="list-group-item list-group-item-action">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1"><i class="fas fa-list"></i> View Backups</h6>
                                <small><i class="fas fa-chevron-right"></i></small>
                            </div>
                            <p class="mb-1">View and manage your existing database backups.</p>
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-body">
                    <h5 class="card-title">System Information</h5>
                    
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th scope="row">PHP Version</th>
                                <td>{{ phpversion() }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Laravel Version</th>
                                <td>{{ app()->version() }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Server</th>
                                <td>{{ $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown' }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Database</th>
                                <td>{{ config('database.connections.mysql.driver') }} ({{ config('database.connections.mysql.database') }})</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 