@extends('admin.layouts.home')

@section('title', 'Database Backups')

@section('content')
<div class="container-fluid">
    <div>
        <h3>Database Backups</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('home') }}">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('admin.tools.index') }}">Tools</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Database Backups</li>
            </ol>
        </nav>
    </div>
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h5 class="card-title">Available Backups</h5>
                        <a href="{{ route('admin.tools.backup') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Create New Backup
                        </a>
                    </div>
                    
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    @if(count($backups) > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Backup Name</th>
                                        <th>Size</th>
                                        <th>Created At</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($backups as $backup)
                                        <tr>
                                            <td>{{ $backup['name'] }}</td>
                                            <td>{{ $backup['size'] }}</td>
                                            <td>{{ $backup['date'] }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('admin.tools.download-backup', ['filename' => $backup['name']]) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-download"></i> Download
                                                    </a>
                                                    <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete('{{ $backup['name'] }}')">
                                                        <i class="fas fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                                
                                                <form id="delete-form-{{ str_replace('.', '-', $backup['name']) }}" action="{{ route('admin.tools.delete-backup', ['filename' => $backup['name']]) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> No backups found. <a href="{{ route('admin.tools.backup') }}" class="alert-link">Create a backup</a> to protect your data.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    function confirmDelete(filename) {
        if (confirm('Are you sure you want to delete this backup? This action cannot be undone.')) {
            document.getElementById('delete-form-' + filename.replace('.', '-')).submit();
        }
    }
</script>
@endpush 