@extends('admin.layouts.home')

@section('title', 'Database Backup')

@section('content')
<div class="container-fluid">
    <div>
        <h3>Database Backup</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ url('admin') }}">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ route('admin.tools.index') }}">Tools</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Database Backup</li>
            </ol>
        </nav>
    </div>
    
    <div class="row">
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Create Database Backup</h5>
                    
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> Creating a backup will save a copy of your entire database. This process may take some time depending on the size of your database.
                    </div>
                    
                    <form action="{{ route('admin.tools.generate-backup') }}" method="POST">
                        @csrf
                        
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> During the backup process, your website might experience slower performance. It's recommended to create backups during low traffic periods.
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-database"></i> Create Backup
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Backup Information</h5>
                    
                    <div class="list-group">
                        <a href="{{ route('admin.tools.backups') }}" class="list-group-item list-group-item-action">
                            <div class="d-flex w-100 justify-content-between">
                                <h6 class="mb-1"><i class="fas fa-list"></i> View Existing Backups</h6>
                                <small><i class="fas fa-chevron-right"></i></small>
                            </div>
                            <p class="mb-1">View and manage your existing database backups.</p>
                        </a>
                    </div>
                    
                    <div class="mt-4">
                        <h6>Backup Tips</h6>
                        <ul class="list-group">
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Create regular backups to prevent data loss
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Always backup before making major changes
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Store backups in multiple locations
                            </li>
                            <li class="list-group-item">
                                <i class="fas fa-check-circle text-success"></i> Test your backups regularly to ensure they work
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 