@extends('admin.layouts.home')

@section('title', 'Storage Configuration')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-cloud-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Storage Configuration</h1>
                                        <nav aria-label="breadcrumb">
                                                                                    <ol class="breadcrumb mb-0 text-white-50">
                                            <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="{{ url('admin/dashboard') }}" class="text-white-50">Dashboard</a></li>
                                            <li class="breadcrumb-item active text-white" aria-current="page">Storage Configuration</li>
                                        </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Info Alert -->
        <div class="alert alert-info mb-4">
            <i class="bi bi-info-circle-fill me-2"></i>
            <strong>Important:</strong> You can only enable one storage provider at a time. When you enable a new storage provider, the previous one will be automatically disabled.
        </div>

        <div class="row">
            <!-- Left Column -->
            <div class="col-lg-6">
                <!-- Local Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-success text-white me-3">
                                    <i class="bi bi-hdd-fill"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">Local Storage</h5>
                                    <small class="text-muted">Default file system storage</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input type="hidden" name="active_storage" value="local">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="local_storage" name="active_storage" value="local" 
                                       {{ setting('active_storage', 'local') == 'local' ? 'checked' : '' }}>
                                <label class="form-check-label" for="local_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-success py-2">
                            <i class="bi bi-check-circle-fill me-2"></i>
                            <strong>Status:</strong> 
                            @if(setting('active_storage', 'local') == 'local')
                                <span class="text-success">Active</span>
                            @else
                                <span class="text-muted">Inactive</span>
                            @endif
                        </div>
                        <p class="text-muted mb-0">
                            Files are stored on your server's local file system. This is the default and most reliable option for small to medium-sized applications.
                        </p>
                    </div>
                </div>

                <!-- AWS S3 Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-warning text-white me-3">
                                    <i class="bi bi-cloud-fill"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">Amazon S3</h5>
                                    <small class="text-muted">Cloud storage by Amazon Web Services</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="aws_storage" name="active_storage" value="aws" 
                                       {{ setting('active_storage') == 'aws' ? 'checked' : '' }}>
                                <label class="form-check-label" for="aws_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="aws" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="aws">
                            
                            <div class="mb-3">
                                <label for="aws_bucket_name" class="form-label">S3 Bucket Name</label>
                                <input type="text" class="form-control" id="aws_bucket_name" name="aws_bucket_name" 
                                       value="{{ setting('aws_bucket_name') }}" required>
                                <small class="text-muted">The name of your S3 bucket</small>
                            </div>

                            <div class="mb-3">
                                <label for="aws_access_key" class="form-label">Access Key ID</label>
                                <input type="text" class="form-control" id="aws_access_key" name="aws_access_key" 
                                       value="{{ setting('aws_access_key') }}" required>
                                <small class="text-muted">Your AWS access key ID</small>
                            </div>

                            <div class="mb-3">
                                <label for="aws_secret_key" class="form-label">Secret Access Key</label>
                                <input type="password" class="form-control" id="aws_secret_key" name="aws_secret_key" 
                                       value="{{ setting('aws_secret_key') }}" required>
                                <small class="text-muted">Your AWS secret access key</small>
                            </div>

                            <div class="mb-3">
                                <label for="aws_region" class="form-label">Region</label>
                                <select class="form-select" id="aws_region" name="aws_region" required>
                                    <option value="">Select Region</option>
                                    <option value="us-east-1" {{ setting('aws_region') == 'us-east-1' ? 'selected' : '' }}>US East (N. Virginia) - us-east-1</option>
                                    <option value="us-east-2" {{ setting('aws_region') == 'us-east-2' ? 'selected' : '' }}>US East (Ohio) - us-east-2</option>
                                    <option value="us-west-1" {{ setting('aws_region') == 'us-west-1' ? 'selected' : '' }}>US West (N. California) - us-west-1</option>
                                    <option value="us-west-2" {{ setting('aws_region') == 'us-west-2' ? 'selected' : '' }}>US West (Oregon) - us-west-2</option>
                                    <option value="ap-south-1" {{ setting('aws_region') == 'ap-south-1' ? 'selected' : '' }}>Asia Pacific (Mumbai) - ap-south-1</option>
                                    <option value="ap-southeast-1" {{ setting('aws_region') == 'ap-southeast-1' ? 'selected' : '' }}>Asia Pacific (Singapore) - ap-southeast-1</option>
                                    <option value="ap-southeast-2" {{ setting('aws_region') == 'ap-southeast-2' ? 'selected' : '' }}>Asia Pacific (Sydney) - ap-southeast-2</option>
                                    <option value="ap-northeast-1" {{ setting('aws_region') == 'ap-northeast-1' ? 'selected' : '' }}>Asia Pacific (Tokyo) - ap-northeast-1</option>
                                    <option value="eu-west-1" {{ setting('aws_region') == 'eu-west-1' ? 'selected' : '' }}>Europe (Ireland) - eu-west-1</option>
                                    <option value="eu-central-1" {{ setting('aws_region') == 'eu-central-1' ? 'selected' : '' }}>Europe (Frankfurt) - eu-central-1</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="aws_endpoint" class="form-label">Custom Endpoint (Optional)</label>
                                <input type="text" class="form-control" id="aws_endpoint" name="aws_endpoint" 
                                       value="{{ setting('aws_endpoint') }}" placeholder="https://your-custom-endpoint.com">
                                <small class="text-muted">For S3-compatible services like MinIO, DigitalOcean Spaces, etc.</small>
                            </div>

                            <div class="mb-3">
                                <label for="aws_cloudfront_domain" class="form-label">CloudFront Domain (Optional)</label>
                                <input type="text" class="form-control" id="aws_cloudfront_domain" name="aws_cloudfront_domain" 
                                       value="{{ setting('aws_cloudfront_domain') }}" placeholder="your-distribution.cloudfront.net">
                                <small class="text-muted">For CDN acceleration</small>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update AWS Settings
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Wasabi Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-info text-white me-3">
                                    <i class="bi bi-cloud-fill"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">Wasabi Storage</h5>
                                    <small class="text-muted">High-performance cloud storage</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="wasabi_storage" name="active_storage" value="wasabi" 
                                       {{ setting('active_storage') == 'wasabi' ? 'checked' : '' }}>
                                <label class="form-check-label" for="wasabi_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="wasabi" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="wasabi">
                            
                            <div class="mb-3">
                                <label for="wasabi_bucket_name" class="form-label">Wasabi Bucket Name</label>
                                <input type="text" class="form-control" id="wasabi_bucket_name" name="wasabi_bucket_name" 
                                       value="{{ setting('wasabi_bucket_name') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="wasabi_access_key" class="form-label">Access Key</label>
                                <input type="text" class="form-control" id="wasabi_access_key" name="wasabi_access_key" 
                                       value="{{ setting('wasabi_access_key') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="wasabi_secret_key" class="form-label">Secret Key</label>
                                <input type="password" class="form-control" id="wasabi_secret_key" name="wasabi_secret_key" 
                                       value="{{ setting('wasabi_secret_key') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="wasabi_region" class="form-label">Region</label>
                                <select class="form-select" id="wasabi_region" name="wasabi_region" required>
                                    <option value="">Select Region</option>
                                    <option value="us-east-1" {{ setting('wasabi_region') == 'us-east-1' ? 'selected' : '' }}>US East (N. Virginia) - us-east-1</option>
                                    <option value="us-east-2" {{ setting('wasabi_region') == 'us-east-2' ? 'selected' : '' }}>US East (Ohio) - us-east-2</option>
                                    <option value="us-west-1" {{ setting('wasabi_region') == 'us-west-1' ? 'selected' : '' }}>US West (Oregon) - us-west-1</option>
                                    <option value="eu-central-1" {{ setting('wasabi_region') == 'eu-central-1' ? 'selected' : '' }}>Europe (Amsterdam) - eu-central-1</option>
                                    <option value="ap-southeast-1" {{ setting('wasabi_region') == 'ap-southeast-1' ? 'selected' : '' }}>Asia Pacific (Singapore) - ap-southeast-1</option>
                                    <option value="ap-northeast-1" {{ setting('wasabi_region') == 'ap-northeast-1' ? 'selected' : '' }}>Asia Pacific (Tokyo) - ap-northeast-1</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Wasabi Settings
                            </button>
                        </form>
                    </div>
                </div>

                <!-- DigitalOcean Spaces -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-droplet-fill"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">DigitalOcean Spaces</h5>
                                    <small class="text-muted">S3-compatible object storage</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="digitalocean_storage" name="active_storage" value="digitalocean" 
                                       {{ setting('active_storage') == 'digitalocean' ? 'checked' : '' }}>
                                <label class="form-check-label" for="digitalocean_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="digitalocean" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="digitalocean">
                            
                            <div class="mb-3">
                                <label for="do_spaces_key" class="form-label">Spaces Key</label>
                                <input type="text" class="form-control" id="do_spaces_key" name="do_spaces_key" 
                                       value="{{ setting('do_spaces_key') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="do_spaces_secret" class="form-label">Spaces Secret</label>
                                <input type="password" class="form-control" id="do_spaces_secret" name="do_spaces_secret" 
                                       value="{{ setting('do_spaces_secret') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="do_spaces_name" class="form-label">Space Name</label>
                                <input type="text" class="form-control" id="do_spaces_name" name="do_spaces_name" 
                                       value="{{ setting('do_spaces_name') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="do_spaces_region" class="form-label">Region</label>
                                <select class="form-select" id="do_spaces_region" name="do_spaces_region" required>
                                    <option value="">Select Region</option>
                                    <option value="nyc3" {{ setting('do_spaces_region') == 'nyc3' ? 'selected' : '' }}>New York 3 - nyc3</option>
                                    <option value="ams3" {{ setting('do_spaces_region') == 'ams3' ? 'selected' : '' }}>Amsterdam 3 - ams3</option>
                                    <option value="sgp1" {{ setting('do_spaces_region') == 'sgp1' ? 'selected' : '' }}>Singapore 1 - sgp1</option>
                                    <option value="fra1" {{ setting('do_spaces_region') == 'fra1' ? 'selected' : '' }}>Frankfurt 1 - fra1</option>
                                    <option value="sfo3" {{ setting('do_spaces_region') == 'sfo3' ? 'selected' : '' }}>San Francisco 3 - sfo3</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update DigitalOcean Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="col-lg-6">
                <!-- Google Cloud Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-danger text-white me-3">
                                    <i class="bi bi-google"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">Google Cloud Storage</h5>
                                    <small class="text-muted">Google's object storage service</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="google_storage" name="active_storage" value="google" 
                                       {{ setting('active_storage') == 'google' ? 'checked' : '' }}>
                                <label class="form-check-label" for="google_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="google" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="google">
                            
                            <div class="mb-3">
                                <label for="google_project_id" class="form-label">Project ID</label>
                                <input type="text" class="form-control" id="google_project_id" name="google_project_id" 
                                       value="{{ setting('google_project_id') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="google_bucket_name" class="form-label">Bucket Name</label>
                                <input type="text" class="form-control" id="google_bucket_name" name="google_bucket_name" 
                                       value="{{ setting('google_bucket_name') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="google_credentials" class="form-label">Service Account JSON</label>
                                <textarea class="form-control" id="google_credentials" name="google_credentials" 
                                          rows="4" placeholder="Paste your service account JSON here">{{ setting('google_credentials') }}</textarea>
                                <small class="text-muted">Paste the entire JSON content from your service account key file</small>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Google Cloud Settings
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Azure Blob Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-microsoft"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">Azure Blob Storage</h5>
                                    <small class="text-muted">Microsoft's cloud storage service</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="azure_storage" name="active_storage" value="azure" 
                                       {{ setting('active_storage') == 'azure' ? 'checked' : '' }}>
                                <label class="form-check-label" for="azure_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="azure" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="azure">
                            
                            <div class="mb-3">
                                <label for="azure_account_name" class="form-label">Storage Account Name</label>
                                <input type="text" class="form-control" id="azure_account_name" name="azure_account_name" 
                                       value="{{ setting('azure_account_name') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="azure_account_key" class="form-label">Storage Account Key</label>
                                <input type="password" class="form-control" id="azure_account_key" name="azure_account_key" 
                                       value="{{ setting('azure_account_key') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="azure_container" class="form-label">Container Name</label>
                                <input type="text" class="form-control" id="azure_container" name="azure_container" 
                                       value="{{ setting('azure_container') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="azure_endpoint" class="form-label">Endpoint (Optional)</label>
                                <input type="text" class="form-control" id="azure_endpoint" name="azure_endpoint" 
                                       value="{{ setting('azure_endpoint') }}" placeholder="https://your-account.blob.core.windows.net">
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update Azure Settings
                            </button>
                        </form>
                    </div>
                </div>

                <!-- FTP Storage -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-secondary text-white me-3">
                                    <i class="bi bi-hdd-network"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-0">FTP Storage</h5>
                                    <small class="text-muted">Traditional FTP server storage</small>
                                </div>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input storage-toggle" type="checkbox" 
                                       id="ftp_storage" name="active_storage" value="ftp" 
                                       {{ setting('active_storage') == 'ftp' ? 'checked' : '' }}>
                                <label class="form-check-label" for="ftp_storage"></label>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="storage-form" data-storage="ftp" method="POST" action="{{ route('admin.storage.update') }}">
                            @csrf
                            <input type="hidden" name="storage_type" value="ftp">
                            
                            <div class="mb-3">
                                <label for="ftp_host" class="form-label">FTP Hostname</label>
                                <input type="text" class="form-control" id="ftp_host" name="ftp_host" 
                                       value="{{ setting('ftp_host') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="ftp_username" class="form-label">FTP Username</label>
                                <input type="text" class="form-control" id="ftp_username" name="ftp_username" 
                                       value="{{ setting('ftp_username') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="ftp_password" class="form-label">FTP Password</label>
                                <input type="password" class="form-control" id="ftp_password" name="ftp_password" 
                                       value="{{ setting('ftp_password') }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="ftp_port" class="form-label">FTP Port</label>
                                <input type="number" class="form-control" id="ftp_port" name="ftp_port" 
                                       value="{{ setting('ftp_port', 21) }}" required>
                                <small class="text-muted">Default: 21 (FTP) or 22 (SFTP)</small>
                            </div>

                            <div class="mb-3">
                                <label for="ftp_root" class="form-label">FTP Root Path</label>
                                <input type="text" class="form-control" id="ftp_root" name="ftp_root" 
                                       value="{{ setting('ftp_root', '/') }}" placeholder="/public_html/uploads">
                                <small class="text-muted">The root directory for file uploads</small>
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="ftp_ssl" name="ftp_ssl" 
                                           value="1" {{ setting('ftp_ssl') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="ftp_ssl">
                                        Use SFTP (SSH File Transfer Protocol)
                                    </label>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-save me-1"></i> Update FTP Settings
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Storage Test Section -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-info text-white me-3">
                                <i class="bi bi-bug"></i>
                            </div>
                            <h5 class="card-title mb-0">Test Storage Connection</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info py-2">
                            <i class="bi bi-info-circle-fill me-2"></i>
                            Test your storage configuration to ensure it's working properly.
                        </div>

                        <div class="mb-3">
                            <label for="test_file" class="form-label">Test File</label>
                            <input type="file" class="form-control" id="test_file" accept="image/*">
                            <small class="text-muted">Select a small image file to test upload</small>
                        </div>

                        <button type="button" class="btn btn-primary" id="test_storage">
                            <i class="bi bi-play-fill me-1"></i> Test Connection
                        </button>

                        <div id="test_results" class="mt-3" style="display: none;">
                            <div class="alert" id="test_alert">
                                <div id="test_message"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Changes Button -->
        <div class="row mt-3 mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="mb-0"><i class="bi bi-info-circle me-1"></i> Storage configuration changes will be applied immediately.</p>
                            </div>
                            <div>
                                <button type="button" class="btn btn-outline-secondary me-2" id="reset_storage">
                                    <i class="bi bi-arrow-counterclockwise me-1"></i> Reset to Default
                                </button>
                                <button type="button" class="btn btn-success" id="save_all_storage">
                                    <i class="bi bi-save me-1"></i> Save All Settings
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    // Storage toggle functionality
    $('.storage-toggle').change(function() {
        const storageType = $(this).val();
        const isChecked = $(this).is(':checked');
        
        // Uncheck all other storage toggles
        $('.storage-toggle').not(this).prop('checked', false);
        
        // Update active storage setting
        $.ajax({
            url: '{{ route("admin.storage.update") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                storage_type: 'active_storage',
                active_storage: isChecked ? storageType : 'local'
            },
            success: function(response) {
                if (response.success) {
                    showAlert('success', 'Storage configuration updated successfully!');
                } else {
                    showAlert('error', 'Failed to update storage configuration.');
                }
            },
            error: function() {
                showAlert('error', 'An error occurred while updating storage configuration.');
            }
        });
    });

    // Form submission
    $('.storage-form').submit(function(e) {
        e.preventDefault();
        const form = $(this);
        const formData = new FormData(this);
        
        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showAlert('success', 'Storage settings updated successfully!');
                } else {
                    showAlert('error', response.message || 'Failed to update storage settings.');
                }
            },
            error: function() {
                showAlert('error', 'An error occurred while updating storage settings.');
            }
        });
    });

    // Test storage connection
    $('#test_storage').click(function() {
        const fileInput = $('#test_file')[0];
        if (!fileInput.files.length) {
            showAlert('warning', 'Please select a test file first.');
            return;
        }

        const formData = new FormData();
        formData.append('test_file', fileInput.files[0]);
        formData.append('_token', '{{ csrf_token() }}');

        $(this).prop('disabled', true).html('<i class="bi bi-hourglass-split me-1"></i> Testing...');

        $.ajax({
            url: '{{ route("admin.storage.test") }}',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                $('#test_results').show();
                if (response.success) {
                    $('#test_alert').removeClass('alert-danger').addClass('alert-success');
                    $('#test_message').html('<i class="bi bi-check-circle-fill me-2"></i>' + response.message);
                } else {
                    $('#test_alert').removeClass('alert-success').addClass('alert-danger');
                    $('#test_message').html('<i class="bi bi-x-circle-fill me-2"></i>' + response.message);
                }
            },
            error: function() {
                $('#test_results').show();
                $('#test_alert').removeClass('alert-success').addClass('alert-danger');
                $('#test_message').html('<i class="bi bi-x-circle-fill me-2"></i>An error occurred while testing the connection.');
            },
            complete: function() {
                $('#test_storage').prop('disabled', false).html('<i class="bi bi-play-fill me-1"></i> Test Connection');
            }
        });
    });

    // Reset to default
    $('#reset_storage').click(function() {
        if (confirm('Are you sure you want to reset all storage settings to default?')) {
            $.ajax({
                url: '{{ route("admin.storage.reset") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        location.reload();
                    } else {
                        showAlert('error', 'Failed to reset storage settings.');
                    }
                },
                error: function() {
                    showAlert('error', 'An error occurred while resetting storage settings.');
                }
            });
        }
    });

    function showAlert(type, message) {
        const alertClass = type === 'success' ? 'alert-success' : 
                          type === 'error' ? 'alert-danger' : 'alert-warning';
        
        const alert = $(`
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `);
        
        $('.content-wrapper').prepend(alert);
        
        setTimeout(function() {
            alert.alert('close');
        }, 5000);
    }
});
</script>
@endpush

@include('admin.update_settings')
@endsection 