@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-file-post fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Post Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i class="bi bi-speedometer2 me-1"></i><a href="index.html" class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white" aria-current="page">Post Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Post Settings Configuration</h5>
                                <p class="text-muted mb-0">Configure post sharing, adult content, and general post settings</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Social Share Links -->
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-share"></i>
                            </div>
                            <h5 class="card-title mb-0">Social Share Links</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="social-share-settings" method="POST">
                            <!-- Twitter -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-twitter" class="form-label fw-bold mb-0">Twitter</label>
                                    <p class="text-muted mb-0 small">Share posts to Twitter.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-twitter" id="chck-twitter" {{active_value_check(setting('chck-twitter') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Facebook -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-facebook" class="form-label fw-bold mb-0">Facebook</label>
                                    <p class="text-muted mb-0 small">Share posts to Facebook.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-facebook" id="chck-facebook" {{active_value_check(setting('chck-facebook') ?? 0)}}>
                                </div>
                            </div>

                            <!-- What's app -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-whatsapp" class="form-label fw-bold mb-0">What's app</label>
                                    <p class="text-muted mb-0 small">Share posts to What's app.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-whatsapp" id="chck-whatsapp" {{active_value_check(setting('chck-whatsapp') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Pinterest -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-pinterest" class="form-label fw-bold mb-0">Pinterest</label>
                                    <p class="text-muted mb-0 small">Share posts to Pinterest.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-pinterest" id="chck-pinterest" {{active_value_check(setting('chck-pinterest') ?? 0)}}>
                                </div>
                            </div>

                            <!-- LinkedIn -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-linkedin" class="form-label fw-bold mb-0">LinkedIn</label>
                                    <p class="text-muted mb-0 small">Share posts to LinkedIn.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-linkedin" id="chck-linkedin" {{active_value_check(setting('chck-linkedin') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Telegram -->
                            <div class="mb-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <label for="chck-telegram" class="form-label fw-bold mb-0">Telegram</label>
                                    <p class="text-muted mb-0 small">Share posts to Telegram.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-telegram" id="chck-telegram" {{active_value_check(setting('chck-telegram') ?? 0)}}>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Adult Images Settings -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-shield-lock"></i>
                            </div>
                            <h5 class="card-title mb-0">Adult Images Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="adult-images-settings" method="POST">
                            <!-- Adult Images Filtration -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Adult Images Filtration</label>
                                <p class="text-muted small">Enable this feature to blur or delete posts that contain adult contents using Google AI.</p>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-adult_images" id="chck-adult_images" {{active_value_check(setting('adult_images') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Action For Adult Images -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Action For Adult Images</label>
                                <p class="text-muted small">Choose the action to do once an adult image was found.</p>
                                <select class="form-select" name="adult_images_action" id="adult_images_action">
                                    <option value="delete" {{setting('adult_images_action') == 'delete' ? 'selected' : ''}}>Delete The Image</option>
                                    <option value="blur" {{setting('adult_images_action') == 'blur' ? 'selected' : ''}}>Blur The Image</option>
                                    <option value="warn" {{setting('adult_images_action') == 'warn' ? 'selected' : ''}}>Show Warning</option>
                                </select>
                            </div>

                            <!-- Vision API key -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Vision API key</label>
                                <p class="text-muted small">Your Google Vision API Key.</p>
                                <input type="text" class="form-control" name="vision_api_key" value="{{setting('vision_api_key')}}" placeholder="Enter your API key">
                                <div class="mt-3">
                                    <p class="fw-bold mb-2">Please follow the steps below to activate the system:</p>
                                    <ol class="small">
                                        <li>Select or create a GCP project from <a href="#">Here</a></li>
                                        <li>Make sure that billing is enabled for your project From <a href="#">Here</a> Or <a href="#">Create a new billing account</a></li>
                                        <li>Enable the Cloud Vision API. From <a href="#">Here</a></li>
                                        <li>Create an API key:</li>
                                        <ul class="small">
                                            <li>Navigate to the APIs & Services → Credentials panel in GCP Console.</li>
                                            <li>Select Create credentials, then select API key from the dropdown menu.</li>
                                            <li>Click the Create button. The API key created dialog box displays your newly created key.</li>
                                        </ul>
                                    </ol>
                                    <button type="button" class="btn btn-primary btn-sm">Test API</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- General Posts & Comments Settings -->
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-gear"></i>
                            </div>
                            <h5 class="card-title mb-0">General Posts & Comments Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <form class="general-posts-settings" method="POST">
                            <!-- Memories System -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-memories" class="form-label fw-bold mb-0">Memories System</label>
                                    <p class="text-muted mb-0 small">Show post memories for users, on a yearly basis.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-memories" id="chck-memories" {{active_value_check(setting('memories') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Watermark Overlay -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-watermark" class="form-label fw-bold mb-0">Watermark Overlay</label>
                                    <p class="text-muted mb-0 small">This feature will create an overlay watermark over images & videos.<br>The used icon path is: ./themes/sunshine/img/icon.png</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-watermark" id="chck-watermark" {{active_value_check(setting('watermark') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Shout Box System -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-shoutbox" class="form-label fw-bold mb-0">Shout Box System <span class="badge bg-danger">PRO</span></label>
                                    <p class="text-muted mb-0 small">Allow users to create posts anonymously.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-shoutbox" id="chck-shoutbox" {{active_value_check(setting('shoutbox') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Colored Posts -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-colored_posts" class="form-label fw-bold mb-0">Colored Posts <span class="badge bg-danger">PRO</span></label>
                                    <p class="text-muted mb-0 small">Users can create colored posts.<br>You can manage colored version from <a href="#">Manage Colored Posts</a></p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-colored_posts" id="chck-colored_posts" {{active_value_check(setting('colored_posts') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Post Approval System -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-post_approval" class="form-label fw-bold mb-0">Post Approval System</label>
                                    <p class="text-muted mb-0 small">The post will be sent to admins and moderators for approval before publishing.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-post_approval" id="chck-post_approval" {{active_value_check(setting('post_approval') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Popular Posts & Comments -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-popular_posts" class="form-label fw-bold mb-0">Popular Posts & Comments</label>
                                    <p class="text-muted mb-0 small">Show popular posts & comments this week.<br>When enabled, you can see the link in left sidebar on the home page.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-popular_posts" id="chck-popular_posts" {{active_value_check(setting('popular_posts') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Comment Reports -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-comment_reports" class="form-label fw-bold mb-0">Comment Reports</label>
                                    <p class="text-muted mb-0 small">Allow users to report comments.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-comment_reports" id="chck-comment_reports" {{active_value_check(setting('comment_reports') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Location -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-location" class="form-label fw-bold mb-0">Location</label>
                                    <p class="text-muted mb-0 small">Allow users to post location.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-location" id="chck-location" {{active_value_check(setting('location') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Feelings -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-feelings" class="form-label fw-bold mb-0">Feelings</label>
                                    <p class="text-muted mb-0 small">Allow users to post feelings.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-feelings" id="chck-feelings" {{active_value_check(setting('feelings') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Poll -->
                            <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                                <div>
                                    <label for="chck-poll" class="form-label fw-bold mb-0">Poll <span class="badge bg-danger">PRO</span></label>
                                    <p class="text-muted mb-0 small">Allow users to post poll.</p>
                                </div>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="chck-poll" id="chck-poll" {{active_value_check(setting('poll') ?? 0)}}>
                                </div>
                            </div>

                            <!-- Max Allowed Characters Length -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Max Allowed Characters Length</label>
                                <p class="text-muted small">Set the max allowed characters for posts, comments, replies and messages.</p>
                                <select class="form-select" name="max_char" id="max_char">
                                    <option value="5000" {{setting('max_char') == '5000' ? 'selected' : ''}}>5000 Characters</option>
                                    <option value="4000" {{setting('max_char') == '4000' ? 'selected' : ''}}>4000 Characters</option>
                                    <option value="3000" {{setting('max_char') == '3000' ? 'selected' : ''}}>3000 Characters</option>
                                    <option value="2000" {{setting('max_char') == '2000' ? 'selected' : ''}}>2000 Characters</option>
                                    <option value="1000" {{setting('max_char') == '1000' ? 'selected' : ''}}>1000 Characters</option>
                                </select>
                            </div>

                            <!-- NewsFeed Posts -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">NewsFeed Posts</label>
                                <p class="text-muted small">Set how the newsfeed posts will appear for the users.</p>
                                <select class="form-select" name="newsfeed_style" id="newsfeed_style">
                                    <option value="all" {{setting('newsfeed_style') == 'all' ? 'selected' : ''}}>Show All Posts</option>
                                    <option value="following" {{setting('newsfeed_style') == 'following' ? 'selected' : ''}}>Show Following Posts</option>
                                    <option value="friends" {{setting('newsfeed_style') == 'friends' ? 'selected' : ''}}>Show Friends Posts</option>
                                </select>
                            </div>

                            <!-- Second Post Button -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Second Post Button</label>
                                <p class="text-muted small">Choose what type of reaction you want to use beside the like button. You Can manage reactions <a href="#">Here</a></p>
                                <select class="form-select" name="second_post_button" id="second_post_button">
                                    <option value="reaction" {{setting('second_post_button') == 'reaction' ? 'selected' : ''}}>Reaction System</option>
                                    <option value="dislike" {{setting('second_post_button') == 'dislike' ? 'selected' : ''}}>DisLike System</option>
                                    <option value="wonder" {{setting('second_post_button') == 'wonder' ? 'selected' : ''}}>Wonder System</option>
                                </select>
                            </div>

                            <!-- Post Limit Count -->
                            <div class="mb-3">
                                <label class="form-label fw-bold">Post Limit Count</label>
                                <p class="text-muted small">How many posts a user can create in one hour?</p>
                                <input type="number" class="form-control" name="post_limit" id="post_limit" value="{{setting('post_limit') ?? 40}}">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.update_settings')
@endsection