@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')
<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-credit-card-fill fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Payment Settings</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i
                                                        class="bi bi-speedometer2 me-1"></i><a
                                                        href="index.html"
                                                        class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white"
                                                    aria-current="page">Payment Settings</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Payment Gateway Configuration</h5>
                                <p class="text-muted mb-0">Configure your payment methods and withdrawal
                                    options</p>
                            </div>
                            <div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-info text-white me-3">
                                    <i class="bi bi-stripe"></i>
                                </div>
                                <h5 class="card-title mb-0">Configure Stripe Payment Method</h5>
                            </div>
                            <div>
                                <img src="https://upload.wikimedia.org/wikipedia/commons/e/e1/Stripe_Logo%2C_revised_2016.svg"
                                    style="width: 120px;" alt="Stripe Logo">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Stripe Payment Method</label>
                                <p class="text-muted mb-0 small">Enable Stripe to accept global card payments.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="stripe_payment" name="stripe_payment" {{active_value_check(setting('stripe_payment') ?? 1)}}>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Stripe Publishable Key</label>
                            <input type="text" id="stripe_publishable_key" name="stripe_publishable_key" class="form-control" value="{{setting('stripe_publishable_key')}}">
                            <small class="text-muted">Client-side SDKs use the publishable key.</small>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Stripe Secret Key</label>
                            <div class="alert alert-danger py-2">
                                <i class="bi bi-shield-lock me-2"></i> We never display the stored secret. Enter a new one to overwrite.
                            </div>
                            <input type="text" id="stripe_secret_key" name="stripe_secret_key" class="form-control" value="">
                            <small class="text-muted">Server-side API calls require the secret key.</small>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-warning text-white me-3">
                                    <i class="bi bi-lightning-charge"></i>
                                </div>
                                <h5 class="card-title mb-0">Configure Flutterwave Payment Method</h5>
                            </div>
                            <div>
                                <img src="https://upload.wikimedia.org/wikipedia/commons/6/68/Flutterwave_Logo.png"
                                    style="width: 110px;" alt="Flutterwave Logo">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Flutterwave Payment Method</label>
                                <p class="text-muted mb-0 small">Enable Flutterwave to accept card, bank and USSD payments.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="flutterwave_payment" name="flutterwave_payment" {{active_value_check(setting('flutterwave_payment') ?? 0)}}>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Flutterwave Mode</label>
                            <select class="form-select" id="flutterwave_mode" name="flutterwave_mode">
                                <option value="production" {{setting('flutterwave_mode') == 'production' ? 'selected' : ''}}>Live</option>
                                <option value="staging" {{setting('flutterwave_mode', 'staging') == 'staging' ? 'selected' : ''}}>Sandbox</option>
                            </select>
                            <small class="text-muted">Live uses production keys, Sandbox uses test keys (staging).</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Flutterwave Public Key</label>
                            <input type="text" id="flutterwave_public_key" name="flutterwave_public_key" class="form-control" value="{{setting('flutterwave_public_key')}}">
                            <small class="text-muted">Paste the public key provided in your Flutterwave dashboard.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Flutterwave Secret Key</label>
                            <div class="alert alert-danger py-2">
                                <i class="bi bi-shield-lock me-2"></i> For security we do not display the stored secret. Enter a new one to replace it.
                            </div>
                            <input type="text" id="flutterwave_secret_key" name="flutterwave_secret_key" class="form-control" value="">
                            <small class="text-muted">This value is required for server-to-server verification.</small>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Flutterwave Encryption Key</label>
                            <input type="text" id="flutterwave_encryption_key" name="flutterwave_encryption_key" class="form-control" value="{{setting('flutterwave_encryption_key')}}">
                            <small class="text-muted">Optional: needed for inline payments that require encryption.</small>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-success text-white me-3">
                                    <i class="bi bi-credit-card"></i>
                                </div>
                                <h5 class="card-title mb-0">Configure Paystack Payment Method</h5>
                            </div>
                            <div>
                                <img src="https://upload.wikimedia.org/wikipedia/commons/0/02/Paystack_Logo.png"
                                    style="width: 110px;" alt="Paystack Logo">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Paystack Payment Method</label>
                                <p class="text-muted mb-0 small">Enable Paystack to accept payments across Africa.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="paystack_payment" name="paystack_payment" {{active_value_check(setting('paystack_payment') ?? 0)}}>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Paystack Mode</label>
                            <select class="form-select" id="paystack_mode" name="paystack_mode">
                                <option value="live" {{setting('paystack_mode') == 'live' ? 'selected' : ''}}>Live</option>
                                <option value="test" {{setting('paystack_mode', 'test') == 'test' ? 'selected' : ''}}>Test</option>
                            </select>
                            <small class="text-muted">Live uses real transactions. Test mode uses your sandbox keys.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Paystack Public Key</label>
                            <input type="text" id="paystack_public_key" name="paystack_public_key" class="form-control" value="{{setting('paystack_public_key')}}">
                            <small class="text-muted">Used for client-side Paystack integrations.</small>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Paystack Secret Key</label>
                            <div class="alert alert-danger py-2">
                                <i class="bi bi-shield-lock me-2"></i> The current secret key is hidden. Provide a new one to rotate it.
                            </div>
                            <input type="text" id="paystack_secret_key" name="paystack_secret_key" class="form-control" value="">
                            <small class="text-muted">Server-side API calls require the secret key.</small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center">
                            <div class="icon-circle bg-primary text-white me-3">
                                <i class="bi bi-cash-coin"></i>
                            </div>
                            <h5 class="card-title mb-0">Withdrawal Settings</h5>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i> Users can send withdrawal requests
                            via any of these methods
                        </div>

                        <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Bank Withdraw</label>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="paypal_withdraw" name="paypal_withdraw" {{active_value_check(setting('bank_transfer') ?? 1)}}> 
                            </div>
                        </div>

                        <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Paypal</label>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="paypal_withdraw" name="paypal_withdraw" {{active_value_check(setting('paypal_withdraw') ?? 1)}}>
                            </div>
                        </div>

                        {{-- <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Skrill</label>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="skrill_withdrawal" name="skrill_withdrawal" {{active_value_check(setting('skrill_withdrawal') ?? 0)}}> 
                            </div>
                        </div> --}}

                        {{-- <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Custom Method</label>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="custom_withdrawal" name="custom_withdrawal" {{active_value_check(setting('custom_withdrawal') ?? 0)}}> 
                            </div>
                        </div> --}}

                        {{-- <div class="mb-3 custom_name_class d-none">
                            <label class="form-label">Custom Method Name</label>
                            <input type="text" id="custom_name" name="custom_name" class="form-control" value="{{setting('custom_name')}}">
                        </div> --}}

                        <div class="mb-3">
                            <label class="form-label">Minimum withdrawal request</label>
                            <input type="text" id="m_withdrawal" name="m_withdrawal" class="form-control" value="{{setting('m_withdrawal')}}">
                            <small class="text-muted">Minimum withdrawal the users can request</small>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white py-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="icon-circle bg-primary text-white me-3">
                                    <i class="bi bi-paypal"></i>
                                </div>
                                <h5 class="card-title mb-0">Configure PayPal Payment Method</h5>
                            </div>
                            <div>
                                <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/PayPal.svg"
                                    style="width: 100px;">
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">PayPal Payment Method</label>
                                <p class="text-muted mb-0 small">Enable PayPal to receive payments from
                                    ads and pro packages.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="cchck-paypal" name="paypal_payment" {{active_value_check(setting('paypal_payment') ?? 1)}}>
                            </div>
                        </div>

                        <div
                            class="mb-3 d-flex justify-content-between align-items-center border-bottom pb-3">
                            <div>
                                <label class="form-label fw-bold mb-0">Show Transaction Logs (All
                                    Payment Methods)</label>
                                <p class="text-muted mb-0 small">Show transaction history on user
                                    settings page.</p>
                            </div>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="chck-transaction_log" name="transaction_log" {{active_value_check(setting('transaction_log') ?? 1)}}>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">PayPal Mode</label>
                            <select class="form-select" id="paypal_mode" name="paypal_mode">
                                <option value="live" {{setting('paypal_mode') == 'live' ? 'selected' : ''}}>Live</option>
                                <option value="sandbox" {{setting('paypal_mode') == 'sandbox' ? 'selected' : ''}}>SandBox</option>

                            </select>
                            <small class="text-muted">Choose the mode your application is using, for
                                testing use the SandBox mode.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">PayPal Client ID</label>
                            <input type="text" id="paypal_id" name="paypal_id" class="form-control" value="{{setting('paypal_id')}}">
                            <small class="text-muted">Set your PayPal application ID.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">PayPal Secret Key</label>
                            <div class="alert alert-danger py-2">
                                <i class="bi bi-shield-lock me-2"></i> The secret key is not showing due
                                security reasons, you can still overwrite the current one.
                            </div>
                            <input type="text" id="paypal_secret" class="form-control" value="">
                            <small class="text-muted">Set your PayPal application secret key.</small>
                        </div>
                    </div>
                </div>

                


            </div>

         

        </div>




    </div>

    <!-- Save Changes Button -->
    
</div>
@include('admin.update_settings')
@endsection