@extends('admin.layouts.home')

@section('title', 'Dashboard')

@section('content')

<div class="container-fluid p-0">
    <div class="content-wrapper p-3">
        <!-- Page Header with Breadcrumbs -->
        <div class="content-header mb-4">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="card bg-primary text-white mb-3">
                            <div class="card-body py-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-lg rounded-circle bg-white text-primary me-3">
                                        <i class="bi bi-toggles2 fs-1"></i>
                                    </div>
                                    <div>
                                        <h1 class="m-0 fw-bold">Enable/Disable Features</h1>
                                        <nav aria-label="breadcrumb">
                                            <ol class="breadcrumb mb-0 text-white-50">
                                                <li class="breadcrumb-item"><i
                                                        class="bi bi-speedometer2 me-1"></i><a
                                                        href="index.html"
                                                        class="text-white-50">Dashboard</a></li>
                                                <li class="breadcrumb-item active text-white"
                                                    aria-current="page">Enable/Disable Features</li>
                                            </ol>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons Row -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Manage Platform Features</h5>
                                <p class="text-muted mb-0">Enable or disable features for your users</p>
                            </div>
                            <div>
                                <button type="button" class="btn btn-outline-secondary me-2">
                                    <i class="bi bi-arrow-counterclockwise me-1"></i> Reset
                                </button>
                                <button type="button" class="btn btn-success">
                                    <i class="bi bi-save me-1"></i> Save Changes
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <!-- Main Content Row -->
                <div class="row">
                    <!-- Left Column -->
                    <div class="col-md-6">
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-primary text-white me-3">
                                        <i class="bi bi-grid-3x3-gap"></i>
                                    </div>
                                    <h5 class="card-title mb-0">General Features</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Greeting System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-sun"></i>
                                            </div>
                                            <strong>Greeting System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Morning, Afternoon & Evening messages
                                                on Homepage.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="afternoon_system" name="afternoon_system" {{active_value_check(setting('afternoon_system') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>

                                <!-- Stories System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-collection"></i>
                                            </div>
                                            <strong>Stories System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable stories Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="user_stories" name="user_stories" {{active_value_check(setting('user_stories') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>

                                <!-- Games System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-success me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-controller"></i>
                                            </div>
                                            <strong>Games System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Gaming Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="games" name="games" {{active_value_check(setting('games') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>

                                <!-- Pages System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-info me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-flag"></i>
                                            </div>
                                            <strong>Pages System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Page Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="pages" name="pages" {{active_value_check(setting('pages') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>
                                <!-- Courses System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-info me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-book"></i>
                                            </div>
                                            <strong>Courses System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Courses Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="courses" name="courses" {{active_value_check(setting('courses') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>


                                <!-- Groups System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-warning me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-people"></i>
                                            </div>
                                            <strong>Groups System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Group Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="groups" name="groups" {{active_value_check(setting('groups') ?? 1)}}> 
                                        </div>
                                    </div>
                                </div>

                                <!-- Blogs System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-pencil-square"></i>
                                            </div>
                                            <strong>Blogs System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Blogs Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="blogs" name="blogs" {{active_value_check(setting('blogs') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Events System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-calendar-event"></i>
                                            </div>
                                            <strong>Events System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Events Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="events" name="events" {{active_value_check(setting('events') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Movies System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-secondary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-film"></i>
                                            </div>
                                            <strong>Movies System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Movies Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="movies" name="movies" {{active_value_check(setting('movies') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Space Section -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-info me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-people-fill"></i>
                                            </div>
                                            <strong>Space Section</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable or disable the space section on the user side
                                                in both the web and app.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="space" name="space" {{active_value_check(setting('space') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Nearby Friends System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-success me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-geo-alt"></i>
                                            </div>
                                            <strong>Nearby Friends System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to search nearby users.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="find_friends" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Jobs System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-dark me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-briefcase"></i>
                                            </div>
                                            <strong>Jobs System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Jobs Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="job_system" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Friend System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-person-plus"></i>
                                            </div>
                                            <strong>Friend System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Friend Section on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="is_friend_system" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Market Place -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-success me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-cart"></i>
                                            </div>
                                            <strong>Market Place</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Market Place Section on user Side in
                                                Web & App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="product" name="product" {{active_value_check(setting('product') ?? 1)}}>
                                        </div>
                                    </div>
                                </div>

                                <!-- Cup of Coffee -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-warning me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-cup-hot"></i>
                                            </div>
                                            <strong>Cup of Coffee</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Cup of Coffee on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="cup_of_coffee" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Great Job -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-hand-thumbs-up"></i>
                                            </div>
                                            <strong>Great Job</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Great Job on user Side in Web &
                                                App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="great_job" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Blood Donation -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-danger me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-droplet"></i>
                                            </div>
                                            <strong>Blood Donation</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Blood Donation Section on user Side in
                                                Web & App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="blood"
                                                checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Wallet -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-success me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-wallet2"></i>
                                            </div>
                                            <strong>Wallet</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable whole wallet Section on user Side in
                                                Web & App.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="wallet"
                                                checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Chat AI -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-info me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-chat-dots"></i>
                                            </div>
                                            <strong>Chat AI</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>This feature enables AI-based chat functionality for
                                                improved user interaction.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="ai"
                                                checked>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column -->
                    <div class="col-md-6">
                        <!-- Pro System Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-warning text-white me-3">
                                        <i class="bi bi-star"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Upgrade to Pro System</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Package System -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-warning me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-layers"></i>
                                            </div>
                                            <strong>Package System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Enable/Disable Package System.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="point_level_system" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Upgrade to Pro System -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-warning me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-award"></i>
                                            </div>
                                            <strong>Upgrade to Pro System</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow/Disallow update to pro system from user
                                                side.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="upgrade_to_pro_system" checked>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Email Verification Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-info text-white me-3">
                                        <i class="bi bi-envelope-check"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Email Verification System</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- User Registration -->
                                <div class="row mb-3 pb-3 border-bottom">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-primary me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-person-plus"></i>
                                            </div>
                                            <strong>Allow User Registration</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow users to create accounts on a platform or
                                                website.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="user_registration" checked>
                                        </div>
                                    </div>
                                </div>

                                <!-- Verify New Register Account -->
                                <div class="row mb-3">
                                    <div class="col-10">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="icon-circle bg-light text-success me-2"
                                                style="width: 28px; height: 28px">
                                                <i class="bi bi-patch-check"></i>
                                            </div>
                                            <strong>Verify New Register Account</strong>
                                        </div>
                                        <p class="text-muted mb-0">
                                            <small>Allow/Disallow the new register user to verify their
                                                account.</small>
                                        </p>
                                    </div>
                                    <div class="col-2 d-flex align-items-center justify-content-end">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                id="verify_email">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Feature Management Tips Card -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-white py-3">
                                <div class="d-flex align-items-center">
                                    <div class="icon-circle bg-success text-white me-3">
                                        <i class="bi bi-lightbulb"></i>
                                    </div>
                                    <h5 class="card-title mb-0">Feature Management Tips</h5>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info mb-3">
                                    <div class="d-flex">
                                        <div class="me-3">
                                            <i class="bi bi-info-circle-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <h6 class="alert-heading mb-1">Optimize User Experience</h6>
                                            <p class="mb-0 small">Enable only the features that align
                                                with your platform's goals to avoid overwhelming users.
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-warning mb-3">
                                    <div class="d-flex">
                                        <div class="me-3">
                                            <i class="bi bi-exclamation-triangle-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <h6 class="alert-heading mb-1">Performance Impact</h6>
                                            <p class="mb-0 small">Enabling too many features
                                                simultaneously may affect platform performance.</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="alert alert-success mb-0">
                                    <div class="d-flex">
                                        <div class="me-3">
                                            <i class="bi bi-check-circle-fill fs-4"></i>
                                        </div>
                                        <div>
                                            <h6 class="alert-heading mb-1">Best Practice</h6>


                                            Let me complete the Best Practice alert and add the
                                            remaining code to finish the Enable/Disable Features page:

                                            ```html
                                            <p class="mb-0 small">Regularly review enabled features and
                                                their usage statistics to determine which ones provide
                                                the most value to your users.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Save Changes Button -->
                <div class="row mt-3 mb-4">
                    <div class="col-12">
                        <div class="card bg-light">
                            <div class="card-body p-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-0"><i class="bi bi-info-circle me-1"></i> Changes
                                            will be applied immediately to all users.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>
@push('scripts')
<script>
        document.addEventListener("DOMContentLoaded", function () {
            // Toggle sidebar
            const sidebarToggle = document.querySelector(".js-sidebar-toggle");
            const sidebar = document.querySelector(".js-sidebar");
            const wrapper = document.querySelector(".wrapper");

            if (sidebarToggle) {
                sidebarToggle.addEventListener("click", function () {
                    wrapper.classList.toggle("sidebar-collapsed");
                });
            }

            // Handle sidebar menu items
            const sidebarLinks = document.querySelectorAll(".sidebar-link");
            sidebarLinks.forEach(link => {
                link.addEventListener("click", function () {
                    // Remove active class from all items
                    document.querySelectorAll(".sidebar-item").forEach(item => {
                        item.classList.remove("active");
                    });

                    // Add active class to parent item
                    if (this.closest(".sidebar-item")) {
                        this.closest(".sidebar-item").classList.add("active");
                    }
                });
            });

            // Handle responsive behavior
            function handleResponsive() {
                if (window.innerWidth < 992) {
                    wrapper.classList.add("sidebar-collapsed");
                } else {
                    wrapper.classList.remove("sidebar-collapsed");
                }
            }

            // Initial check
            handleResponsive();

            // Listen for window resize
            window.addEventListener("resize", handleResponsive);
        });
    </script>
    @endpush
    @include('admin.update_settings')
@endsection