@extends('admin-layouts.layouts')
@section('extralibrary')

@endsection
@section('content')
<h2 class="header-title">Add Gift</h2>
<div class="header-sub-title">
    {{-- <nav class="breadcrumb breadcrumb-dash">
        <a href="#" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>Home</a>
        <a class="breadcrumb-item" href="#">Components</a>
        <span class="breadcrumb-item active">Accordion</span>
    </nav> --}}
</div>
</div>
<div class="card p-3">
    <div class="row">
        <div class="col-md-6 offset-md-3">
            <h3>Create New Gift</h3>
            <form action="{{route('admin.gifts.store')}}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for=""> Price </label>
                    <input type="number" class="form-control" name="price" placeholder="Price" value="{{old('price')}}">
                    @if($errors->has('price'))
                        <p class="help-block  text-danger">
                            {{ $errors->first('price') }}
                        </p>
                    @endif
                </div>
                <div class="form-group">
                    <label for=""> Gift Image</label>
                    <input type="file" class="form-control" name="image">
                    @if($errors->has('image'))
                        <p class="help-block  text-danger">
                            {{ $errors->first('image') }}
                        </p>
                    @endif
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-success"> Submit</button>
                    <a href="{{route('admin.gifts.index')}}" class="btn btn-danger"> Back</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('jslibrary')

<script>
    $('#data-table').DataTable();
</script>
@endsection
