@extends('admin.layouts.home')

@section('title', 'Page Statistics')

@section('styles')
<style>
    .stat-card {
        transition: all 0.3s;
    }
    .stat-card:hover {
        transform: translateY(-5px);
    }
    .chart-container {
        position: relative;
        height: 300px;
        margin-bottom: 1rem;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Page Statistics</h1>
        <div>
            <a href="{{ route('admin.pages.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to All Pages
            </a>
            <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm" id="downloadReport">
                <i class="fas fa-download fa-sm text-white-50"></i> Generate Report
            </a>
        </div>
    </div>

    <!-- Overview Stats -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalPages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $activePages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Featured Pages</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $featuredPages }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-star fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2 stat-card">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Page Likes</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $totalLikes }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-thumbs-up fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- Pages by Category -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Pages by Category</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="pagesByCategoryChart"></canvas>
                    </div>
                    <div class="mt-4 text-center small">
                        @foreach($categoriesData as $index => $category)
                            <span class="mr-2">
                                <i class="fas fa-circle" style="color: {{ $categoryColors[$index % count($categoryColors)] }}"></i> {{ $category['name'] }}
                            </span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Pages Growth -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Pages Growth</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="pagesGrowthChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Second Row of Charts -->
    <div class="row">
        <!-- Most Liked Pages -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Most Liked Pages</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="mostLikedPagesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Page Activity -->
        <div class="col-xl-6 col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Page Activity (Last 30 Days)</h6>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="pageActivityChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Pages Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Top Pages</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="topPagesTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Page Name</th>
                            <th>Category</th>
                            <th>Likes</th>
                            <th>Posts</th>
                            <th>Created</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($topPages as $page)
                        <tr>
                            <td>
                                <a href="{{ route('admin.pages.show', $page->id) }}">
                                    {{ $page->page_title }}
                                </a>
                            </td>
                            <td>
                                @if($page->category)
                                    <span class="badge bg-info">{{ $page->category->name }}</span>
                                @else
                                    <span class="badge bg-secondary">Uncategorized</span>
                                @endif
                            </td>
                            <td>{{ $page->likes_count }}</td>
                            <td>{{ $page->posts_count }}</td>
                            <td>{{ $page->created_at->format('M d, Y') }}</td>
                            <td>
                                @if($page->active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-danger">Inactive</span>
                                @endif
                                @if($page->featured)
                                    <span class="badge bg-warning">Featured</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.pages.show', $page->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Chart.js configuration
    $(document).ready(function() {
        // Pages by Category Chart
        const categoryCtx = document.getElementById('pagesByCategoryChart').getContext('2d');
        const categoryChart = new Chart(categoryCtx, {
            type: 'doughnut',
            data: {
                labels: {!! json_encode(array_column($categoriesData, 'name')) !!},
                datasets: [{
                    data: {!! json_encode(array_column($categoriesData, 'count')) !!},
                    backgroundColor: {!! json_encode($categoryColors) !!},
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });

        // Pages Growth Chart
        const growthCtx = document.getElementById('pagesGrowthChart').getContext('2d');
        const growthChart = new Chart(growthCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode(array_column($growthData, 'month')) !!},
                datasets: [{
                    label: 'New Pages',
                    data: {!! json_encode(array_column($growthData, 'count')) !!},
                    fill: false,
                    borderColor: '#4e73df',
                    tension: 0.1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Most Liked Pages Chart
        const likedPagesCtx = document.getElementById('mostLikedPagesChart').getContext('2d');
        const likedPagesChart = new Chart(likedPagesCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode(array_column($topLikedPages, 'name')) !!},
                datasets: [{
                    label: 'Likes',
                    data: {!! json_encode(array_column($topLikedPages, 'likes_count')) !!},
                    backgroundColor: '#36b9cc',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Page Activity Chart
        const activityCtx = document.getElementById('pageActivityChart').getContext('2d');
        const activityChart = new Chart(activityCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode(array_column($activityData, 'date')) !!},
                datasets: [
                    {
                        label: 'Likes',
                        data: {!! json_encode(array_column($activityData, 'likes')) !!},
                        fill: false,
                        borderColor: '#f6c23e',
                        tension: 0.1
                    },
                    {
                        label: 'Posts',
                        data: {!! json_encode(array_column($activityData, 'posts')) !!},
                        fill: false,
                        borderColor: '#1cc88a',
                        tension: 0.1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Initialize DataTable
        $('#topPagesTable').DataTable({
            paging: true,
            pageLength: 5,
            lengthMenu: [[5, 10, 25, -1], [5, 10, 25, "All"]],
            ordering: true,
            info: true,
            autoWidth: false,
            responsive: true
        });

        // Download Report
        $('#downloadReport').click(function(e) {
            e.preventDefault();
            alert('Generating PDF report... This feature will be implemented soon.');
        });
    });
</script>
@endsection 